/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.screen;

import com.posics.pos.config.LAFColors;
import com.posics.pos.printer.screen.JTicket;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JPanel;

public class JTicketContainer
extends JPanel {
    protected int H_GAP = 8;
    protected int V_GAP = 8;
    protected int cols = 3;

    public JTicketContainer() {
        JTicketContainer jTicketContainer = this;
        jTicketContainer.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        jTicketContainer.setLayout(new BorderLayout());
        this.setLayout(null);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int n2 = 0;
        int n3 = insets.top + this.V_GAP;
        int n4 = this.getComponentCount();
        int n5 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < n4; ++i2) {
            Serializable serializable = this.getComponent(i2);
            serializable = serializable.getPreferredSize();
            this.cols = (Toolkit.getDefaultToolkit().getScreenSize().width - this.H_GAP - 300) / ((Dimension)serializable).width;
            if (((Dimension)serializable).width > n2) {
                n2 = ((Dimension)serializable).width;
            }
            if (arrayList.size() <= this.cols) {
                arrayList.add(((Dimension)serializable).height + this.V_GAP);
            } else {
                arrayList.set(n5, (Integer)arrayList.get(n5) + ((Dimension)serializable).height + this.V_GAP);
                if (++n5 > this.cols) {
                    n5 = 0;
                }
            }
            n3 = (Integer)Collections.max(arrayList) + this.V_GAP;
        }
        return new Dimension(n2 + 2 * this.H_GAP + insets.left + insets.right, n3 + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        int n2 = insets.left + this.H_GAP;
        int n3 = insets.top + this.V_GAP;
        int n4 = 0;
        int n5 = this.getComponentCount();
        int[] nArray = new int[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            Component component = this.getComponent(i2);
            Dimension dimension = component.getPreferredSize();
            this.cols = (Toolkit.getDefaultToolkit().getScreenSize().width - this.H_GAP - 300) / dimension.width;
            if (i2 > this.cols) {
                nArray[i2] = dimension.height + this.V_GAP;
                int n6 = i2;
                nArray[n6] = nArray[n6] + nArray[i2 - this.cols - 1];
                n3 = nArray[i2 - this.cols - 1];
            } else {
                nArray[i2] = dimension.height + this.V_GAP + this.V_GAP;
            }
            component.setBounds(n2, n3, dimension.width, dimension.height);
            n2 += this.H_GAP + dimension.width;
            if (++n4 <= this.cols) continue;
            n4 = 0;
            n2 = insets.left + this.H_GAP;
        }
    }

    public void addTicket(JTicket jTicket) {
        this.add(jTicket);
        this.doLayout();
        this.revalidate();
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    public void removeAllTickets() {
        this.removeAll();
        this.doLayout();
        this.revalidate();
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }
}

