/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.ticket;

import com.posics.pos.printer.ticket.PrintItem;
import com.posics.pos.printer.ticket.PrintItemBarcode;
import com.posics.pos.printer.ticket.PrintItemImage;
import com.posics.pos.printer.ticket.PrintItemLine;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BasicTicket
implements PrintItem,
Serializable {
    private static final long serialVersionUID = 9110127845988L;
    protected static Font BASEFONT = new Font("Monospaced", 0, 12).deriveFont(AffineTransform.getScaleInstance(1.0, 1.4));
    protected static int FONTHEIGHT = 20;
    protected static double IMAGE_SCALE = 1.0;
    protected List<PrintItem> m_aCommands = new ArrayList<PrintItem>();
    protected PrintItemLine pil = null;
    protected int m_iBodyHeight = 0;

    @Override
    public int getHeight() {
        return this.m_iBodyHeight;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n2, int n3, int n4) {
        for (PrintItem printItem : this.m_aCommands) {
            printItem.draw(graphics2D, n2, n3, n4);
            n3 += printItem.getHeight();
        }
    }

    public List<PrintItem> getCommands() {
        return this.m_aCommands;
    }

    public void printImage(BufferedImage object) {
        object = new PrintItemImage((BufferedImage)object, IMAGE_SCALE);
        this.m_aCommands.add((PrintItem)object);
        this.m_iBodyHeight += object.getHeight();
    }

    public void printBarCode(String object, String string, String string2, String string3) {
        object = new PrintItemBarcode((String)object, string, string3, string2, IMAGE_SCALE);
        this.m_aCommands.add((PrintItem)object);
        this.m_iBodyHeight += object.getHeight();
    }

    public void beginLine(int n2) {
        this.pil = new PrintItemLine(n2, BASEFONT, FONTHEIGHT);
    }

    public void setTextFont(String string, int n2) {
        BASEFONT = new Font(string, 0, n2).deriveFont(AffineTransform.getScaleInstance(1.0, 1.0));
    }

    public void printText(int n2, String string) {
        if (this.pil != null) {
            this.pil.addText(n2, string);
        }
    }

    public void endLine() {
        if (this.pil != null) {
            this.m_aCommands.add(this.pil);
            this.m_iBodyHeight += this.pil.getHeight();
            this.pil = null;
        }
    }
}

