/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.ticket;

import com.posics.pos.printer.ticket.PrintItem;
import com.posics.pos.util.StringUtils;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.impl.qr.QRCodeBean;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import org.krysalis.barcode4j.impl.upcean.EAN8Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.java2d.Java2DCanvasProvider;
import org.krysalis.barcode4j.tools.Length;

public class PrintItemBarcode
implements PrintItem,
Serializable {
    private static final long serialVersionUID = 9110127845929L;
    protected transient AbstractBarcodeBean m_barcode;
    protected String m_sCode;
    protected int m_iWidth;
    protected int m_iHeight;
    protected double scale;

    public PrintItemBarcode(String string, String string2, String string3, String string4, double d2) {
        this.m_sCode = string3;
        this.scale = d2;
        if ("CODE128".equals(string)) {
            this.m_barcode = new Code128Bean();
        } else if ("EAN8".equals(string)) {
            this.m_barcode = new EAN8Bean();
        } else if ("EAN13".equals(string)) {
            this.m_barcode = new EAN13Bean();
        } else if ("QR".equals(string)) {
            this.m_barcode = new QRCodeBean();
        } else if ("QR-ZATCA".equals(string)) {
            this.m_sCode = StringUtils.getZatcaQR(string3);
            this.m_barcode = new QRCodeBean();
        } else if ("QR-ZATCA-PHASE2".equals(string)) {
            System.out.println(string3);
            this.m_sCode = StringUtils.getZatcaQRPhase2(string3);
            System.out.println(this.m_sCode);
            this.m_barcode = new QRCodeBean();
        } else {
            this.m_barcode = new Code39Bean();
        }
        if (this.m_barcode != null) {
            if (("QR".equals(string) || "QR-ZATCA".equals(string) || "QR-ZATCA-PHASE2".equals(string)) && string4 != null) {
                string = new Length(string4, "mm");
                this.m_barcode.setModuleWidth(string.getValueAsMillimeter());
            } else {
                this.m_barcode.setModuleWidth(1.0);
            }
            this.m_barcode.setBarHeight(40.0);
            this.m_barcode.setFontSize(10.0);
            this.m_barcode.setQuietZone(10.0);
            this.m_barcode.doQuietZone(true);
            if ("none".equals(string2)) {
                this.m_barcode.setMsgPosition(HumanReadablePlacement.HRP_NONE);
            } else {
                this.m_barcode.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
            }
            string = this.m_barcode.calcDimensions(this.m_sCode);
            this.m_iWidth = (int)string.getWidth(0);
            this.m_iHeight = (int)string.getHeight(0);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D, int n2, int n3, int n4) {
        if (this.m_barcode != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(n2 - 10 + (n4 - (int)((double)this.m_iWidth * this.scale)) / 2, n3 + 10);
            graphics2D.scale(this.scale, this.scale);
            try {
                this.m_barcode.generateBarcode((CanvasProvider)new Java2DCanvasProvider(graphics2D, 0), this.m_sCode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                graphics2D.drawRect(0, 0, this.m_iWidth, this.m_iHeight);
                graphics2D.drawLine(0, 0, this.m_iWidth, this.m_iHeight);
                graphics2D.drawLine(this.m_iWidth, 0, 0, this.m_iHeight);
            }
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public int getHeight() {
        return (int)((double)this.m_iHeight * this.scale) + 20;
    }
}

