/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.reports;

import com.posics.basic.BasicException;
import com.posics.beans.JCalendarDialog;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.SerializableRead;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadClass;
import com.posics.data.loader.SerializerWriteString;
import com.posics.data.loader.StaticSentence;
import com.posics.format.Formats;
import com.posics.pos.config.LAFColors;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.BeanFactoryApp;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.JPanelView;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.reports.JPanelPOSReportButtons;
import com.posics.pos.reports.POSReportsModel;
import com.posics.pos.reports.b;
import com.posics.pos.reports.c;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.util.MessageEmail;
import com.posics.pos.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JPanelPOSReports
extends JPanel
implements BeanFactoryApp,
JPanelView {
    private AppView m_App;
    private DataLogicSystem m_dlSystem;
    private POSReportsModel m_PosReportsModel = null;
    private TicketParser m_TTP;
    private TicketParser m_TTPEmail;
    protected JPanelPOSReportButtons m_jbtnconfig;
    private static DateFormat a;
    private static DateFormat b;
    private MessageEmail m_online;
    private JButton btnDateEnd;
    private JButton btnDateStart;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelButtons;
    private JPanel jPanelDates;
    private JRadioButton jRadioMail;
    private JRadioButton jRadioPrint;
    private JRadioButton jRadioSave;
    private JTextField jTxtEndDate;
    private JTextField jTxtStartDate;

    public JPanelPOSReports() {
        JPanelPOSReports jPanelPOSReports = this;
        this.buttonGroup1 = new ButtonGroup();
        jPanelPOSReports.jPanel1 = new JPanel();
        jPanelPOSReports.jPanel2 = new JPanel();
        jPanelPOSReports.jPanelDates = new JPanel();
        jPanelPOSReports.jLabel1 = new JLabel();
        jPanelPOSReports.jTxtStartDate = new JTextField();
        jPanelPOSReports.jLabel2 = new JLabel();
        jPanelPOSReports.jTxtEndDate = new JTextField();
        jPanelPOSReports.btnDateStart = new JButton();
        jPanelPOSReports.btnDateEnd = new JButton();
        jPanelPOSReports.jRadioSave = new JRadioButton();
        jPanelPOSReports.jRadioPrint = new JRadioButton();
        jPanelPOSReports.jRadioMail = new JRadioButton();
        jPanelPOSReports.jPanelButtons = new JPanel();
        jPanelPOSReports.setBackground(LAFColors.COLOR_PANEL);
        jPanelPOSReports.setLayout(new BoxLayout(jPanelPOSReports, 2));
        jPanelPOSReports.jPanel1.setLayout(new BorderLayout());
        jPanelPOSReports.jPanel2.setBackground(LAFColors.COLOR_PANEL);
        jPanelPOSReports.jPanelDates.setBackground(LAFColors.COLOR_PANEL);
        jPanelPOSReports.jPanelDates.setBorder(BorderFactory.createTitledBorder(null, AppLocal.getIntString("label.bydates"), 0, 0, new Font("Tahoma", 0, 11), LAFColors.COLOR_LABEL));
        jPanelPOSReports.jPanelDates.setMaximumSize(new Dimension(Short.MAX_VALUE, 150));
        jPanelPOSReports.jPanelDates.setMinimumSize(new Dimension(450, 150));
        jPanelPOSReports.jPanelDates.setPreferredSize(new Dimension(450, 150));
        jPanelPOSReports.jPanelDates.setLayout((LayoutManager)new AbsoluteLayout());
        jPanelPOSReports.jLabel1.setForeground(LAFColors.COLOR_LABEL);
        jPanelPOSReports.jLabel1.setText(AppLocal.getIntString("Label.StartDate"));
        jPanelPOSReports.jPanelDates.add((Component)jPanelPOSReports.jLabel1, new AbsoluteConstraints(30, 30, 120, -1));
        jPanelPOSReports.jPanelDates.add((Component)jPanelPOSReports.jTxtStartDate, new AbsoluteConstraints(150, 30, 200, 25));
        jPanelPOSReports.jLabel2.setForeground(LAFColors.COLOR_LABEL);
        jPanelPOSReports.jLabel2.setText(AppLocal.getIntString("Label.EndDate"));
        jPanelPOSReports.jPanelDates.add((Component)jPanelPOSReports.jLabel2, new AbsoluteConstraints(30, 70, 120, -1));
        jPanelPOSReports.jPanelDates.add((Component)jPanelPOSReports.jTxtEndDate, new AbsoluteConstraints(150, 70, 200, 25));
        jPanelPOSReports.btnDateStart.setBackground(LAFColors.COLOR_BUTTON);
        jPanelPOSReports.btnDateStart.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        jPanelPOSReports.btnDateStart.setIcon(new ImageIcon(jPanelPOSReports.getClass().getResource("/com/posics/images/date.png")));
        jPanelPOSReports.btnDateStart.setMaximumSize(new Dimension(49, 30));
        jPanelPOSReports.btnDateStart.setMinimumSize(new Dimension(49, 30));
        jPanelPOSReports.btnDateStart.setPreferredSize(new Dimension(49, 30));
        jPanelPOSReports.btnDateStart.addActionListener(new b(jPanelPOSReports));
        jPanelPOSReports.jPanelDates.add((Component)jPanelPOSReports.btnDateStart, new AbsoluteConstraints(360, 30, -1, -1));
        jPanelPOSReports.btnDateEnd.setBackground(LAFColors.COLOR_BUTTON);
        jPanelPOSReports.btnDateEnd.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        jPanelPOSReports.btnDateEnd.setIcon(new ImageIcon(jPanelPOSReports.getClass().getResource("/com/posics/images/date.png")));
        jPanelPOSReports.btnDateEnd.setMaximumSize(new Dimension(49, 30));
        jPanelPOSReports.btnDateEnd.setMinimumSize(new Dimension(49, 30));
        jPanelPOSReports.btnDateEnd.setPreferredSize(new Dimension(49, 30));
        jPanelPOSReports.btnDateEnd.addActionListener(new c(jPanelPOSReports));
        jPanelPOSReports.jPanelDates.add((Component)jPanelPOSReports.btnDateEnd, new AbsoluteConstraints(360, 70, -1, -1));
        jPanelPOSReports.buttonGroup1.add(jPanelPOSReports.jRadioSave);
        jPanelPOSReports.jRadioSave.setForeground(LAFColors.COLOR_LABEL);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("pos_messages");
        jPanelPOSReports.jRadioSave.setText(resourceBundle.getString("posreport.save"));
        jPanelPOSReports.jRadioSave.setOpaque(false);
        jPanelPOSReports.jPanelDates.add((Component)jPanelPOSReports.jRadioSave, new AbsoluteConstraints(300, 110, -1, -1));
        jPanelPOSReports.buttonGroup1.add(jPanelPOSReports.jRadioPrint);
        jPanelPOSReports.jRadioPrint.setForeground(LAFColors.COLOR_LABEL);
        jPanelPOSReports.jRadioPrint.setSelected(true);
        jPanelPOSReports.jRadioPrint.setText(resourceBundle.getString("posreport.print"));
        jPanelPOSReports.jRadioPrint.setOpaque(false);
        jPanelPOSReports.jPanelDates.add((Component)jPanelPOSReports.jRadioPrint, new AbsoluteConstraints(150, 110, -1, -1));
        jPanelPOSReports.buttonGroup1.add(jPanelPOSReports.jRadioMail);
        jPanelPOSReports.jRadioMail.setForeground(LAFColors.COLOR_LABEL);
        jPanelPOSReports.jRadioMail.setText(resourceBundle.getString("posreport.mail"));
        jPanelPOSReports.jRadioMail.setOpaque(false);
        jPanelPOSReports.jPanelDates.add((Component)jPanelPOSReports.jRadioMail, new AbsoluteConstraints(220, 110, -1, -1));
        jPanelPOSReports.jPanel2.add(jPanelPOSReports.jPanelDates);
        jPanelPOSReports.jPanelButtons.setBackground(LAFColors.COLOR_PANEL);
        jPanelPOSReports.jPanelButtons.setMinimumSize(new Dimension(495, 200));
        jPanelPOSReports.jPanelButtons.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanelPOSReports.jPanel2.add(jPanelPOSReports.jPanelButtons);
        jPanelPOSReports.jPanel1.add((Component)jPanelPOSReports.jPanel2, "Center");
        JPanelPOSReports jPanelPOSReports2 = jPanelPOSReports;
        jPanelPOSReports2.add(jPanelPOSReports2.jPanel1);
    }

    @Override
    public void init(AppView appView) {
        this.m_App = appView;
        this.m_dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
        this.m_TTP = new TicketParser(this.m_App.getDeviceTicket(), this.m_dlSystem, Boolean.FALSE);
        this.m_TTPEmail = new TicketParser(this.m_App.getDeviceTicket(), this.m_dlSystem, Boolean.TRUE);
        this.m_jbtnconfig = new JPanelPOSReportButtons("POS.Reports", this.m_App, this.m_dlSystem, this);
        a = new SimpleDateFormat(this.m_App.getProperties().getProperty("format.datetime"));
        b = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.jPanelButtons.add(this.m_jbtnconfig);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() {
        this.m_jbtnconfig.setPermissions(this.m_App.getAppUserView().getUser());
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    @Override
    public String getTitle() {
        return "POS Reports";
    }

    @Override
    public Object getBean() {
        return this;
    }

    public boolean isValidDate(String string) {
        try {
            a.parse(string.trim());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void printPOSReport(String object) {
        block22: {
            String string = this.m_dlSystem.getResourceAsXML((String)object);
            if (string == null) {
                MessageInf messageInf = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"));
                messageInf.show(this);
                return;
            }
            try {
                block21: {
                    Object object2 = org.apache.commons.lang3.StringUtils.substringBetween((String)string, (String)"<sql><![CDATA[", (String)"]]></sql>");
                    if (object2 != null && !"".equals(object2)) {
                        Object object3;
                        if (((String)object2).contains("$startDate")) {
                            JPanelPOSReports jPanelPOSReports = this;
                            if (jPanelPOSReports.isValidDate(jPanelPOSReports.jTxtStartDate.getText())) {
                                object3 = a.parse(this.jTxtStartDate.getText());
                                object2 = ((String)object2).replace("$startDate", "{ts '" + b.format((Date)object3) + "'}");
                            } else {
                                MessageInf messageInf = new MessageInf(-33554432, "Please enter a valid start date.", null);
                                messageInf.show(this);
                                return;
                            }
                        }
                        if (((String)object2).contains("$endDate")) {
                            JPanelPOSReports jPanelPOSReports = this;
                            if (jPanelPOSReports.isValidDate(jPanelPOSReports.jTxtEndDate.getText())) {
                                object3 = a.parse(this.jTxtEndDate.getText());
                                object2 = ((String)object2).replace("$endDate", "{ts '" + b.format((Date)object3) + "'}");
                            } else {
                                object3 = new MessageInf(-33554432, "Please enter a valid end date.", null);
                                ((MessageInf)object3).show(this);
                                return;
                            }
                        }
                        object3 = new POSReport();
                        ((POSReport)object3).a = new ArrayList();
                        object2 = new StaticSentence(this.m_App.getSession(), (String)object2, SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(DynSql.class)).list();
                        if (object2 == null) {
                            ((POSReport)object3).a = null;
                        } else {
                            ((POSReport)object3).a = (List)object2;
                        }
                        object2 = ScriptFactory.getScriptEngine("velocity");
                        object2.put("posreport", object3);
                        object2.put("startDate", this.jTxtStartDate.getText());
                        object2.put("endDate", this.jTxtEndDate.getText());
                        if (this.jRadioMail.isSelected()) {
                            this.m_online = new MessageEmail();
                            if (this.m_App.isOnline() && this.m_online.isEnabled()) {
                                this.m_TTPEmail.printTicket(object2.eval(string).toString());
                                string = (String)object + "_" + this.m_App.getProperties().getHost() + "_" + new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss").format(new Date()) + ".txt";
                                string = string.replace(" ", "_");
                                object = (String)object + " from " + this.m_App.getProperties().getHost();
                                try {
                                    object2 = "Dear Customer,\r\n\r\nWe are happy to offer you the facility of receiving reports on email. Now, you can access your reports from anywhere in the world. This is something you cannot do with your printed reports.\r\n\r\nYou can view the attached file in the browser itself or download the file to open it using any text editor.\r\n\r\nThank you,\r\nSaleculator Online Services\r\nwww.saleculator.com";
                                    this.m_online.SendMailwithAttachment(this.m_online.getEmailTo(), (String)object, (String)object2, this.m_TTPEmail.getFormattedFile(), string);
                                    break block21;
                                }
                                catch (Exception exception) {
                                    object = new MessageInf(-33554432, AppLocal.getIntString("message.cannotsendmail"), exception);
                                    ((MessageInf)object).show(this);
                                    break block22;
                                }
                            }
                            JOptionPane.showMessageDialog(this, "Please make sure internet is connected and email is configured.", "POS Report Email", 1);
                            break block22;
                        }
                        if (this.jRadioSave.isSelected()) {
                            this.m_TTPEmail.printTicket(object2.eval(string).toString());
                            string = this.m_TTPEmail.getFormattedTicket();
                            object = (String)object + ".txt";
                            object = ((String)object).replace(" ", "_");
                            object2 = new File((String)object);
                            object = new JFileChooser();
                            ((JFileChooser)object).setSelectedFile((File)object2);
                            int n2 = ((JFileChooser)object).showSaveDialog(this);
                            if (n2 != 0) break block22;
                            File file = ((JFileChooser)object).getSelectedFile();
                            try {
                                object = new BufferedWriter(new FileWriter(file));
                                ((Writer)object).write(string);
                                ((BufferedWriter)object).close();
                                JOptionPane.showMessageDialog(this, "File Saved.", "POS Report Save", 1);
                                break block21;
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(this, iOException.getMessage(), "POS Report Save", 64);
                                break block22;
                            }
                        }
                        this.m_TTP.printTicket(object2.eval(string).toString());
                    }
                }
                return;
            }
            catch (ScriptException scriptException) {
                MessageInf messageInf = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), scriptException);
                messageInf.show(this);
                return;
            }
            catch (TicketPrinterException ticketPrinterException) {
                MessageInf messageInf = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), ticketPrinterException);
                messageInf.show(this);
                return;
            }
            catch (Exception exception) {
                MessageInf messageInf = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), exception);
                messageInf.show(this);
            }
        }
    }

    static /* synthetic */ void access$000(JPanelPOSReports jPanelPOSReports, ActionEvent serializable) {
        try {
            serializable = (Date)Formats.TIMESTAMP.parseValue(jPanelPOSReports.jTxtStartDate.getText());
        }
        catch (BasicException basicException) {
            serializable = null;
        }
        serializable = JCalendarDialog.showCalendarTimeHours(jPanelPOSReports, (Date)serializable);
        if (serializable != null) {
            jPanelPOSReports.jTxtStartDate.setText(Formats.TIMESTAMP.formatValue(serializable));
        }
    }

    static /* synthetic */ void access$100(JPanelPOSReports jPanelPOSReports, ActionEvent serializable) {
        try {
            serializable = (Date)Formats.TIMESTAMP.parseValue(jPanelPOSReports.jTxtEndDate.getText());
        }
        catch (BasicException basicException) {
            serializable = null;
        }
        serializable = JCalendarDialog.showCalendarTimeHours(jPanelPOSReports, (Date)serializable);
        if (serializable != null) {
            jPanelPOSReports.jTxtEndDate.setText(Formats.TIMESTAMP.formatValue(serializable));
        }
    }

    public static class DynSql
    implements SerializableRead {
        private ArrayList<Object> a = new ArrayList();

        @Override
        public void readValues(DataRead dataRead) {
            for (int i2 = 1; i2 <= dataRead.getDataField().length; ++i2) {
                this.a.add(dataRead.getObject(i2));
            }
        }

        public String printValue(int n2) {
            if (n2 < this.a.size() && this.a.get(n2) != null) {
                return StringUtils.encodeXML(this.a.get(n2).toString());
            }
            return "";
        }

        public String printCurrency(int n2) {
            if (n2 < this.a.size()) {
                return Formats.CURRENCY.formatValue(this.getDouble(n2));
            }
            return "";
        }

        public double getDouble(int n2) {
            if (n2 < this.a.size() && this.a.get(n2) != null) {
                return (Double)this.a.get(n2);
            }
            return 0.0;
        }

        public int getInteger(int n2) {
            if (n2 < this.a.size() && this.a.get(n2) != null) {
                return (Integer)this.a.get(n2);
            }
            return 0;
        }

        public String printDate(int n2) {
            if (n2 < this.a.size() && this.a.get(n2) != null) {
                try {
                    Date date = (Date)this.a.get(n2);
                    return a.format(date);
                }
                catch (Exception exception) {
                    return "";
                }
            }
            return "";
        }
    }

    public static class POSReport {
        private List<DynSql> a;

        public List<DynSql> getResult() {
            return this.a;
        }

        public double roundDouble(double d2, int n2) {
            if (n2 > 0) {
                return (double)Math.round(d2 * Math.pow(10.0, n2)) / Math.pow(10.0, n2);
            }
            return Math.round(d2);
        }

        public String formatCurrency(Double d2) {
            return Formats.CURRENCY.formatValue(d2);
        }

        public double getTotal(int n2) {
            double d2 = 0.0;
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                d2 += this.a.get(i2).getDouble(n2);
            }
            return d2;
        }

        public String printTotal(int n2) {
            return Formats.CURRENCY.formatValue(this.getTotal(n2));
        }

        public int printCount() {
            return this.a.size();
        }

        public String printDate() {
            return a.format(new Date());
        }

        public String printDateFormatted(String object) {
            try {
                object = new SimpleDateFormat((String)object);
                return ((DateFormat)object).format(new Date());
            }
            catch (Exception exception) {
                object = exception;
                return exception.getMessage();
            }
        }
    }
}

