/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.reports;

import com.posics.data.loader.DataRead;
import com.posics.data.loader.SerializableRead;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadClass;
import com.posics.data.loader.SerializerWriteString;
import com.posics.data.loader.StaticSentence;
import com.posics.format.Formats;
import com.posics.pos.forms.AppView;
import com.posics.pos.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class POSReportsModel {
    private String a;
    private String b;
    private String c;
    private String d;
    private List<ProductSales> e;
    private List<SalesTickets> f;

    private POSReportsModel() {
    }

    public static POSReportsModel loadProductSales(AppView object, String string, String string2) {
        POSReportsModel pOSReportsModel = new POSReportsModel();
        new POSReportsModel().a = object.getProperties().getHost();
        pOSReportsModel.b = object.getAppUserView().getUser().getName();
        pOSReportsModel.c = string;
        pOSReportsModel.d = string2;
        pOSReportsModel.e = (object = new StaticSentence(object.getSession(), "SELECT CATEGORIES.NAME, PRODUCTS.REFERENCE, PRODUCTS.NAME,PRODUCTS.CODE, SUM(TICKETLINES.UNITS) AS UNITS, SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS TOTAL FROM RECEIPTS, TICKETS, TICKETLINES LEFT JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID LEFT JOIN CATEGORIES ON CATEGORIES.ID=PRODUCTS.CATEGORY WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.ID = TICKETLINES.TICKET AND (RECEIPTS.DATENEW >= {ts '" + string + "'} AND RECEIPTS.DATENEW < {ts '" + string2 + "'}) GROUP BY PRODUCTS.ID ORDER BY CATEGORIES.NAME", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(ProductSales.class)).list()) == null ? new ArrayList<ProductSales>() : object;
        return pOSReportsModel;
    }

    public static POSReportsModel loadReceipts(AppView object, String string, String string2) {
        POSReportsModel pOSReportsModel = new POSReportsModel();
        new POSReportsModel().a = object.getProperties().getHost();
        pOSReportsModel.b = object.getAppUserView().getUser().getName();
        pOSReportsModel.c = string;
        pOSReportsModel.d = string2;
        pOSReportsModel.f = (object = new StaticSentence(object.getSession(), "SELECT TICKETS.TICKETID AS TICKET_NO, RECEIPTS.DATENEW AS TICKET_DATE, SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS MONEY, SUM(TICKETLINES.UNITS) AS QTY, CUSTOMERS.NAME AS CUSTOMER FROM RECEIPTS LEFT JOIN TICKETS ON RECEIPTS.ID = TICKETS.ID LEFT JOIN TICKETLINES ON TICKETLINES.TICKET = TICKETS.ID LEFT JOIN CUSTOMERS ON TICKETS.CUSTOMER = CUSTOMERS.ID WHERE (RECEIPTS.DATENEW >= {ts '" + string + "'} AND RECEIPTS.DATENEW < {ts '" + string2 + "'}) GROUP BY TICKETLINES.TICKET ORDER BY RECEIPTS.DATENEW, TICKETS.TICKETID", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(SalesTickets.class)).list()) == null ? new ArrayList<SalesTickets>() : object;
        return pOSReportsModel;
    }

    public String printHost() {
        return StringUtils.encodeXML(this.a);
    }

    public String printUserName() {
        return StringUtils.encodeXML(this.b);
    }

    public String printStartDate() {
        return this.c;
    }

    public String printEndDate() {
        return this.d;
    }

    public List<ProductSales> getProductSales() {
        return this.e;
    }

    public List<SalesTickets> getSalesTickets() {
        return this.f;
    }

    public String formatCurrency(Double d2) {
        return Formats.CURRENCY.formatValue(d2);
    }

    public static class SalesTickets
    implements SerializableRead {
        private String a;
        private Date b;
        private Double c;
        private Double d;
        private String e;

        @Override
        public void readValues(DataRead dataRead) {
            this.a = dataRead.getString(1);
            this.b = dataRead.getTimestamp(2);
            this.c = dataRead.getDouble(3);
            this.d = dataRead.getDouble(4);
            this.e = dataRead.getString(5);
        }

        public String printTicketId() {
            if (this.a != null) {
                return this.a;
            }
            return "";
        }

        public String printDate() {
            return Formats.TIMESTAMP.formatValue(this.b);
        }

        public String printAmount() {
            return Formats.CURRENCY.formatValue(this.c);
        }

        public Double getAmount() {
            return this.c;
        }

        public String printUnits() {
            return Formats.DOUBLE.formatValue(this.d);
        }

        public Double getUnits() {
            return this.d;
        }

        public String printCustomerName() {
            return StringUtils.encodeXML(this.e);
        }
    }

    public static class ProductSales
    implements SerializableRead {
        private String a;
        private String b;
        private String c;
        private String d;
        private Double e;
        private Double f;

        @Override
        public void readValues(DataRead dataRead) {
            this.a = dataRead.getString(1);
            this.b = dataRead.getString(2);
            this.c = dataRead.getString(3);
            this.d = dataRead.getString(4);
            this.e = dataRead.getDouble(5);
            this.f = dataRead.getDouble(6);
        }

        public String printCategory() {
            if (this.a == null) {
                return "*";
            }
            return StringUtils.encodeXML(this.a);
        }

        public String printProductRef() {
            if (this.b == null) {
                return "*";
            }
            return StringUtils.encodeXML(this.b);
        }

        public String printProductName() {
            if (this.c == null) {
                return "*";
            }
            return StringUtils.encodeXML(this.c);
        }

        public String printProductCode() {
            if (this.d == null) {
                return "*";
            }
            return StringUtils.encodeXML(this.d);
        }

        public String printAmount() {
            return Formats.CURRENCY.formatValue(this.f);
        }

        public Double getAmount() {
            return this.f;
        }

        public String printUnits() {
            return Formats.DOUBLE.formatValue(this.e);
        }

        public Double getUnits() {
            return this.e;
        }
    }
}

