/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales;

import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataWrite;
import com.posics.data.loader.SerializableRead;
import com.posics.data.loader.SerializableWrite;
import com.posics.format.Formats;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class UnPaidTicketInfo
implements SerializableRead,
SerializableWrite {
    private String a;
    private int b;
    private String c;
    private String d;
    private String e;
    private double f;
    private String g;

    @Override
    public void readValues(DataRead dataRead) {
        this.a = dataRead.getString(1);
        this.b = dataRead.getInt(2);
        this.c = dataRead.getString(3).replace(".0", "");
        this.d = dataRead.getString(4) != null ? dataRead.getString(4) : "";
        this.f = dataRead.getDouble(5);
        this.e = dataRead.getString(6) != null ? dataRead.getString(6) : "";
        this.g = dataRead.getString(7) != null ? dataRead.getString(7) : "";
    }

    @Override
    public void writeValues(DataWrite dataWrite) {
        dataWrite.setString(1, this.a);
        dataWrite.setInt(2, this.b);
        dataWrite.setString(3, this.c);
        dataWrite.setString(4, this.d);
        dataWrite.setDouble(5, this.f);
        dataWrite.setString(6, this.e);
        dataWrite.setString(7, this.g);
    }

    public String getId() {
        return this.a;
    }

    public int getTicketId() {
        return this.b;
    }

    public String getDate() {
        return this.c;
    }

    public Double getAmount() {
        return this.f;
    }

    public String getPayment() {
        return this.g;
    }

    public String printPayment() {
        if (this.g != null && !"".equals(this.g)) {
            try {
                JSONObject jSONObject = new JSONObject(this.g);
                jSONObject = jSONObject.getJSONArray("payments");
                String string = "";
                for (int i2 = 0; i2 < jSONObject.length(); ++i2) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject(i2);
                    string = string + jSONObject2.getString("type") + " " + Formats.CURRENCY.formatValue(jSONObject2.getDouble("amount")) + " ";
                }
                return string;
            }
            catch (JSONException jSONException) {
                Logger.getLogger(UnPaidTicketInfo.class.getName()).log(Level.SEVERE, null, jSONException);
                return "";
            }
        }
        return "";
    }

    public String printAmount() {
        return Formats.CURRENCY.formatValue(this.f);
    }

    public String getCustomer() {
        return this.e;
    }

    public String getName() {
        if (this.d.trim().length() > 0 && this.e.trim().length() > 0) {
            return "<html><center>" + this.b + "<br>" + this.c + "<br>" + this.d + "-" + this.e + "<br>" + Formats.CURRENCY.formatValue(this.f);
        }
        if (this.d.trim().length() > 0) {
            return "<html><center>" + this.b + "<br>" + this.c + "<br>" + this.d + "<br>" + Formats.CURRENCY.formatValue(this.f);
        }
        if (this.e.trim().length() > 0) {
            return "<html><center>" + this.b + "<br>" + this.c + "<br>" + this.e + "<br>" + Formats.CURRENCY.formatValue(this.f);
        }
        return "<html><center>" + this.b + "<br>" + this.c + "<br>" + Formats.CURRENCY.formatValue(this.f);
    }
}

