/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.online;

import com.posics.pos.customers.CustomerAddress;
import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.sales.TaxesLogic;
import com.posics.pos.sales.online.OnlineOrder;
import com.posics.pos.sales.online.OrderParser;
import com.posics.pos.ticket.ProductInfoExt;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.ticket.TicketLineInfo;
import com.posics.pos.util.StringUtils;
import java.text.SimpleDateFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OrderParserQayimat
extends OrderParser {
    private final SimpleDateFormat a = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String b;

    public OrderParserQayimat(String string) {
        this.b = string;
    }

    @Override
    public OnlineOrder getOrder(JSONObject jSONObject) {
        OnlineOrder onlineOrder = new OnlineOrder();
        try {
            onlineOrder = new OnlineOrder(this.b, jSONObject.getInt("order_id"), jSONObject, 1, this.a.parse(jSONObject.getString("created_at")));
        }
        catch (JSONException jSONException) {
            System.err.println(jSONException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return onlineOrder;
    }

    public boolean connectStore() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TicketInfo getTicket(DataLogicSales dataLogicSales, OnlineOrder object, TaxesLogic object2) {
        TicketInfo ticketInfo = new TicketInfo();
        try {
            CustomerAddress customerAddress;
            Object object3 = String.valueOf(((OnlineOrder)object).getOrderJSON().getInt("order_id"));
            Object object4 = String.valueOf(((OnlineOrder)object).getOrderJSON().getInt("client_id"));
            int n2 = ((OnlineOrder)object).getOrderJSON().getInt("delivery_method");
            ticketInfo.setDate(this.a.parse(((OnlineOrder)object).getOrderJSON().getString("created_at")));
            ticketInfo.setProperty("OrderId", (String)object3);
            ticketInfo.setProperty("comments", ((OnlineOrder)object).getOrderJSON().getString("client_comment"));
            ticketInfo.setProperty("pickup_at", ((OnlineOrder)object).getOrderJSON().getString("delivery_pickup_interval"));
            object3 = new CustomerInfoExt((String)object4);
            ((CustomerInfo)object3).setName(((OnlineOrder)object).getOrderJSON().getString("client_name"));
            ((CustomerInfoExt)object3).setPhone(((OnlineOrder)object).getOrderJSON().getString("client_phone"));
            ((CustomerInfo)object3).setSearchkey(((OnlineOrder)object).getOrderJSON().getString("client_phone"));
            if (n2 == 1 && !((OnlineOrder)object).getOrderJSON().isNull("client_address_id")) {
                String string = String.valueOf(((OnlineOrder)object).getOrderJSON().getInt("client_address_id"));
                customerAddress = new CustomerAddress();
                customerAddress.setId(string);
                customerAddress.setName(((OnlineOrder)object).getOrderJSON().getString("client_name"));
                customerAddress.setCustomerId((String)object4);
                customerAddress.setAddress(((OnlineOrder)object).getOrderJSON().getString("client_address"));
                customerAddress.setPhone(((OnlineOrder)object).getOrderJSON().getString("client_phone"));
                customerAddress.setLatitude(((OnlineOrder)object).getOrderJSON().getString("client_location_lat"));
                customerAddress.setLongitude(((OnlineOrder)object).getOrderJSON().getString("client_location_lng"));
                ((CustomerInfoExt)object3).setAddress(((OnlineOrder)object).getOrderJSON().getString("client_address"));
                ((CustomerInfoExt)object3).addAddress(customerAddress);
            }
            ticketInfo.setCustomer((CustomerInfoExt)object3);
            JSONArray jSONArray = ((OnlineOrder)object).getOrderJSON().getJSONArray("oderitems");
            object = StringUtils.props.getProperty("taxcategoryid");
            object2 = ((TaxesLogic)object2).getTaxInfo((String)object, null);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                void i3;
                String string;
                customerAddress = jSONArray.getJSONObject(i2);
                object = customerAddress.getDouble("variant_price") / (1.0 + ((TaxInfo)object2).getRate());
                object4 = dataLogicSales.getProductInfoByName(customerAddress.getString("itemname"));
                if (object4 != null) {
                    object = new TicketLineInfo(((ProductInfoExt)object4).getID(), customerAddress.getString("itemname") + " " + customerAddress.getString("variant_name"), "", customerAddress.getDouble("qty"), (Double)object, (TaxInfo)object2);
                    for (String string2 : ((ProductInfoExt)object4).getProperties().keySet()) {
                        string = ((ProductInfoExt)object4).getProperties().getProperty(string2);
                        ((TicketLineInfo)object).getProperties().setProperty(string2, string);
                    }
                } else {
                    object = new TicketLineInfo(customerAddress.getString("itemname") + " " + customerAddress.getString("variant_name"), "", customerAddress.getDouble("qty"), (Double)object, (TaxInfo)object2);
                }
                ((TicketLineInfo)object).setProperty("json", customerAddress.toString());
                ticketInfo.addLine((TicketLineInfo)object);
                JSONArray jSONArray2 = customerAddress.getJSONArray("extras");
                boolean bl2 = false;
                while (i3 < jSONArray2.length()) {
                    string = jSONArray2.getJSONObject((int)i3);
                    object = string.getDouble("amount") / (1.0 + ((TaxInfo)object2).getRate());
                    object4 = dataLogicSales.getProductInfoByName(string.getString("item"));
                    if (object4 != null) {
                        object = new TicketLineInfo(((ProductInfoExt)object4).getID(), string.getString("item"), "", customerAddress.getDouble("qty"), (Double)object, (TaxInfo)object2);
                        for (String string2 : ((ProductInfoExt)object4).getProperties().keySet()) {
                            String string3 = ((ProductInfoExt)object4).getProperties().getProperty(string2);
                            ((TicketLineInfo)object).getProperties().setProperty(string2, string3);
                        }
                    } else {
                        object = new TicketLineInfo(string.getString("item"), ((TaxInfo)object2).getTaxCategoryID(), customerAddress.getDouble("qty"), (Double)object, (TaxInfo)object2);
                    }
                    ((TicketLineInfo)object).getProperties().setProperty("product.com", "true");
                    ((TicketLineInfo)object).setProperty("json", string.toString());
                    ticketInfo.addLine((TicketLineInfo)object);
                    ++i3;
                }
            }
        }
        catch (JSONException jSONException) {
            System.err.println(jSONException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return ticketInfo;
    }
}

