/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.online;

import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.sales.TaxesLogic;
import com.posics.pos.sales.online.OnlineOrder;
import com.posics.pos.sales.online.OrderParser;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.ticket.TicketLineInfo;
import com.posics.pos.util.StringUtils;
import java.text.SimpleDateFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class OrderParserWC
extends OrderParser {
    private final SimpleDateFormat a = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public OnlineOrder getOrder(JSONObject jSONObject) {
        OnlineOrder onlineOrder = new OnlineOrder();
        try {
            onlineOrder = new OnlineOrder("WooCommerce", jSONObject.getInt("id"), jSONObject, 1, this.a.parse(jSONObject.getString("date_created").replace("T", " ")));
        }
        catch (JSONException jSONException) {
            System.err.println(jSONException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return onlineOrder;
    }

    public boolean connectStore() {
        return true;
    }

    public TicketInfo getTicket(OnlineOrder onlineOrder, TaxesLogic object) {
        TicketInfo ticketInfo = new TicketInfo();
        try {
            Object object2 = String.valueOf(onlineOrder.getOrderJSON().getInt("id"));
            String string = String.valueOf(onlineOrder.getOrderJSON().getInt("customer_id"));
            ticketInfo.setDate(this.a.parse(onlineOrder.getOrderJSON().getString("date_created").replace("T", " ")));
            ticketInfo.setProperty("OrderId", (String)object2);
            ticketInfo.setProperty("comments", onlineOrder.getOrderJSON().getString("customer_note"));
            object2 = new CustomerInfoExt(string);
            string = onlineOrder.getOrderJSON().getJSONObject("billing");
            ((CustomerInfo)object2).setName(string.getString("first_name") + " " + string.getString("last_name"));
            ((CustomerInfoExt)object2).setPhone(string.getString("phone"));
            ((CustomerInfo)object2).setSearchkey(string.getString("phone"));
            ticketInfo.setCustomer((CustomerInfoExt)object2);
            onlineOrder = onlineOrder.getOrderJSON().getJSONArray("line_items");
            object2 = StringUtils.props.getProperty("taxcategoryid");
            object2 = ((TaxesLogic)object).getTaxInfo((String)object2, null);
            for (int i2 = 0; i2 < onlineOrder.length(); ++i2) {
                object = onlineOrder.getJSONObject(i2);
                Double d2 = object.getDouble("price") / (1.0 + ((TaxInfo)object2).getRate());
                object = new TicketLineInfo(object.getString("name"), "", object.getDouble("quantity"), d2, (TaxInfo)object2);
                ticketInfo.addLine((TicketLineInfo)object);
            }
        }
        catch (JSONException jSONException) {
            System.err.println(jSONException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return ticketInfo;
    }
}

