/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.online;

import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.sales.TaxesLogic;
import com.posics.pos.sales.online.OnlineOrder;
import com.posics.pos.sales.online.OrderParser;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.ticket.TicketLineInfo;
import com.posics.pos.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class OrderParserWhatsapp
extends OrderParser {
    public OrderParserWhatsapp() {
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public OnlineOrder getOrder(JSONObject jSONObject) {
        OnlineOrder onlineOrder = new OnlineOrder();
        try {
            long l2 = jSONObject.optLong("timestamp") * 1000L;
            Date date = new Date(l2);
            onlineOrder = new OnlineOrder("WhatsApp", jSONObject.getInt("id"), jSONObject, 1, date);
        }
        catch (JSONException jSONException) {
            System.err.println(jSONException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return onlineOrder;
    }

    public TicketInfo getTicket(OnlineOrder onlineOrder, TaxesLogic object) {
        TicketInfo ticketInfo = new TicketInfo();
        try {
            onlineOrder = onlineOrder.getOrderJSON();
            Object object2 = String.valueOf(onlineOrder.getInt("id"));
            Object object3 = onlineOrder.optString("wa_id", "");
            String string = onlineOrder.optString("profile_name", "WhatsApp User");
            long l2 = onlineOrder.optLong("timestamp") * 1000L;
            ticketInfo.setDate(new Date(l2));
            ticketInfo.setProperty("OrderId", (String)object2);
            ticketInfo.setProperty("comments", onlineOrder.optString("text", ""));
            object2 = new CustomerInfoExt((String)object3);
            ((CustomerInfo)object2).setName(string);
            ((CustomerInfoExt)object2).setPhone((String)object3);
            ((CustomerInfo)object2).setSearchkey((String)object3);
            ticketInfo.setCustomer((CustomerInfoExt)object2);
            onlineOrder = onlineOrder.getJSONArray("items_json");
            object2 = StringUtils.props.getProperty("taxcategoryid");
            object = ((TaxesLogic)object).getTaxInfo((String)object2, null);
            for (int i2 = 0; i2 < onlineOrder.length(); ++i2) {
                object3 = onlineOrder.getJSONObject(i2);
                double d2 = object3.getDouble("item_price") / (1.0 + ((TaxInfo)object).getRate());
                double d3 = object3.getDouble("quantity");
                object3 = new TicketLineInfo(object3.getString("product_name").replace("\n", " "), "", d3, d2, (TaxInfo)object);
                ticketInfo.addLine((TicketLineInfo)object3);
            }
        }
        catch (JSONException jSONException) {
            System.err.println(jSONException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return ticketInfo;
    }

    public String getOrderType() {
        return "whatsapp";
    }
}

