/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.ticket;

import com.posics.data.loader.DataRead;
import com.posics.data.loader.LocalRes;
import com.posics.data.loader.SerializableRead;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoMagcard;
import com.posics.pos.suppliers.SupplierInfoExt;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.ticket.TicketLineInfo;
import com.posics.pos.ticket.TicketTaxInfo;
import com.posics.pos.ticket.UserInfo;
import com.posics.pos.util.MessageSMS;
import com.posics.pos.util.MessageWhatsApp;
import com.posics.pos.util.StringUtils;
import com.posics.pos.util.TransliterateArabic;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketInfo
implements SerializableRead,
Externalizable {
    private static final long serialVersionUID = 2765650092387265178L;
    public static final int RECEIPT_NORMAL = 0;
    public static final int RECEIPT_REFUND = 1;
    public static final int RECEIPT_PAYMENT = 2;
    public static final int SUPPLIER_PAYMENT = 3;
    public static final int PAYMENT_CASHIN = 4;
    public static final int PAYMENT_CASHOUT = 5;
    private static DateFormat a = new SimpleDateFormat("hh:mm");
    private String m_sId = UUID.randomUUID().toString();
    private int tickettype = 0;
    private int m_iTicketId = 0;
    private int m_iOrderNumber = 0;
    private Date m_dDate = new Date();
    private Date m_dTimer = new Date();
    private Properties attributes = new Properties();
    private UserInfo m_User = null;
    private CustomerInfoExt m_Customer = null;
    private SupplierInfoExt m_Supplier = null;
    private String m_sActiveCash = null;
    private List<TicketLineInfo> m_aLines = new ArrayList<TicketLineInfo>();
    private List<PaymentInfo> payments = new ArrayList<PaymentInfo>();
    private List<TicketTaxInfo> taxes = null;
    private boolean isAppOrder = false;
    private String m_sHost = null;

    @Override
    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeObject(this.m_sId);
        objectOutput.writeInt(this.tickettype);
        objectOutput.writeInt(this.m_iTicketId);
        objectOutput.writeObject(this.m_Customer);
        objectOutput.writeObject(this.m_Supplier);
        objectOutput.writeObject(this.m_dDate);
        objectOutput.writeObject(this.m_dTimer);
        objectOutput.writeObject(this.attributes);
        objectOutput.writeObject(this.m_aLines);
    }

    @Override
    public void readExternal(ObjectInput objectInput) {
        this.m_sId = (String)objectInput.readObject();
        this.tickettype = objectInput.readInt();
        this.m_iTicketId = objectInput.readInt();
        this.m_Customer = (CustomerInfoExt)objectInput.readObject();
        this.m_Supplier = (SupplierInfoExt)objectInput.readObject();
        this.m_dDate = (Date)objectInput.readObject();
        this.m_dTimer = (Date)objectInput.readObject();
        this.attributes = (Properties)objectInput.readObject();
        this.m_aLines = (List)objectInput.readObject();
        this.m_User = null;
        this.m_sActiveCash = null;
        this.payments = new ArrayList<PaymentInfo>();
        this.taxes = null;
    }

    @Override
    public void readValues(DataRead dataRead) {
        this.m_sId = dataRead.getString(1);
        this.tickettype = dataRead.getInt(2);
        this.m_iTicketId = dataRead.getInt(3);
        this.m_dDate = dataRead.getTimestamp(4);
        this.m_sActiveCash = dataRead.getString(5);
        try {
            byte[] byArray = dataRead.getBytes(6);
            if (byArray != null) {
                this.attributes.loadFromXML(new ByteArrayInputStream(byArray));
            }
        }
        catch (IOException iOException) {}
        this.m_User = new UserInfo(dataRead.getString(7), dataRead.getString(8), dataRead.getString(11));
        this.m_Customer = new CustomerInfoExt(dataRead.getString(9));
        this.m_Supplier = new SupplierInfoExt(dataRead.getString(10));
        this.m_aLines = new ArrayList<TicketLineInfo>();
        this.payments = new ArrayList<PaymentInfo>();
        this.taxes = null;
    }

    public TicketInfo copyTicket() {
        TicketInfo ticketInfo = new TicketInfo();
        new TicketInfo().tickettype = this.tickettype;
        ticketInfo.m_iTicketId = this.m_iTicketId;
        ticketInfo.m_dDate = this.m_dDate;
        ticketInfo.m_dTimer = this.m_dTimer;
        ticketInfo.m_sActiveCash = this.m_sActiveCash;
        ticketInfo.attributes = (Properties)this.attributes.clone();
        ticketInfo.m_User = this.m_User;
        ticketInfo.m_Customer = this.m_Customer;
        ticketInfo.m_Supplier = this.m_Supplier;
        ticketInfo.m_sHost = this.m_sHost;
        ticketInfo.m_aLines = new ArrayList<TicketLineInfo>();
        for (TicketLineInfo object : this.m_aLines) {
            ticketInfo.m_aLines.add(object.copyTicketLine());
        }
        ticketInfo.a();
        ticketInfo.payments = new LinkedList<PaymentInfo>();
        for (PaymentInfo paymentInfo : this.payments) {
            ticketInfo.payments.add(paymentInfo.copyPayment());
        }
        return ticketInfo;
    }

    public String getId() {
        return this.m_sId;
    }

    public int getTicketType() {
        return this.tickettype;
    }

    public void setTicketType(int n2) {
        this.tickettype = n2;
    }

    public void setIsAppOrder() {
        this.isAppOrder = true;
    }

    public boolean isAppOrder() {
        return this.isAppOrder;
    }

    public int getTicketId() {
        return this.m_iTicketId;
    }

    public void setTicketId(int n2) {
        this.m_iTicketId = n2;
    }

    public void setOrderNumber(int n2) {
        this.m_iOrderNumber = n2;
    }

    public Integer getOrderNumber() {
        return this.m_iOrderNumber;
    }

    public String getName(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getCustomerId() != null) {
            stringBuffer.append(this.m_Customer.toString());
            stringBuffer.append(" - ");
        }
        if (object == null) {
            if (this.m_iTicketId == 0) {
                stringBuffer.append("(" + a.format(this.m_dDate) + " " + Long.toString(this.m_dDate.getTime() % 1000L) + ")");
            } else {
                stringBuffer.append(Integer.toString(this.m_iTicketId));
            }
        } else {
            stringBuffer.append(object.toString());
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.getName(null);
    }

    public String getKOTNumber() {
        return Long.toString(this.m_dDate.getTime() % 1000L);
    }

    public Date getDate() {
        return this.m_dDate;
    }

    public Date getTimer() {
        return this.m_dTimer;
    }

    public String printTimer() {
        return Formats.TIMESTAMP.formatValue(this.m_dTimer);
    }

    public long getElapsedMinutes() {
        long l2 = this.m_dTimer.getTime();
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l2;
        long l5 = TimeUnit.MILLISECONDS.toMinutes(l4);
        return l5;
    }

    public void setDate(Date date) {
        this.m_dDate = date;
    }

    public UserInfo getUser() {
        return this.m_User;
    }

    public void setUser(UserInfo userInfo) {
        this.m_User = userInfo;
    }

    public CustomerInfoExt getCustomer() {
        return this.m_Customer;
    }

    public void setCustomer(CustomerInfoExt customerInfoExt) {
        this.m_Customer = customerInfoExt;
    }

    public void setSupplier(SupplierInfoExt supplierInfoExt) {
        this.m_Supplier = supplierInfoExt;
    }

    public SupplierInfoExt getSupplier() {
        return this.m_Supplier;
    }

    public String getCustomerId() {
        if (this.m_Customer == null) {
            return null;
        }
        return this.m_Customer.getId();
    }

    public void setCustomerId(String string) {
        if (this.m_Customer != null) {
            this.m_Customer.setId(string);
        }
    }

    public String getSupplierId() {
        if (this.m_Supplier == null) {
            return null;
        }
        return this.m_Supplier.getId();
    }

    public String getTransactionID() {
        if (this.getPayments().size() > 0) {
            return this.getPayments().get(this.getPayments().size() - 1).getTransactionID();
        }
        return StringUtils.getCardNumber();
    }

    public String getReturnMessage() {
        if (this.getPayments().get(this.getPayments().size() - 1) instanceof PaymentInfoMagcard) {
            return ((PaymentInfoMagcard)this.getPayments().get(this.getPayments().size() - 1)).getReturnMessage();
        }
        return LocalRes.getIntString("button.ok");
    }

    public void setActiveCash(String string) {
        this.m_sActiveCash = string;
    }

    public String getActiveCash() {
        return this.m_sActiveCash;
    }

    public String getProperty(String string) {
        return this.attributes.getProperty(string);
    }

    public String printProperty(String string) {
        return StringUtils.encodeXML(this.attributes.getProperty(string));
    }

    public String getProperty(String string, String string2) {
        return this.attributes.getProperty(string, string2);
    }

    public void setProperty(String string, String string2) {
        this.attributes.setProperty(string, string2);
    }

    public Properties getProperties() {
        return this.attributes;
    }

    public TicketLineInfo getLine(int n2) {
        return this.m_aLines.get(n2);
    }

    public void addLine(TicketLineInfo ticketLineInfo) {
        ticketLineInfo.setTicket(this.m_sId, this.m_aLines.size());
        this.m_aLines.add(ticketLineInfo);
    }

    public void insertLine(int n2, TicketLineInfo ticketLineInfo) {
        this.m_aLines.add(n2, ticketLineInfo);
        this.a();
    }

    public void setLine(int n2, TicketLineInfo ticketLineInfo) {
        ticketLineInfo.setTicket(this.m_sId, n2);
        this.m_aLines.set(n2, ticketLineInfo);
    }

    public void removeLine(int n2) {
        this.m_aLines.remove(n2);
        this.a();
    }

    private void a() {
        for (int i2 = 0; i2 < this.m_aLines.size(); ++i2) {
            this.getLine(i2).setTicket(this.m_sId, i2);
        }
    }

    public int getLinesCount() {
        return this.m_aLines.size();
    }

    public double getArticlesCount() {
        double d2 = 0.0;
        for (TicketLineInfo ticketLineInfo : this.m_aLines) {
            if (ticketLineInfo.isScale()) {
                d2 += 1.0;
                continue;
            }
            d2 += ticketLineInfo.getMultiply();
        }
        return d2;
    }

    public double getSubTotal() {
        double d2 = 0.0;
        for (TicketLineInfo ticketLineInfo : this.m_aLines) {
            d2 += ticketLineInfo.getSubValue();
        }
        return d2;
    }

    public double getTotalDiscount() {
        double d2 = 0.0;
        for (TicketLineInfo ticketLineInfo : this.m_aLines) {
            d2 += ticketLineInfo.getDiscount();
        }
        return d2;
    }

    public double getTax() {
        double d2 = 0.0;
        for (TicketLineInfo ticketLineInfo : this.m_aLines) {
            d2 += ticketLineInfo.getTax();
        }
        return d2;
    }

    public double getTotal() {
        return this.getSubTotal() + this.getTax();
    }

    public double getTotalPaid() {
        double d2 = 0.0;
        for (PaymentInfo paymentInfo : this.payments) {
            if ("debtpaid".equals(paymentInfo.getName()) || "advancepaid".equals(paymentInfo.getName())) continue;
            d2 += paymentInfo.getTotal();
        }
        return d2;
    }

    public List<TicketLineInfo> getLines() {
        return this.m_aLines;
    }

    public void setLines(List<TicketLineInfo> list) {
        this.m_aLines = list;
    }

    public List<PaymentInfo> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInfo> list) {
        this.payments = list;
    }

    public void resetPayments() {
        this.payments = new ArrayList<PaymentInfo>();
    }

    public List<TicketTaxInfo> getTaxes() {
        return this.taxes;
    }

    public boolean hasTaxesCalculated() {
        return this.taxes != null;
    }

    public void setTaxes(List<TicketTaxInfo> list) {
        this.taxes = list;
    }

    public void resetTaxes() {
        this.taxes = null;
    }

    public TicketTaxInfo getTaxLine(TaxInfo taxInfo) {
        for (TicketTaxInfo ticketTaxInfo : this.taxes) {
            if (!taxInfo.getId().equals(ticketTaxInfo.getTaxInfo().getId())) continue;
            return ticketTaxInfo;
        }
        return new TicketTaxInfo(taxInfo);
    }

    public TicketTaxInfo[] getTaxLines() {
        HashMap<String, TicketTaxInfo> hashMap = new HashMap<String, TicketTaxInfo>();
        for (TicketLineInfo ticketLineInfo : this.m_aLines) {
            TicketTaxInfo ticketTaxInfo = (TicketTaxInfo)hashMap.get(ticketLineInfo.getTaxInfo().getId());
            if (ticketTaxInfo == null) {
                ticketTaxInfo = new TicketTaxInfo(ticketLineInfo.getTaxInfo());
                hashMap.put(ticketTaxInfo.getTaxInfo().getId(), ticketTaxInfo);
            }
            ticketTaxInfo.add(ticketLineInfo.getSubValue());
        }
        Collection collection = hashMap.values();
        return collection.toArray(new TicketTaxInfo[collection.size()]);
    }

    public String printHost() {
        return StringUtils.encodeXML(this.m_sHost);
    }

    public void setHost(String string) {
        this.m_sHost = string;
    }

    public String printId() {
        if (this.m_iTicketId > 0) {
            return Integer.toString(this.m_iTicketId);
        }
        return "";
    }

    public String printDate() {
        return Formats.TIMESTAMP.formatValue(this.m_dDate);
    }

    public String printDateFormatted(String object) {
        try {
            object = new SimpleDateFormat((String)object);
            return ((DateFormat)object).format(this.m_dDate);
        }
        catch (Exception exception) {
            object = exception;
            return exception.getMessage();
        }
    }

    public String printUser() {
        if (this.m_User == null) {
            return "";
        }
        return this.m_User.getName();
    }

    public String printCustomer() {
        if (this.m_Customer == null) {
            return "";
        }
        return this.m_Customer.getName();
    }

    public String printSupplier() {
        if (this.m_Supplier == null) {
            return "";
        }
        return this.m_Supplier.getName();
    }

    public String printArticlesCount() {
        return Formats.DOUBLE.formatValue(new Double(this.getArticlesCount()));
    }

    public String printSubTotal() {
        return Formats.CURRENCY.formatValue(new Double(this.getSubTotal()));
    }

    public String printTax() {
        return Formats.CURRENCY.formatValue(new Double(this.getTax()));
    }

    public String printTotal() {
        return Formats.CURRENCY.formatValue(new Double(this.getTotal()));
    }

    public String printTotalDiscount() {
        return Formats.CURRENCY.formatValue(new Double(this.getTotalDiscount()));
    }

    public String printTotalPaid() {
        return Formats.CURRENCY.formatValue(new Double(this.getTotalPaid()));
    }

    public double parseDouble(String string) {
        return Double.parseDouble(string);
    }

    public int parseInt(String string) {
        return Integer.parseInt(string);
    }

    public double roundDouble(double d2, int n2) {
        if (n2 > 0) {
            return (double)Math.round(d2 * Math.pow(10.0, n2)) / Math.pow(10.0, n2);
        }
        return Math.round(d2);
    }

    public String formatCurrency(Double d2) {
        return Formats.CURRENCY.formatValue(d2);
    }

    public void setGlobalValue(String string) {
        StringUtils.m_sGlobalVariable1 = string;
    }

    public String getGlobalValue() {
        return StringUtils.m_sGlobalVariable1;
    }

    public String TransliterateToArabic(String string) {
        return StringUtils.encodeXML(TransliterateArabic.convert(string));
    }

    public void sendSMS(String object, String string) {
        object = new MessageSMS((String)object, string);
        object = new Thread((Runnable)object);
        ((Thread)object).start();
    }

    public void sendWhatsapp(String string, String string2) {
        new MessageWhatsApp();
        MessageWhatsApp.isConfigured();
    }

    public JSONObject getJson(String string) {
        try {
            return new JSONObject(string);
        }
        catch (JSONException jSONException) {
            System.err.println(jSONException.getMessage());
            return null;
        }
    }

    public void sendKey(String[] stringArray) {
        try {
            int n2;
            Robot robot = new Robot();
            Class<KeyEvent> clazz = KeyEvent.class;
            int[] nArray = new int[stringArray.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                Field field;
                Field field2 = field = clazz.getDeclaredField(stringArray[n2]);
                nArray[n2] = field2.getInt(field2);
                robot.keyPress(nArray[n2]);
            }
            for (n2 = stringArray.length - 1; n2 >= 0; --n2) {
                robot.keyRelease(nArray[n2]);
            }
            return;
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            return;
        }
    }
}

