/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.ticket;

import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataWrite;
import com.posics.data.loader.SerializableRead;
import com.posics.data.loader.SerializableWrite;
import com.posics.format.Formats;
import com.posics.pos.ticket.ProductInfoExt;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.util.StringUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;

public class TicketLineInfo
implements SerializableRead,
SerializableWrite,
Serializable {
    private static final long serialVersionUID = 6608012948284450199L;
    private String m_sTicket;
    private int m_iLine;
    private double multiply;
    private double price;
    private double pricebuy = 0.0;
    private double saleprice;
    private TaxInfo tax;
    private Properties attributes;
    private String productid;
    private String attsetinstid;
    private String m_Code;
    private transient BufferedImage a;

    public TicketLineInfo(String string, double d2, double d3, TaxInfo taxInfo, Properties properties) {
        double d4 = d3;
        this.a(string, null, d2, d4, d4, taxInfo, properties, null);
    }

    public TicketLineInfo(String string, double d2, double d3, TaxInfo taxInfo) {
        double d4 = d3;
        this.a(string, null, d2, d4, d4, taxInfo, new Properties(), null);
    }

    public TicketLineInfo(String string, String string2, String string3, double d2, double d3, TaxInfo taxInfo) {
        Properties properties = new Properties();
        properties.setProperty("product.name", string2);
        properties.setProperty("product.price", Double.toString(d3));
        properties.setProperty("product.taxcategoryid", string3);
        double d4 = d3;
        this.a(string, null, d2, d4, d4, taxInfo, properties, null);
    }

    public TicketLineInfo(String string, String string2, double d2, double d3, TaxInfo taxInfo) {
        Properties properties = new Properties();
        properties.setProperty("product.name", string);
        properties.setProperty("product.price", Double.toString(d3));
        properties.setProperty("product.taxcategoryid", string2);
        double d4 = d3;
        this.a(null, null, d2, d4, d4, taxInfo, properties, null);
    }

    public TicketLineInfo() {
        this.a(null, null, 0.0, 0.0, 0.0, null, new Properties(), null);
    }

    public TicketLineInfo(ProductInfoExt productInfoExt, double d2, double d3, TaxInfo taxInfo, Properties properties) {
        if (productInfoExt == null) {
            double d4 = d3;
            this.a(null, null, d2, d4, d4, taxInfo, properties, productInfoExt.m_sCode);
            return;
        }
        String string = productInfoExt.getID();
        this.pricebuy = productInfoExt.getPriceBuy();
        properties.setProperty("product.name", productInfoExt.getName());
        properties.setProperty("product.price", Double.toString(d3));
        properties.setProperty("product.com", productInfoExt.isCom() ? "true" : "false");
        properties.setProperty("product.scale", productInfoExt.isScale() ? "true" : "false");
        if (productInfoExt.getAttributeSetID() != null) {
            properties.setProperty("product.attsetid", productInfoExt.getAttributeSetID());
        }
        properties.setProperty("product.taxcategoryid", productInfoExt.getTaxCategoryID());
        if (productInfoExt.getCategoryID() != null) {
            properties.setProperty("product.categoryid", productInfoExt.getCategoryID());
        }
        this.a(string, null, d2, productInfoExt.m_dPriceSell, d3, taxInfo, properties, productInfoExt.m_sCode);
    }

    public TicketLineInfo(ProductInfoExt productInfoExt, double d2, TaxInfo taxInfo, Properties properties) {
        this(productInfoExt, 1.0, d2, taxInfo, properties);
    }

    public TicketLineInfo(TicketLineInfo ticketLineInfo) {
        this.a(ticketLineInfo.productid, ticketLineInfo.attsetinstid, ticketLineInfo.multiply, ticketLineInfo.price, ticketLineInfo.saleprice, ticketLineInfo.tax, (Properties)ticketLineInfo.attributes.clone(), ticketLineInfo.m_Code);
    }

    private void a(String string, String string2, double d2, double d3, double d4, TaxInfo taxInfo, Properties properties, String string3) {
        this.productid = string;
        this.attsetinstid = string2;
        this.multiply = d2;
        this.price = d3;
        this.saleprice = d4;
        this.tax = taxInfo;
        this.attributes = properties;
        this.m_Code = string3;
        this.m_sTicket = null;
        this.m_iLine = -1;
    }

    void setTicket(String string, int n2) {
        this.m_sTicket = string;
        this.m_iLine = n2;
    }

    @Override
    public void writeValues(DataWrite dataWrite) {
        dataWrite.setString(1, this.m_sTicket);
        dataWrite.setInt(2, this.m_iLine);
        dataWrite.setString(3, this.productid);
        dataWrite.setString(4, this.attsetinstid);
        dataWrite.setDouble(5, this.multiply);
        dataWrite.setDouble(6, this.pricebuy);
        dataWrite.setDouble(7, this.saleprice);
        dataWrite.setString(8, this.tax.getId());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.attributes.storeToXML((OutputStream)byteArrayOutputStream, "Saleculator", "UTF-8");
            dataWrite.setBytes(9, byteArrayOutputStream.toByteArray());
            return;
        }
        catch (IOException iOException) {
            dataWrite.setBytes(9, null);
            return;
        }
    }

    @Override
    public void readValues(DataRead object) {
        this.m_sTicket = object.getString(1);
        this.m_iLine = object.getInt(2);
        this.productid = object.getString(3);
        this.attsetinstid = object.getString(4);
        this.multiply = object.getDouble(5);
        this.saleprice = object.getDouble(6);
        this.tax = new TaxInfo(object.getString(7), object.getString(8), object.getString(9), object.getString(10), object.getString(11), object.getDouble(12), object.getBoolean(13), object.getInt(14));
        this.attributes = new Properties();
        try {
            byte[] byArray = object.getBytes(15);
            object = byArray;
            if (byArray != null) {
                this.attributes.loadFromXML(new ByteArrayInputStream((byte[])object));
            }
        }
        catch (IOException iOException) {}
        if (this.attributes.containsKey("product.price")) {
            this.price = Double.parseDouble(this.attributes.getProperty("product.price"));
            return;
        }
        this.price = 0.0;
    }

    public TicketLineInfo copyTicketLine() {
        TicketLineInfo ticketLineInfo = new TicketLineInfo();
        new TicketLineInfo().productid = this.productid;
        ticketLineInfo.attsetinstid = this.attsetinstid;
        ticketLineInfo.multiply = this.multiply;
        ticketLineInfo.price = this.price;
        ticketLineInfo.saleprice = this.saleprice;
        ticketLineInfo.tax = this.tax;
        ticketLineInfo.attributes = (Properties)this.attributes.clone();
        return ticketLineInfo;
    }

    public int getTicketLine() {
        return this.m_iLine;
    }

    public void setTicketLine(int n2) {
        this.m_iLine = n2;
    }

    public String getProductID() {
        return this.productid;
    }

    public String getProductName() {
        return this.attributes.getProperty("product.name");
    }

    public String getProductAttSetId() {
        return this.attributes.getProperty("product.attsetid");
    }

    public String getProductAttSetInstDesc() {
        return this.attributes.getProperty("product.attsetdesc", "");
    }

    public void setProductAttSetInstDesc(String string) {
        if (string == null) {
            this.attributes.remove(string);
            return;
        }
        this.attributes.setProperty("product.attsetdesc", string);
    }

    public String getProductAttSetInstId() {
        return this.attsetinstid;
    }

    public void setProductAttSetInstId(String string) {
        this.attsetinstid = string;
    }

    public boolean isProductCom() {
        return "true".equals(this.attributes.getProperty("product.com"));
    }

    public boolean isScale() {
        return "true".equals(this.attributes.getProperty("product.scale"));
    }

    public String getProductTaxCategoryID() {
        return this.attributes.getProperty("product.taxcategoryid");
    }

    public String getProductCategoryID() {
        return this.attributes.getProperty("product.categoryid");
    }

    public double getMultiply() {
        return this.multiply;
    }

    public void setMultiply(double d2) {
        this.multiply = d2;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double d2) {
        this.price = d2;
    }

    public void setSalePrice(double d2) {
        this.saleprice = d2;
    }

    public double getSalePrice() {
        return this.saleprice;
    }

    public double getPriceTax() {
        return this.saleprice * (1.0 + this.getTaxRate());
    }

    public void setPriceTax(double d2) {
        this.saleprice = d2 / (1.0 + this.getTaxRate());
    }

    public TaxInfo getTaxInfo() {
        return this.tax;
    }

    public void setTaxInfo(TaxInfo taxInfo) {
        this.tax = taxInfo;
    }

    public String getProperty(String string) {
        return this.attributes.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.attributes.getProperty(string, string2);
    }

    public void setProperty(String string, String string2) {
        this.attributes.setProperty(string, string2);
    }

    public Properties getProperties() {
        return this.attributes;
    }

    public double getTaxRate() {
        if (this.tax == null) {
            return 0.0;
        }
        return this.tax.getRate();
    }

    public double getDiscount() {
        if (this.saleprice < this.price) {
            return (this.price - this.saleprice) * this.multiply;
        }
        return 0.0;
    }

    public double getSubValueWithoutDiscount() {
        return this.price * this.multiply;
    }

    public double getSubValue() {
        return this.saleprice * this.multiply;
    }

    public double getTax() {
        return this.saleprice * this.multiply * this.getTaxRate();
    }

    public double getValue() {
        return this.saleprice * this.multiply * (1.0 + this.getTaxRate());
    }

    public String printName() {
        return StringUtils.encodeXML(this.attributes.getProperty("product.name"));
    }

    public String getName() {
        return this.attributes.getProperty("product.name");
    }

    public String printCode() {
        return StringUtils.encodeXML(this.m_Code);
    }

    public String printMultiply() {
        return Formats.DOUBLE.formatValue(this.multiply);
    }

    public String printPrice() {
        return Formats.CURRENCY.formatValue(this.getPrice());
    }

    public String printSalePrice() {
        return Formats.CURRENCY.formatValue(this.getSalePrice());
    }

    public String printDiscount() {
        return Formats.CURRENCY.formatValue(this.getDiscount());
    }

    public String printPriceTax() {
        return Formats.CURRENCY.formatValue(this.getPriceTax());
    }

    public String printTax() {
        return Formats.CURRENCY.formatValue(this.getTax());
    }

    public String printTaxRate() {
        return Formats.PERCENT.formatValue(this.getTaxRate());
    }

    public String printSubValue() {
        return Formats.CURRENCY.formatValue(this.getSubValue());
    }

    public String printValue() {
        return Formats.CURRENCY.formatValue(this.getValue());
    }

    public double getPriceBuy() {
        return this.pricebuy;
    }

    public String printPriceBuy() {
        return Formats.CURRENCY.formatValue(this.getPriceBuy());
    }

    public BufferedImage getImage() {
        return this.a;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.a = bufferedImage;
    }
}

