/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.basic.BasicException;
import com.posics.data.loader.BaseSentence;
import com.posics.data.loader.PreparedSentence;
import com.posics.data.loader.SerializerReadString;
import com.posics.data.loader.SerializerWriteString;
import com.posics.data.loader.Session;
import com.posics.data.loader.StaticSentence;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppViewConnection;
import com.posics.pos.forms.JPrincipalApp;
import com.posics.pos.update.UpdateInfo;
import com.posics.pos.util.AltEncrypter;
import com.posics.pos.util.FlashDrive;
import com.posics.pos.util.PThread;
import com.posics.pos.util.RenderCheck;
import com.posics.pos.util.StringUtils;
import com.posics.pos.util.Updater;
import com.posics.pos.util.WaitDialog;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Backup {
    public static void takeBackup(Component component, String object) {
        block11: {
            try {
                if (FlashDrive.MountFlashDrive(component)) {
                    Object object2 = new JFileChooser();
                    ((JFileChooser)object2).setDialogTitle("Save to");
                    ((JFileChooser)object2).setApproveButtonText("Save");
                    ((JComponent)object2).setToolTipText("Selecting required folder");
                    String string = StringUtils.config.getProperty("Usb.Location");
                    ((JFileChooser)object2).setCurrentDirectory(new File(string));
                    ((JFileChooser)object2).setSelectedFile(new File("Saleculator"));
                    int n2 = ((JFileChooser)object2).showOpenDialog(component);
                    if (n2 == 0) {
                        Object object3;
                        object2 = ((JFileChooser)object2).getSelectedFile().getAbsolutePath();
                        String string2 = StringUtils.config.getProperty("db.user");
                        String string3 = StringUtils.config.getProperty("db.password");
                        if (string2 != null && string3 != null && string3.startsWith("crypt:")) {
                            object3 = new AltEncrypter("cypherkey" + string2);
                            string3 = ((AltEncrypter)object3).decrypt(string3.substring(6));
                        }
                        object3 = Backup.getDBName(StringUtils.config.getProperty("db.URL"));
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy");
                        Date date = new Date();
                        if (((String)object3).startsWith("jdbc:derby")) {
                            JPrincipalApp jPrincipalApp = (JPrincipalApp)component;
                            object = new StaticSentence(jPrincipalApp.getAppview().getSession(), "CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE('" + (String)object2 + "') ");
                            WaitDialog.showDialog("Processing backup...");
                            ((BaseSentence)object).exec();
                            WaitDialog.hideDialog();
                            JOptionPane.showMessageDialog(component, AppLocal.getIntString("message.backupcompleted"), "Saleculator Backup", 1);
                            break block11;
                        }
                        Backup.dbHealthCheck((String)object3, string2, string3);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (object != null && ((String)object).trim().length() > 0) {
                            object3 = (String)object3 + " " + (String)object;
                        }
                        if (((String)(object = System.getProperty("os.name").toLowerCase())).contains("nix") || ((String)object).contains("nux") || ((String)object).contains("aix")) {
                            arrayList.add("bash");
                            arrayList.add("-c");
                            arrayList.add("mysqldump --user=" + string2 + " --password=" + string3 + " " + (String)object3 + " | bzip2 > " + (String)object2 + simpleDateFormat.format(date) + ".bz2");
                        } else {
                            arrayList.add("cmd.exe");
                            arrayList.add("/c");
                            arrayList.add(StringUtils.config.getProperty("Script.MysqlPath") + "mysqldump -u " + string2 + " -p" + string3 + " " + (String)object3 + " > " + (String)object2 + simpleDateFormat.format(date) + ".sql");
                        }
                        WaitDialog.showDialog("Processing backup...");
                        object2 = new ProcessBuilder(arrayList);
                        ((ProcessBuilder)object2).redirectErrorStream(true);
                        ((ProcessBuilder)object2).redirectOutput(ProcessBuilder.Redirect.INHERIT);
                        object2 = ((ProcessBuilder)object2).start();
                        ((Process)object2).waitFor();
                        WaitDialog.hideDialog();
                        if (((Process)object2).exitValue() == 0) {
                            if (((String)object).contains("nix") || ((String)object).contains("nux") || ((String)object).contains("aix")) {
                                FlashDrive.UnmountFlashDrive();
                            }
                            JOptionPane.showMessageDialog(component, AppLocal.getIntString("message.backupcompleted"), "Saleculator Backup", 1);
                            break block11;
                        }
                        JOptionPane.showMessageDialog(component, "Backup Failed:" + ((Process)object2).exitValue(), "Saleculator Backup", 0);
                    }
                }
                return;
            }
            catch (Exception exception) {
                WaitDialog.hideDialog();
                JOptionPane.showMessageDialog(component, "Backup Failed:" + exception.toString(), "Saleculator Backup", 0);
            }
        }
    }

    public static void dbHealthCheck(String string, String string2, String string3) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = System.getProperty("os.name").toLowerCase();
            if (string4.contains("nix") || string4.contains("nux") || string4.contains("aix")) {
                arrayList.add("bash");
                arrayList.add("-c");
                arrayList.add("mysqlcheck --user=" + string2 + " --password=" + string3 + " --databases=" + string + " --check");
            } else {
                arrayList.add("cmd.exe");
                arrayList.add("/c");
                arrayList.add(StringUtils.config.getProperty("Script.MysqlPath") + "mysqlcheck -u " + string2 + " -p" + string3 + " --databases " + string + " --check");
            }
            WaitDialog.showDialog("Checking database health...");
            Object object = new ProcessBuilder(arrayList);
            ((ProcessBuilder)object).redirectErrorStream(true);
            ((ProcessBuilder)object).redirectOutput(ProcessBuilder.Redirect.INHERIT);
            object = ((ProcessBuilder)object).start();
            ((Process)object).waitFor();
            arrayList.clear();
            if (string4.contains("nix") || string4.contains("nux") || string4.contains("aix")) {
                arrayList.add("bash");
                arrayList.add("-c");
                arrayList.add("mysqlcheck --user=" + string2 + " --password=" + string3 + " --databases=" + string + " --optimize");
            } else {
                arrayList.add("cmd.exe");
                arrayList.add("/c");
                arrayList.add(StringUtils.config.getProperty("Script.MysqlPath") + "mysqlcheck -u " + string2 + " -p" + string3 + " --databases " + string + " --optimize");
            }
            object = new ProcessBuilder(arrayList);
            ((ProcessBuilder)object).redirectErrorStream(true);
            ((ProcessBuilder)object).redirectOutput(ProcessBuilder.Redirect.INHERIT);
            object = ((ProcessBuilder)object).start();
            ((Process)object).waitFor();
            WaitDialog.hideDialog();
            if (((Process)object).exitValue() != 0) {
                System.out.println("DB Health check failed.");
                return;
            }
            System.out.println("DB Health check successful.");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public static void restoreBackup(Component component) {
        try {
            String string;
            String string2;
            String string3;
            block12: {
                block11: {
                    Map<String, String> map;
                    if (!FlashDrive.MountFlashDrive(component)) break block11;
                    Object object = new JFileChooser();
                    ((JFileChooser)object).setDialogTitle("Restore From");
                    ((JFileChooser)object).setApproveButtonText("Restore");
                    ((JComponent)object).setToolTipText("Selecting required folder");
                    string3 = StringUtils.config.getProperty("Usb.Location");
                    ((JFileChooser)object).setCurrentDirectory(new File(string3));
                    ((JFileChooser)object).setSelectedFile(new File(""));
                    string3 = Backup.getDBName(StringUtils.config.getProperty("db.URL"));
                    if (string3.startsWith("jdbc:derby")) {
                        JOptionPane.showMessageDialog(component, "Please copy backup folder Saleculator-database to " + System.getProperty("user.home") + " and restart.", "Saleculator Restore", 1);
                        return;
                    }
                    int n2 = ((JFileChooser)object).showOpenDialog(component);
                    if (n2 != 0) break block11;
                    object = ((JFileChooser)object).getSelectedFile().getAbsolutePath();
                    string2 = StringUtils.config.getProperty("db.user");
                    string = StringUtils.config.getProperty("db.password");
                    if (string2 != null && string != null && string.startsWith("crypt:")) {
                        map = new AltEncrypter("cypherkey" + string2);
                        string = ((AltEncrypter)((Object)map)).decrypt(string.substring(6));
                    }
                    if (string3.startsWith("jdbc:derby")) break block11;
                    WaitDialog.showDialog("Restoring...");
                    map = new ArrayList();
                    String string4 = System.getProperty("os.name").toLowerCase();
                    if (string4.contains("nix") || string4.contains("nux") || string4.contains("aix")) {
                        ((ArrayList)((Object)map)).add("bash");
                        ((ArrayList)((Object)map)).add("-c");
                        if (((String)object).endsWith(".bz2")) {
                            ((ArrayList)((Object)map)).add("bunzip2 < " + (String)object + " | mysql --user=" + string2 + " --password=" + string + " " + string3);
                        } else {
                            ((ArrayList)((Object)map)).add("mysql --user=" + string2 + " --password=" + string + " " + string3 + " < " + (String)object);
                        }
                    } else {
                        ((ArrayList)((Object)map)).add("cmd.exe");
                        ((ArrayList)((Object)map)).add("/c");
                        ((ArrayList)((Object)map)).add("mysql -u " + string2 + " -p" + string + " " + string3 + " < " + (String)object);
                    }
                    object = new ProcessBuilder((List<String>)((Object)map));
                    map = ((ProcessBuilder)object).environment();
                    System.out.println(map.get("Path"));
                    map.put("Path", StringUtils.config.getProperty("Script.MysqlPath"));
                    ((ProcessBuilder)object).redirectErrorStream(true);
                    ((ProcessBuilder)object).redirectOutput(ProcessBuilder.Redirect.INHERIT);
                    object = ((ProcessBuilder)object).start();
                    ((Process)object).waitFor();
                    WaitDialog.hideDialog();
                    if (((Process)object).exitValue() == 0) break block12;
                    JOptionPane.showMessageDialog(component, "Restore Failed:" + ((Process)object).exitValue(), "Saleculator Restore", 0);
                }
                return;
            }
            Backup.dbHealthCheck(string3, string2, string);
            JOptionPane.showMessageDialog(component, AppLocal.getIntString("message.restorecompleted"), "Saleculator Restore", 1);
            Backup.restartApplication(component);
        }
        catch (Exception exception) {
            WaitDialog.hideDialog();
            JOptionPane.showMessageDialog(component, "Restore Failed:" + exception.toString(), "Saleculator Restore", 0);
        }
    }

    public static void restartApplication(Component component) {
        try {
            Object object = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add((String)object);
            arrayList.add("-jar");
            object = System.getProperty("os.name").toLowerCase();
            if (((String)object).contains("nix") || ((String)object).contains("nux") || ((String)object).contains("aix")) {
                arrayList.add("/opt/Saleculator/Saleculator.jar");
            } else {
                object = new File(".").getAbsolutePath();
                object = ((String)object).replace(".", "");
                arrayList.add((String)object + "Saleculator.jar");
            }
            object = new ProcessBuilder(arrayList);
            ((ProcessBuilder)object).redirectErrorStream(true);
            ((ProcessBuilder)object).redirectOutput(ProcessBuilder.Redirect.INHERIT);
            ((ProcessBuilder)object).start();
            System.exit(0);
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(component, "Saleculator failed to restart:" + exception.toString(), "Restart", 0);
            return;
        }
    }

    public static void executeSQLForm(Component component) {
        try {
            Object object = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add((String)object);
            arrayList.add("-cp");
            object = System.getProperty("os.name").toLowerCase();
            if (((String)object).contains("nix") || ((String)object).contains("nux") || ((String)object).contains("aix")) {
                arrayList.add("/opt/Saleculator/Saleculator.jar");
            } else {
                object = new File(".").getAbsolutePath();
                object = ((String)object).replace(".", "");
                arrayList.add((String)object + "Saleculator.jar");
            }
            arrayList.add("com.posics.pos.sql.JFrmSQL");
            object = new ProcessBuilder(arrayList);
            ((ProcessBuilder)object).redirectErrorStream(true);
            ((ProcessBuilder)object).redirectOutput(ProcessBuilder.Redirect.INHERIT);
            ((ProcessBuilder)object).start();
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(component, "Failed to load SQL Window:" + exception.toString(), "Execute SQL", 0);
            return;
        }
    }

    public static void dropDatabase(Component component) {
        Session session = AppViewConnection.createSession(StringUtils.config);
        try {
            StaticSentence staticSentence = new StaticSentence(session, "DROP DATABASE IF EXISTS " + Backup.getDBName(StringUtils.config.getProperty("db.URL")));
            staticSentence.exec();
            staticSentence = new StaticSentence(session, "CREATE DATABASE " + Backup.getDBName(StringUtils.config.getProperty("db.URL")));
            staticSentence.exec();
            session.close();
            return;
        }
        catch (Exception exception) {
            session.close();
            JOptionPane.showMessageDialog(component, "Reset to original failed:" + exception.toString(), "Reset to Original", 0);
            return;
        }
    }

    public static ArrayList<Date> getMaxDates() {
        ArrayList<Date> arrayList = new ArrayList<Date>();
        try {
            Session session = AppViewConnection.createSession(StringUtils.config);
            Object object = new PreparedSentence(session, "SELECT MIN(DATENEW) FROM RECEIPTS WHERE 1=? ", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
            object = (String)object.find((Object)"1");
            if (object != null) {
                object = new SimpleDateFormat("yyyy-MM-dd").parse((String)object);
                arrayList.add((Date)object);
            } else {
                arrayList.add(null);
            }
            object = new PreparedSentence(session, "SELECT MIN(DATESTART) FROM CLOSEDCASH WHERE 1=? ", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
            object = (String)object.find((Object)"1");
            if (object != null) {
                object = new SimpleDateFormat("yyyy-MM-dd").parse((String)object);
                arrayList.add((Date)object);
            } else {
                arrayList.add(null);
            }
            session.close();
            return arrayList;
        }
        catch (BasicException basicException) {
            arrayList.add(new Date());
            arrayList.add(new Date());
            System.err.println(basicException.getMessage());
            return arrayList;
        }
        catch (Exception exception) {
            arrayList.add(new Date());
            arrayList.add(new Date());
            return arrayList;
        }
    }

    public static void deactivate(Component component) {
        File file = new File(System.getProperty("user.home"));
        String[] stringArray = file.list();
        String[] stringArray2 = stringArray;
        stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = stringArray2[i2];
            try {
                object = new File(file.getPath(), (String)object);
                ((File)object).delete();
                continue;
            }
            catch (Exception exception) {}
        }
        Backup.dropDatabase(component);
    }

    public static void resetToOriginal(Component component) {
        block4: {
            block2: {
                block3: {
                    int n2 = JOptionPane.showConfirmDialog(component, AppLocal.getIntString("message.resettooriginalconfirmation"), "Saleculator Reset", 2);
                    if (n2 != 0) break block2;
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BoxLayout(jPanel, 1));
                    JLabel jLabel = new JLabel("Type 'CONFIRM' to confirm the reset to original settings:");
                    JTextField jTextField = new JTextField(10);
                    jPanel.add(jLabel);
                    jPanel.add(jTextField);
                    int n3 = JOptionPane.showConfirmDialog(component, jPanel, "Confirm Reset to Original", 2, 2);
                    if (n3 != 0) break block3;
                    String string = jTextField.getText();
                    if ("CONFIRM".equalsIgnoreCase(string)) break block4;
                    JOptionPane.showMessageDialog(component, "Incorrect confirmation text. Reset aborted.", "Error", 0);
                }
                return;
            }
            return;
        }
        Backup.dropDatabase(component);
        JOptionPane.showMessageDialog(component, AppLocal.getIntString("message.resettooriginalcompleted"), "Reset to Original", 1);
        Backup.restartApplication(component);
    }

    public static void checkTrialDays(Component component) {
        Session session = AppViewConnection.createSession(StringUtils.config);
        try {
            StaticSentence staticSentence = new StaticSentence(session, "DROP DATABASE IF EXISTS " + Backup.getDBName(StringUtils.config.getProperty("db.URL")));
            staticSentence.exec();
            staticSentence = new StaticSentence(session, "CREATE DATABASE " + Backup.getDBName(StringUtils.config.getProperty("db.URL")));
            staticSentence.exec();
            session.close();
            return;
        }
        catch (Exception exception) {
            session.close();
            JOptionPane.showMessageDialog(component, "Reset to original failed:" + exception.toString(), "Reset to Original", 0);
            return;
        }
    }

    public static void updateSoftware(Component component) {
        block9: {
            try {
                int n2 = JOptionPane.showConfirmDialog(null, AppLocal.getIntString("message.updatesaleculator"), "Saleculator Update", 1);
                if (n2 == 1) {
                    if (FlashDrive.MountFlashDrive(component)) {
                        Object object = new JFileChooser();
                        ((JFileChooser)object).setDialogTitle("Update From");
                        ((JFileChooser)object).setApproveButtonText("Update");
                        ((JComponent)object).setToolTipText("Selecting required folder");
                        String string = StringUtils.config.getProperty("Usb.Location");
                        ((JFileChooser)object).setCurrentDirectory(new File(string));
                        ((JFileChooser)object).setSelectedFile(new File("update.zip"));
                        int n3 = ((JFileChooser)object).showOpenDialog(component);
                        if (n3 != 0) break block9;
                        object = ((JFileChooser)object).getSelectedFile().getAbsolutePath();
                        try {
                            object = new com.saleculator.updater.Updater((String)object);
                            object.setVisible(true);
                        }
                        catch (Exception exception) {
                            object = exception;
                            exception.printStackTrace();
                            break block9;
                        }
                    }
                } else if (n2 == 0) {
                    if (!Updater.getLatestVersion().equals("v4.4u1")) {
                        UpdateInfo updateInfo = new UpdateInfo();
                        updateInfo.showhistory("v4.4u1", Updater.getLatestVersion());
                        break block9;
                    }
                    JOptionPane.showMessageDialog(component, "This Saleculator is up to date.", "Saleculator Update", 1);
                }
                return;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(component, "Update Failed:" + exception.toString(), "Saleculator Update", 0);
            }
        }
    }

    public static void turnoff(Component component) {
        String string = StringUtils.config.getProperty("Script.TurnOff");
        Object object = System.getProperty("os.name").toLowerCase();
        if (string.equals("") || !((String)object).contains("nix") && !((String)object).contains("nux") && !((String)object).contains("aix")) {
            System.exit(0);
            return;
        }
        object = Runtime.getRuntime();
        try {
            ((Runtime)object).exec(string);
            System.exit(0);
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(component, "System shutdown failed:" + exception.toString() + " - Please press Power Switch to Turn Off.", "Turn Off", 0);
            System.exit(0);
            return;
        }
    }

    public static void pconfirm() {
        if (!StringUtils.m_blIsPCheckRunning) {
            try {
                if (StringUtils.m_blIsOnline) {
                    RenderCheck.beat("RunningWithoutLicense");
                }
                PThread pThread = new PThread();
                pThread.start();
                StringUtils.m_blIsPCheckRunning = true;
                return;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
    }

    public static String getDBName(String string) {
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(63);
        if (n3 >= 0) {
            return string.substring(n2 + 1, n3);
        }
        return string.substring(n2 + 1);
    }

    public static void readFile(Component component) {
        try {
            if (FlashDrive.MountFlashDrive(component)) {
                Object object = new JFileChooser();
                ((JFileChooser)object).setDialogTitle("Read From");
                ((JFileChooser)object).setApproveButtonText("Read");
                ((JComponent)object).setToolTipText("Selecting required folder");
                String string = StringUtils.config.getProperty("Usb.Location");
                ((JFileChooser)object).setCurrentDirectory(new File(string));
                ((JFileChooser)object).setSelectedFile(new File(""));
                int n2 = ((JFileChooser)object).showOpenDialog(component);
                if (n2 == 0) {
                    object = ((JFileChooser)object).getSelectedFile().getAbsolutePath();
                    object = new FileReader((String)object);
                    new BufferedReader((Reader)object);
                }
            }
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(component, "Read Failed:" + exception.toString(), "Resources", 0);
            return;
        }
    }
}

