/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.codabar.CodabarBean;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5Bean;
import org.krysalis.barcode4j.impl.postnet.POSTNETBean;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import org.krysalis.barcode4j.impl.upcean.EAN8Bean;
import org.krysalis.barcode4j.impl.upcean.UPCABean;
import org.krysalis.barcode4j.impl.upcean.UPCEBean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.java2d.Java2DCanvasProvider;

public class BarcodeImage {
    public static Image getBarcodeCodabar(String string) {
        CodabarBean codabarBean = new CodabarBean();
        codabarBean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        return BarcodeImage.a(string, (AbstractBarcodeBean)codabarBean);
    }

    public static Image getBarcodeCode39(String string) {
        Code39Bean code39Bean = new Code39Bean();
        code39Bean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        return BarcodeImage.a(string, (AbstractBarcodeBean)code39Bean);
    }

    public static Image getBarcodeInterleaved2Of5(String string) {
        Interleaved2Of5Bean interleaved2Of5Bean = new Interleaved2Of5Bean();
        interleaved2Of5Bean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        return BarcodeImage.a(string, (AbstractBarcodeBean)interleaved2Of5Bean);
    }

    public static Image getBarcodePOSTNET(String string) {
        POSTNETBean pOSTNETBean = new POSTNETBean();
        pOSTNETBean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        return BarcodeImage.a(string, (AbstractBarcodeBean)pOSTNETBean);
    }

    public static Image getBarcodeUPCA(String string) {
        UPCABean uPCABean = new UPCABean();
        uPCABean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        return BarcodeImage.a(string, (AbstractBarcodeBean)uPCABean);
    }

    public static Image getBarcodeUPCE(String string) {
        UPCEBean uPCEBean = new UPCEBean();
        uPCEBean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        return BarcodeImage.a(string, (AbstractBarcodeBean)uPCEBean);
    }

    public static Image getBarcodeEAN13(String string) {
        EAN13Bean eAN13Bean = new EAN13Bean();
        eAN13Bean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        return BarcodeImage.a(string, (AbstractBarcodeBean)eAN13Bean);
    }

    public static Image getBarcodeEAN8(String string) {
        EAN8Bean eAN8Bean = new EAN8Bean();
        eAN8Bean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        return BarcodeImage.a(string, (AbstractBarcodeBean)eAN8Bean);
    }

    public static Image getBarcode128(String string) {
        Code128Bean code128Bean = new Code128Bean();
        code128Bean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
        return BarcodeImage.a(string, (AbstractBarcodeBean)code128Bean);
    }

    private static Image a(String string, AbstractBarcodeBean abstractBarcodeBean) {
        abstractBarcodeBean.setModuleWidth(1.0);
        abstractBarcodeBean.setBarHeight(40.0);
        abstractBarcodeBean.setFontSize(10.0);
        abstractBarcodeBean.setQuietZone(10.0);
        abstractBarcodeBean.doQuietZone(true);
        BarcodeDimension barcodeDimension = abstractBarcodeBean.calcDimensions(string);
        int n2 = (int)barcodeDimension.getWidth(0) + 20;
        int n3 = (int)barcodeDimension.getHeight(0);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.setColor(Color.BLACK);
        try {
            abstractBarcodeBean.generateBarcode((CanvasProvider)new Java2DCanvasProvider(graphics2D, 0), string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            graphics2D.drawRect(0, 0, n2 - 1, n3 - 1);
            graphics2D.drawString(string, 2, n3 - 3);
        }
        graphics2D.dispose();
        return bufferedImage;
    }
}

