/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.data.gui.MessageInf;
import com.posics.pos.config.LAFColors;
import com.posics.pos.util.FlashDrive;
import com.posics.pos.util.MessageEmail;
import com.posics.pos.util.StringUtils;
import com.posics.pos.util.k;
import com.posics.pos.util.l;
import com.posics.pos.util.m;
import com.posics.pos.util.n;
import com.posics.pos.util.o;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.ImageMapRenderable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.PrintParts;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.engine.util.SimpleFileResolver;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import net.sf.jasperreports.view.JRHyperlinkListener;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.SaveContributorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRViewer
extends JPanel
implements JRHyperlinkListener {
    private static final Log a = LogFactory.getLog(JRViewer.class);
    private static final long serialVersionUID = 10200L;
    public static final String VIEWER_RENDER_BUFFER_MAX_SIZE = "net.sf.jasperreports.viewer.render.buffer.max.size";
    protected static final int TYPE_FILE_NAME = 1;
    protected static final int TYPE_INPUT_STREAM = 2;
    protected static final int TYPE_OBJECT = 3;
    public static final int REPORT_RESOLUTION = 72;
    protected final float MIN_ZOOM = 0.5f;
    protected final float MAX_ZOOM = 10.0f;
    protected int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250, 400, 800};
    protected int defaultZoomIndex = 2;
    protected int type = 1;
    protected boolean isXML;
    protected String reportFileName;
    JasperPrint jasperPrint;
    private int pageIndex;
    private boolean pageError;
    protected float zoom;
    private JRGraphics2DExporter exporter;
    public boolean isOnline = false;
    private int screenResolution = 72;
    protected float realZoom;
    private DecimalFormat zoomDecimalFormat = new DecimalFormat("#.##");
    protected JasperReportsContext jasperReportsContext;
    protected LocalJasperReportsContext localJasperReportsContext;
    private ResourceBundle resourceBundle;
    private int downX;
    private int downY;
    private boolean pnlTabsChangeListenerEnabled = true;
    private List<JRHyperlinkListener> hyperlinkListeners = new ArrayList<JRHyperlinkListener>();
    private Map<JPanel, JRPrintHyperlink> linksMap = new HashMap<JPanel, JRPrintHyperlink>();
    private MouseListener mouseListener = new k(this);
    protected KeyListener keyNavigationListener = new l(this);
    protected List<JRSaveContributor> saveContributors = new ArrayList<JRSaveContributor>();
    protected File lastFolder;
    protected JRSaveContributor lastSaveContributor;
    protected JToggleButton btnActualSize;
    protected JButton btnFirst;
    protected JToggleButton btnFitPage;
    protected JToggleButton btnFitWidth;
    protected JButton btnLast;
    protected JButton btnNext;
    protected JButton btnPrevious;
    protected JButton btnPrint;
    protected JButton btnReload;
    protected JButton btnSave;
    protected JButton btnZoomIn;
    protected JButton btnZoomOut;
    protected JComboBox cmbZoom;
    private JLabel jLabel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JLabel lblPage;
    protected JLabel lblStatus;
    private JPanel pnlInScroll;
    private JPanel pnlLinks;
    private JPanel pnlMain;
    private JPanel pnlPage;
    protected JPanel pnlSep01;
    protected JPanel pnlSep02;
    protected JPanel pnlSep03;
    protected JPanel pnlStatus;
    private JTabbedPane pnlTabs;
    private JScrollPane scrollPane;
    protected JPanel tlbToolBar;
    protected JTextField txtGoTo;
    protected JButton btnEmail;

    public JRViewer(String string, boolean bl2) {
        this(string, bl2, null);
    }

    public JRViewer(InputStream inputStream, boolean bl2) {
        this(inputStream, bl2, null);
    }

    public JRViewer(JasperPrint jasperPrint) {
        this(jasperPrint, null);
    }

    public JRViewer(String string, boolean bl2, Locale locale) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), string, bl2, locale, null);
    }

    public JRViewer(InputStream inputStream, boolean bl2, Locale locale) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), inputStream, bl2, locale, null);
    }

    public JRViewer(JasperPrint jasperPrint, Locale locale) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jasperPrint, locale, null);
    }

    public JRViewer(JasperReportsContext jasperReportsContext, String string, boolean bl2, Locale locale, ResourceBundle resourceBundle) {
        this.jasperReportsContext = jasperReportsContext;
        this.initResources(locale, resourceBundle);
        this.a();
        this.setZooms();
        this.b();
        this.loadReport(string, bl2);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        JRViewer jRViewer = this;
        jRViewer.addHyperlinkListener(jRViewer);
        this.btnEmail.setEnabled(this.isOnline);
    }

    public JRViewer(JasperReportsContext jasperReportsContext, InputStream inputStream, boolean bl2, Locale locale, ResourceBundle resourceBundle) {
        this.jasperReportsContext = jasperReportsContext;
        this.initResources(locale, resourceBundle);
        this.a();
        this.setZooms();
        this.b();
        this.loadReport(inputStream, bl2);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        JRViewer jRViewer = this;
        jRViewer.addHyperlinkListener(jRViewer);
    }

    public JRViewer(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint, Locale locale, ResourceBundle resourceBundle) {
        this.jasperReportsContext = jasperReportsContext;
        this.initResources(locale, resourceBundle);
        this.a();
        this.setZooms();
        this.b();
        this.loadReport(jasperPrint);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        JRViewer jRViewer = this;
        jRViewer.addHyperlinkListener(jRViewer);
    }

    public void loadJasperPrint(JasperPrint jasperPrint) {
        this.loadReport(jasperPrint);
        JRViewer jRViewer = this;
        jRViewer.setZoomRatio((float)jRViewer.zooms[this.defaultZoomIndex] / 100.0f);
        this.cmbZoomItemStateChanged(null);
        this.refreshPage();
    }

    private void a() {
        this.screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public void clear() {
        JRViewer jRViewer = this;
        jRViewer.a(jRViewer);
        this.jasperPrint = null;
    }

    protected void setZooms() {
    }

    public void addSaveContributor(JRSaveContributor jRSaveContributor) {
        this.saveContributors.add(jRSaveContributor);
    }

    public void removeSaveContributor(JRSaveContributor jRSaveContributor) {
        this.saveContributors.remove(jRSaveContributor);
    }

    public JRSaveContributor[] getSaveContributors() {
        return this.saveContributors.toArray(new JRSaveContributor[this.saveContributors.size()]);
    }

    public void setSaveContributors(JRSaveContributor[] jRSaveContributorArray) {
        this.saveContributors = new ArrayList<JRSaveContributor>();
        if (jRSaveContributorArray != null) {
            this.saveContributors.addAll(Arrays.asList(jRSaveContributorArray));
        }
    }

    public void addHyperlinkListener(JRHyperlinkListener jRHyperlinkListener) {
        this.hyperlinkListeners.add(jRHyperlinkListener);
    }

    public void removeHyperlinkListener(JRHyperlinkListener jRHyperlinkListener) {
        this.hyperlinkListeners.remove(jRHyperlinkListener);
    }

    public JRHyperlinkListener[] getHyperlinkListeners() {
        return this.hyperlinkListeners.toArray(new JRHyperlinkListener[this.hyperlinkListeners.size()]);
    }

    protected void initResources(Locale locale, ResourceBundle resourceBundle) {
        this.setLocale(locale != null ? locale : Locale.getDefault());
        this.resourceBundle = resourceBundle == null ? ResourceBundle.getBundle("net/sf/jasperreports/view/viewer", this.getLocale()) : resourceBundle;
    }

    protected JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    protected String getBundleString(String string) {
        return this.resourceBundle.getString(string);
    }

    protected void initSaveContributors() {
        List list = SaveContributorUtils.createBuiltinContributors((JasperReportsContext)this.jasperReportsContext, (Locale)this.getLocale(), (ResourceBundle)this.resourceBundle);
        this.saveContributors.addAll(list);
    }

    public void gotoHyperlink(JRPrintHyperlink object) {
        switch (object.getHyperlinkTypeValue()) {
            case REFERENCE: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + object.getHyperlinkReference());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                return;
            }
            case LOCAL_ANCHOR: {
                if (object.getHyperlinkAnchor() == null) break;
                Object object2 = this.jasperPrint.getAnchorIndexes();
                object = (JRPrintAnchorIndex)object2.get(object.getHyperlinkAnchor());
                if (object.getPageIndex() != this.pageIndex) {
                    this.a(object.getPageIndex());
                    this.refreshPage();
                }
                if ((object2 = this.pnlInScroll.getParent()) instanceof JViewport) {
                    object2 = (JViewport)object2;
                    int n2 = (int)((float)object.getElementAbsoluteX() * this.realZoom);
                    int n3 = (int)((float)object.getElementAbsoluteY() * this.realZoom);
                    int n4 = this.pnlInScroll.getWidth() - ((JComponent)object2).getWidth();
                    int n5 = this.pnlInScroll.getHeight() - ((JComponent)object2).getHeight();
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n2 > n4) {
                        n2 = n4;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (n3 > n5) {
                        n3 = n5;
                    }
                    ((JViewport)object2).setViewPosition(new Point(n2, n3));
                }
                return;
            }
            case LOCAL_PAGE: {
                int n6 = this.pageIndex + 1;
                if (object.getHyperlinkPage() != null) {
                    n6 = object.getHyperlinkPage();
                }
                if (n6 <= 0 || n6 > this.jasperPrint.getPages().size() || n6 == this.pageIndex + 1) break;
                this.a(n6 - 1);
                this.refreshPage();
                object = this.pnlInScroll.getParent();
                if (object instanceof JViewport) {
                    ((JViewport)object).setViewPosition(new Point(0, 0));
                }
                return;
            }
            default: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
            }
        }
    }

    protected boolean isOnlyHyperlinkListener() {
        int n2;
        int n3 = n2 = this.hyperlinkListeners == null ? 0 : this.hyperlinkListeners.size();
        if (this.hyperlinkListeners != null && this.hyperlinkListeners.contains(this)) {
            --n2;
        }
        return n2 == 0;
    }

    private void b() {
        this.tlbToolBar = new JPanel();
        this.btnSave = new JButton();
        this.btnEmail = new JButton();
        this.btnPrint = new JButton();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.btnFirst = new JButton();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.btnLast = new JButton();
        this.txtGoTo = new JTextField();
        this.pnlSep02 = new JPanel();
        this.btnActualSize = new JToggleButton();
        this.btnFitPage = new JToggleButton();
        this.btnFitWidth = new JToggleButton();
        this.pnlSep03 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        Serializable serializable2 = new Dimension(40, 30);
        this.btnSave.setPreferredSize((Dimension)serializable2);
        this.btnEmail.setPreferredSize((Dimension)serializable2);
        this.btnPrint.setPreferredSize((Dimension)serializable2);
        this.btnReload.setPreferredSize((Dimension)serializable2);
        this.btnFirst.setPreferredSize((Dimension)serializable2);
        this.btnPrevious.setPreferredSize((Dimension)serializable2);
        this.btnNext.setPreferredSize((Dimension)serializable2);
        this.btnLast.setPreferredSize((Dimension)serializable2);
        this.btnActualSize.setPreferredSize((Dimension)serializable2);
        this.btnFitPage.setPreferredSize((Dimension)serializable2);
        this.btnFitWidth.setPreferredSize((Dimension)serializable2);
        this.btnZoomIn.setPreferredSize((Dimension)serializable2);
        this.btnZoomOut.setPreferredSize((Dimension)serializable2);
        this.btnSave.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnEmail.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnPrint.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnReload.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnFirst.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnPrevious.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnNext.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnLast.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnActualSize.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnFitPage.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnFitWidth.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnZoomIn.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnZoomOut.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.btnSave.setBackground(LAFColors.COLOR_BUTTON);
        this.btnEmail.setBackground(LAFColors.COLOR_BUTTON);
        this.btnPrint.setBackground(LAFColors.COLOR_BUTTON);
        this.btnReload.setBackground(LAFColors.COLOR_BUTTON);
        this.btnFirst.setBackground(LAFColors.COLOR_BUTTON);
        this.btnPrevious.setBackground(LAFColors.COLOR_BUTTON);
        this.btnNext.setBackground(LAFColors.COLOR_BUTTON);
        this.btnLast.setBackground(LAFColors.COLOR_BUTTON);
        this.btnActualSize.setBackground(LAFColors.COLOR_BUTTON);
        this.btnFitPage.setBackground(LAFColors.COLOR_BUTTON);
        this.btnFitWidth.setBackground(LAFColors.COLOR_BUTTON);
        this.btnZoomIn.setBackground(LAFColors.COLOR_BUTTON);
        this.btnZoomOut.setBackground(LAFColors.COLOR_BUTTON);
        this.tlbToolBar.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        this.pnlSep01.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        this.pnlSep02.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        this.pnlSep03.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        serializable2 = new DefaultComboBoxModel();
        Object object = this.zooms;
        int n2 = this.zooms.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = object[i2];
            ((DefaultComboBoxModel)serializable2).addElement(n3 + "%");
        }
        this.cmbZoom.setModel(serializable2);
        this.pnlMain = new JPanel();
        this.pnlTabs = new JTabbedPane();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.pnlLinks = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        JRViewer jRViewer = this;
        this.lblPage = jRViewer.new PageRenderer(jRViewer);
        this.pnlStatus = new JPanel();
        this.lblStatus = new JLabel();
        this.setMinimumSize(new Dimension(450, 150));
        this.setPreferredSize(new Dimension(450, 150));
        this.setLayout(new BorderLayout());
        this.tlbToolBar.setLayout(new FlowLayout(0, 0, 2));
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/filesave.png")));
        this.btnSave.setToolTipText(this.getBundleString("save"));
        this.btnSave.addActionListener(this::btnSaveActionPerformed);
        this.btnSave.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnSave);
        this.btnEmail.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/email.png")));
        this.btnEmail.setToolTipText("Email");
        this.btnEmail.addActionListener(this::a);
        this.btnEmail.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnEmail);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/fileprint.png")));
        this.btnPrint.setToolTipText(this.getBundleString("print"));
        this.btnPrint.addActionListener(this::btnPrintActionPerformed);
        this.btnPrint.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnPrint);
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/reload.png")));
        this.btnReload.setToolTipText(this.getBundleString("reload"));
        this.btnReload.addActionListener(this::btnReloadActionPerformed);
        this.btnReload.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.btnFirst.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/2leftarrow.png")));
        this.btnFirst.setToolTipText(this.getBundleString("first.page"));
        this.btnFirst.addActionListener(this::btnFirstActionPerformed);
        this.btnFirst.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnFirst);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/1leftarrow.png")));
        this.btnPrevious.setToolTipText(this.getBundleString("previous.page"));
        this.btnPrevious.addActionListener(this::btnPreviousActionPerformed);
        this.btnPrevious.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnPrevious);
        this.txtGoTo.setMaximumSize(new Dimension(40, 30));
        this.txtGoTo.setMinimumSize(new Dimension(40, 30));
        this.txtGoTo.setPreferredSize(new Dimension(40, 30));
        this.txtGoTo.setToolTipText(this.getBundleString("go.to.page"));
        this.txtGoTo.addActionListener(this::txtGoToActionPerformed);
        this.txtGoTo.addKeyListener(this.keyNavigationListener);
        this.txtGoTo.setHorizontalAlignment(0);
        this.tlbToolBar.add(this.txtGoTo);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/1rightarrow.png")));
        this.btnNext.setToolTipText(this.getBundleString("next.page"));
        this.btnNext.addActionListener(this::btnNextActionPerformed);
        this.btnNext.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnNext);
        this.btnLast.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/2rightarrow.png")));
        this.btnLast.setToolTipText(this.getBundleString("last.page"));
        this.btnLast.addActionListener(this::btnLastActionPerformed);
        this.btnLast.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnLast);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnActualSize.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/mime.png")));
        this.btnActualSize.setToolTipText(this.getBundleString("actual.size"));
        this.btnActualSize.addActionListener(this::btnActualSizeActionPerformed);
        this.btnActualSize.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnActualSize);
        this.btnFitPage.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/mime2.png")));
        this.btnFitPage.setToolTipText(this.getBundleString("fit.page"));
        this.btnFitPage.addActionListener(this::btnFitPageActionPerformed);
        this.btnFitPage.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnFitPage);
        this.btnFitWidth.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/mime3.png")));
        this.btnFitWidth.setToolTipText(this.getBundleString("fit.width"));
        this.btnFitWidth.addActionListener(this::btnFitWidthActionPerformed);
        this.btnFitWidth.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnFitWidth);
        this.pnlSep03.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep03);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/viewmag+.png")));
        this.btnZoomIn.setToolTipText(this.getBundleString("zoom.in"));
        this.btnZoomIn.addActionListener(this::btnZoomInActionPerformed);
        this.btnZoomIn.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/viewmag-.png")));
        this.btnZoomOut.setToolTipText(this.getBundleString("zoom.out"));
        this.btnZoomOut.addActionListener(this::btnZoomOutActionPerformed);
        this.btnZoomOut.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setEditable(true);
        this.cmbZoom.setToolTipText(this.getBundleString("zoom.ratio"));
        this.cmbZoom.addActionListener(this::cmbZoomActionPerformed);
        this.cmbZoom.addItemListener(itemEvent -> this.cmbZoomItemStateChanged(itemEvent));
        this.cmbZoom.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.cmbZoom);
        JRViewer jRViewer2 = this;
        jRViewer2.add((Component)jRViewer2.tlbToolBar, "North");
        this.pnlMain.addComponentListener(new m(this));
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlTabs.addChangeListener(serializable -> {
            serializable = this;
            if (((JRViewer)serializable).pnlTabsChangeListenerEnabled) {
                PrintParts printParts;
                ((JPanel)((JRViewer)serializable).pnlTabs.getSelectedComponent()).add(((JRViewer)serializable).scrollPane);
                Integer n2 = 0;
                Integer n3 = ((JRViewer)serializable).pnlTabs.getSelectedIndex();
                if (n3 > 0 && (printParts = ((JRViewer)serializable).jasperPrint == null ? null : ((JRViewer)serializable).jasperPrint.getParts()) != null && printParts.hasParts()) {
                    n3 = printParts.startsAtZero() ? n3 : n3 - 1;
                    n2 = printParts.getStartPageIndex(n3.intValue());
                }
                super.a(n2);
                ((JRViewer)((Object)serializable)).refreshPage();
            }
        });
        this.pnlMain.add((Component)this.pnlTabs, "Center");
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.pnlPage.setLayout(new BorderLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.jPanel4.setLayout(new GridBagLayout());
        this.pnlLinks.setMinimumSize(new Dimension(5, 5));
        this.pnlLinks.setOpaque(false);
        this.pnlLinks.setPreferredSize(new Dimension(5, 5));
        this.pnlLinks.addMouseListener(new n(this));
        this.pnlLinks.addMouseMotionListener(new o(this));
        this.pnlLinks.setLayout(null);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridwidth = 2;
        object.gridheight = 2;
        object.fill = 1;
        this.jPanel4.add((Component)this.pnlLinks, object);
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        object.gridy = 1;
        object.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, object);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, object);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 2;
        object.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, object);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        object.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, object);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        object.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, object);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridwidth = 2;
        object.gridheight = 2;
        object.fill = 1;
        object.weightx = 1.0;
        object.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, object);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        object = new GridBagConstraints();
        new GridBagConstraints().insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, object);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        JRViewer jRViewer3 = this;
        jRViewer3.add((Component)jRViewer3.pnlMain, "Center");
        this.pnlStatus.setLayout(new FlowLayout(1, 0, 0));
        this.lblStatus.setFont(new Font("Dialog", 1, 10));
        this.lblStatus.setText("Page i of n");
        this.pnlStatus.add(this.lblStatus);
        JRViewer jRViewer4 = this;
        jRViewer4.add((Component)jRViewer4.pnlStatus, "South");
        JRViewer jRViewer5 = this;
        jRViewer5.addKeyListener(jRViewer5.keyNavigationListener);
    }

    void txtGoToActionPerformed(ActionEvent actionEvent) {
        try {
            int n2 = Integer.parseInt(this.txtGoTo.getText());
            if (n2 != this.pageIndex + 1 && n2 > 0 && n2 <= this.jasperPrint.getPages().size()) {
                this.a(n2 - 1);
                this.refreshPage();
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    void cmbZoomItemStateChanged(ItemEvent itemEvent) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
    }

    void pnlMainComponentResized(ComponentEvent componentEvent) {
        if (this.btnFitPage.isSelected()) {
            this.e();
            this.btnFitPage.setSelected(true);
            return;
        }
        if (this.btnFitWidth.isSelected()) {
            JRViewer jRViewer = this;
            jRViewer.a(((float)jRViewer.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.c().getPageWidth().intValue());
            this.btnFitWidth.setSelected(true);
        }
    }

    void btnActualSizeActionPerformed(ActionEvent actionEvent) {
        if (this.btnActualSize.isSelected()) {
            this.btnFitPage.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.setZoomRatio(1.0f);
            this.btnActualSize.setSelected(true);
        }
    }

    void btnFitWidthActionPerformed(ActionEvent actionEvent) {
        if (this.btnFitWidth.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitPage.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            JRViewer jRViewer = this;
            jRViewer.a(((float)jRViewer.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.c().getPageWidth().intValue());
            this.btnFitWidth.setSelected(true);
        }
    }

    void btnFitPageActionPerformed(ActionEvent actionEvent) {
        if (this.btnFitPage.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.e();
            this.btnFitPage.setSelected(true);
        }
    }

    void btnSaveActionPerformed(ActionEvent object) {
        if (this.jasperPrint == null) {
            return;
        }
        object = JRViewer.a(this, "Save");
        if (object == null) {
            return;
        }
        Serializable serializable = new JFileChooser(this.lastFolder);
        ((JFileChooser)serializable).setAcceptAllFileFilterUsed(true);
        ((JFileChooser)serializable).setSelectedFile(new File((this.jasperPrint.getName() != null ? this.jasperPrint.getName() : "Report") + "." + ((ExportFormat)((Object)object)).ext));
        if (this.lastFolder != null) {
            ((JFileChooser)serializable).setCurrentDirectory(this.lastFolder);
        } else {
            try {
                String string = StringUtils.config.getProperty("Usb.Location");
                ((JFileChooser)serializable).setCurrentDirectory(new File(string));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.getParent(), "Cannot mount Flash Drive:" + exception, "Saleculator Reports", 0);
            }
        }
        if (!FlashDrive.MountFlashDrive(this.getParent())) {
            return;
        }
        int n2 = ((JFileChooser)serializable).showSaveDialog(this);
        if (n2 != 0) {
            return;
        }
        String string = ((ExportFormat)((Object)object)).ext;
        String string2 = ((File)(serializable = ((JFileChooser)serializable).getSelectedFile())).getName().toLowerCase(Locale.ROOT);
        if (!string2.endsWith("." + string)) {
            serializable = new File(((File)serializable).getParentFile(), ((File)serializable).getName() + "." + string);
        }
        this.lastFolder = ((File)serializable).getParentFile();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.btnSave.setEnabled(false);
        new Thread(() -> this.b((File)serializable, (ExportFormat)((Object)object))).start();
    }

    private void a(ActionEvent object) {
        object = new MessageEmail();
        if (!this.isOnline) {
            JOptionPane.showMessageDialog(this, "Internet connection not available!");
            return;
        }
        if (!((MessageEmail)object).isEnabled()) {
            JOptionPane.showMessageDialog(this, "Email settings not configured!");
            return;
        }
        if (this.jasperPrint == null) {
            return;
        }
        ExportFormat exportFormat = JRViewer.a(this, "Email");
        if (exportFormat == null) {
            return;
        }
        File file = new File(System.getProperty("java.io.tmpdir"), "SaleculatorReport." + exportFormat.ext);
        if (file.exists()) {
            file.delete();
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.btnEmail.setEnabled(false);
        new Thread(() -> this.a(file, exportFormat, (MessageEmail)object)).start();
    }

    void pnlLinksMouseDragged(MouseEvent mouseEvent) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            container = (JViewport)container;
            Point point = ((JViewport)container).getViewPosition();
            int n2 = point.x - (mouseEvent.getX() - this.downX);
            int n3 = point.y - (mouseEvent.getY() - this.downY);
            int n4 = this.pnlInScroll.getWidth() - ((JComponent)container).getWidth();
            int n5 = this.pnlInScroll.getHeight() - ((JComponent)container).getHeight();
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > n5) {
                n3 = n5;
            }
            ((JViewport)container).setViewPosition(new Point(n2, n3));
        }
    }

    void pnlLinksMouseReleased(MouseEvent mouseEvent) {
        this.pnlLinks.setCursor(new Cursor(0));
    }

    void pnlLinksMousePressed(MouseEvent mouseEvent) {
        this.pnlLinks.setCursor(new Cursor(13));
        this.downX = mouseEvent.getX();
        this.downY = mouseEvent.getY();
    }

    void btnPrintActionPerformed(ActionEvent object) {
        object = new Thread(() -> {
            try {
                this.btnPrint.setEnabled(false);
                this.setCursor(Cursor.getPredefinedCursor(3));
                JasperPrintManager.getInstance((JasperReportsContext)this.jasperReportsContext).print(this.jasperPrint, true);
                return;
            }
            catch (Exception exception) {
                if (a.isErrorEnabled()) {
                    a.error((Object)"Print error.", (Throwable)exception);
                }
                JRViewer jRViewer = this;
                JOptionPane.showMessageDialog(jRViewer, jRViewer.getBundleString("error.printing"));
                return;
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.btnPrint.setEnabled(true);
            }
        });
        ((Thread)object).start();
    }

    void btnLastActionPerformed(ActionEvent actionEvent) {
        JRViewer jRViewer = this;
        jRViewer.a(jRViewer.jasperPrint.getPages().size() - 1);
        this.refreshPage();
    }

    void btnNextActionPerformed(ActionEvent actionEvent) {
        JRViewer jRViewer = this;
        jRViewer.a(jRViewer.pageIndex + 1);
        this.refreshPage();
    }

    void btnPreviousActionPerformed(ActionEvent actionEvent) {
        JRViewer jRViewer = this;
        jRViewer.a(jRViewer.pageIndex - 1);
        this.refreshPage();
    }

    void btnFirstActionPerformed(ActionEvent actionEvent) {
        this.a(0);
        this.refreshPage();
    }

    void btnReloadActionPerformed(ActionEvent actionEvent) {
        if (this.type == 1) {
            try {
                JRViewer jRViewer = this;
                jRViewer.loadReport(jRViewer.reportFileName, this.isXML);
            }
            catch (JRException jRException) {
                if (a.isErrorEnabled()) {
                    a.error((Object)"Reload error.", (Throwable)jRException);
                }
                this.jasperPrint = null;
                this.refreshTabs();
                this.a(0);
                this.refreshPage();
                JRViewer jRViewer = this;
                JOptionPane.showMessageDialog(jRViewer, jRViewer.getBundleString("error.loading"));
            }
            this.forceRefresh();
        }
    }

    protected void forceRefresh() {
        this.zoom = 0.0f;
        this.realZoom = 0.0f;
        this.setZoomRatio(1.0f);
    }

    void btnZoomInActionPerformed(ActionEvent actionEvent) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int n2 = (int)(100.0f * this.d());
        n2 = Arrays.binarySearch(this.zooms, n2);
        if (n2 < 0) {
            JRViewer jRViewer = this;
            jRViewer.setZoomRatio((float)jRViewer.zooms[-n2 - 1] / 100.0f);
            return;
        }
        if (n2 < this.cmbZoom.getModel().getSize() - 1) {
            JRViewer jRViewer = this;
            jRViewer.setZoomRatio((float)jRViewer.zooms[n2 + 1] / 100.0f);
        }
    }

    void btnZoomOutActionPerformed(ActionEvent actionEvent) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int n2 = (int)(100.0f * this.d());
        n2 = Arrays.binarySearch(this.zooms, n2);
        if (n2 > 0) {
            JRViewer jRViewer = this;
            jRViewer.setZoomRatio((float)jRViewer.zooms[n2 - 1] / 100.0f);
            return;
        }
        if (n2 < -1) {
            JRViewer jRViewer = this;
            jRViewer.setZoomRatio((float)jRViewer.zooms[-n2 - 2] / 100.0f);
        }
    }

    void cmbZoomActionPerformed(ActionEvent actionEvent) {
        float f2;
        float f3 = this.d();
        if (f2 < 0.5f) {
            f3 = 0.5f;
        }
        if (f3 > 10.0f) {
            f3 = 10.0f;
        }
        this.setZoomRatio(f3);
    }

    void hyperlinkClicked(MouseEvent serializable) {
        serializable = (JPanel)serializable.getSource();
        serializable = this.linksMap.get(serializable);
        this.hyperlinkClicked((JRPrintHyperlink)serializable);
    }

    protected void hyperlinkClicked(JRPrintHyperlink jRPrintHyperlink) {
        try {
            for (int i2 = 0; i2 < this.hyperlinkListeners.size(); ++i2) {
                this.hyperlinkListeners.get(i2).gotoHyperlink(jRPrintHyperlink);
            }
            return;
        }
        catch (JRException jRException) {
            if (a.isErrorEnabled()) {
                a.error((Object)"Hyperlink click error.", (Throwable)jRException);
            }
            JRViewer jRViewer = this;
            JOptionPane.showMessageDialog(jRViewer, jRViewer.getBundleString("error.hyperlink"));
            return;
        }
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    private void a(int n2) {
        if (this.jasperPrint != null && this.jasperPrint.getPages() != null && this.jasperPrint.getPages().size() > 0) {
            if (n2 >= 0 && n2 < this.jasperPrint.getPages().size()) {
                this.pageIndex = n2;
                this.pageError = false;
                this.btnFirst.setEnabled(this.pageIndex > 0);
                this.btnPrevious.setEnabled(this.pageIndex > 0);
                this.btnNext.setEnabled(this.pageIndex < this.jasperPrint.getPages().size() - 1);
                this.btnLast.setEnabled(this.pageIndex < this.jasperPrint.getPages().size() - 1);
                this.txtGoTo.setEnabled(this.btnFirst.isEnabled() || this.btnLast.isEnabled());
                this.txtGoTo.setText("" + (this.pageIndex + 1));
                this.lblStatus.setText(MessageFormat.format(this.getBundleString("page"), this.pageIndex + 1, this.jasperPrint.getPages().size()));
                if (this.jasperPrint.hasParts()) {
                    PrintParts printParts = this.jasperPrint.getParts();
                    int n3 = printParts.getPartIndex(this.pageIndex);
                    int n4 = n3 - (printParts.startsAtZero() ? 1 : 0);
                    if (n4 < this.pnlTabs.getComponentCount()) {
                        this.pnlTabsChangeListenerEnabled = false;
                        this.pnlTabs.setSelectedIndex(n4);
                        ((JPanel)this.pnlTabs.getSelectedComponent()).add(this.scrollPane);
                        this.pnlTabsChangeListenerEnabled = true;
                    }
                    return;
                }
            }
        } else {
            this.btnFirst.setEnabled(false);
            this.btnPrevious.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.txtGoTo.setEnabled(false);
            this.txtGoTo.setText("");
            this.lblStatus.setText("");
        }
    }

    private PrintPageFormat c() {
        return this.jasperPrint.getPageFormat(this.pageIndex);
    }

    protected void loadReport(String string, boolean bl2) {
        this.jasperPrint = bl2 ? JRPrintXmlLoader.loadFromFile((JasperReportsContext)this.jasperReportsContext, (String)string) : (JasperPrint)JRLoader.loadObjectFromFile((String)string);
        this.refreshTabs();
        this.type = 1;
        this.isXML = bl2;
        this.reportFileName = string;
        string = new SimpleFileResolver(Arrays.asList(new File(string).getParentFile(), new File(".")));
        string.setResolveAbsolutePath(true);
        if (this.localJasperReportsContext == null) {
            this.localJasperReportsContext = new LocalJasperReportsContext(this.jasperReportsContext);
            this.jasperReportsContext = this.localJasperReportsContext;
        }
        this.localJasperReportsContext.setFileResolver((FileResolver)string);
        this.btnReload.setEnabled(true);
        this.a(0);
    }

    protected void loadReport(InputStream inputStream, boolean bl2) {
        this.jasperPrint = bl2 ? JRPrintXmlLoader.load((JasperReportsContext)this.jasperReportsContext, (InputStream)inputStream) : (JasperPrint)JRLoader.loadObject((InputStream)inputStream);
        this.refreshTabs();
        this.type = 2;
        this.isXML = bl2;
        this.btnReload.setEnabled(false);
        this.a(0);
    }

    protected void loadReport(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
        this.refreshTabs();
        this.type = 3;
        this.isXML = false;
        this.btnReload.setEnabled(false);
        this.a(0);
    }

    protected void refreshTabs() {
        this.pnlTabsChangeListenerEnabled = false;
        this.pnlTabs.removeAll();
        this.pnlMain.removeAll();
        if (this.jasperPrint == null || !this.jasperPrint.hasParts()) {
            this.pnlMain.add((Component)this.scrollPane, "Center");
        } else {
            Object object;
            PrintParts printParts = this.jasperPrint.getParts();
            if (!printParts.startsAtZero()) {
                object = new JPanel();
                ((Container)object).setLayout(new BorderLayout());
                ((Component)object).setName(this.jasperPrint.getName());
                this.pnlTabs.add((Component)object);
            }
            object = printParts.partsIterator();
            while (object.hasNext()) {
                printParts = (PrintPart)((Map.Entry)object.next()).getValue();
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.setName(printParts.getName());
                this.pnlTabs.add(jPanel);
            }
            this.pnlMain.add((Component)this.pnlTabs, "Center");
        }
        this.pnlTabsChangeListenerEnabled = true;
    }

    protected void refreshPage() {
        long l2;
        if (this.jasperPrint == null || this.jasperPrint.getPages() == null || this.jasperPrint.getPages().size() == 0) {
            this.pnlPage.setVisible(false);
            this.btnSave.setEnabled(false);
            this.btnEmail.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnActualSize.setEnabled(false);
            this.btnFitPage.setEnabled(false);
            this.btnFitWidth.setEnabled(false);
            this.btnZoomIn.setEnabled(false);
            this.btnZoomOut.setEnabled(false);
            this.cmbZoom.setEnabled(false);
            if (this.jasperPrint != null) {
                JRViewer jRViewer = this;
                JOptionPane.showMessageDialog(jRViewer, jRViewer.getBundleString("no.pages"));
            }
            return;
        }
        this.pnlPage.setVisible(true);
        this.btnSave.setEnabled(true);
        if (this.isOnline) {
            this.btnEmail.setEnabled(true);
        }
        this.btnPrint.setEnabled(true);
        this.btnActualSize.setEnabled(true);
        this.btnFitPage.setEnabled(true);
        this.btnFitWidth.setEnabled(true);
        this.btnZoomIn.setEnabled(this.zoom < 10.0f);
        this.btnZoomOut.setEnabled(this.zoom > 0.5f);
        this.cmbZoom.setEnabled(true);
        PrintPageFormat printPageFormat = this.c();
        Dimension dimension = new Dimension((int)((float)printPageFormat.getPageWidth().intValue() * this.realZoom) + 8, (int)((float)printPageFormat.getPageHeight().intValue() * this.realZoom) + 8);
        this.pnlPage.setMaximumSize(dimension);
        this.pnlPage.setMinimumSize(dimension);
        this.pnlPage.setPreferredSize(dimension);
        long l3 = JRPropertiesUtil.getInstance((JasperReportsContext)this.jasperReportsContext).getLongProperty(VIEWER_RENDER_BUFFER_MAX_SIZE);
        boolean bl2 = l3 > 0L && (l2 = (long)(((int)((float)printPageFormat.getPageWidth().intValue() * this.realZoom) + 1) * ((int)((float)printPageFormat.getPageHeight().intValue() * this.realZoom) + 1))) <= l3;
        ((PageRenderer)this.lblPage).setRenderImage(bl2);
        if (bl2) {
            this.setPageImage();
        }
        this.pnlLinks.removeAll();
        this.linksMap = new HashMap<JPanel, JRPrintHyperlink>();
        this.createHyperlinks();
        if (!bl2) {
            this.lblPage.setIcon(null);
            this.pnlMain.validate();
            this.pnlMain.repaint();
        }
    }

    protected void setPageImage() {
        Object object;
        if (this.pageError) {
            object = this.getPageErrorImage();
        } else {
            try {
                object = JasperPrintManager.getInstance((JasperReportsContext)this.jasperReportsContext).printToImage(this.jasperPrint, this.pageIndex, this.realZoom);
            }
            catch (Exception exception) {
                if (a.isErrorEnabled()) {
                    a.error((Object)"Print page to image error.", (Throwable)exception);
                }
                this.pageError = true;
                object = this.getPageErrorImage();
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("error.displaying"));
            }
        }
        object = new ImageIcon((Image)object);
        this.lblPage.setIcon((Icon)object);
    }

    protected Image getPageErrorImage() {
        Object object = this.c();
        object = new BufferedImage((int)((float)object.getPageWidth().intValue() * this.realZoom) + 1, (int)((float)object.getPageHeight().intValue() * this.realZoom) + 1, 1);
        Graphics2D graphics2D = (Graphics2D)object.getGraphics();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(this.realZoom, this.realZoom);
        graphics2D.transform(affineTransform);
        this.drawPageError(graphics2D);
        return object;
    }

    protected void createHyperlinks() {
        List list = this.jasperPrint.getPages();
        list = (JRPrintPage)list.get(this.pageIndex);
        this.createHyperlinks(list.getElements(), 0, 0);
    }

    protected void createHyperlinks(List<JRPrintElement> object, int n2, int n3) {
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                int n4;
                Renderable renderable;
                JRPrintElement jRPrintElement = (JRPrintElement)object.next();
                Object object2 = null;
                if (jRPrintElement instanceof JRPrintImage && (renderable = ((JRPrintImage)jRPrintElement).getRenderable()) instanceof ImageMapRenderable && !(object2 = (ImageMapRenderable)renderable).hasImageAreaHyperlinks()) {
                    object2 = null;
                }
                boolean bl2 = object2 != null;
                JRPrintHyperlink jRPrintHyperlink = null;
                if (jRPrintElement instanceof JRPrintHyperlink) {
                    jRPrintHyperlink = (JRPrintHyperlink)jRPrintElement;
                }
                boolean bl3 = !bl2 && jRPrintHyperlink != null && jRPrintHyperlink.getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE;
                int n5 = n4 = jRPrintHyperlink != null && jRPrintHyperlink.getHyperlinkTooltip() != null ? 1 : 0;
                if (bl3 || bl2 || n4 != 0) {
                    if (bl2) {
                        Rectangle rectangle = new Rectangle(0, 0, jRPrintElement.getWidth(), jRPrintElement.getHeight());
                        object2 = new ImageMapPanel(rectangle, (ImageMapRenderable)object2);
                    } else {
                        object2 = new JPanel();
                        if (bl3) {
                            ((Component)object2).addMouseListener(this.mouseListener);
                        }
                    }
                    if (bl3) {
                        ((Component)object2).setCursor(new Cursor(12));
                    }
                    ((Component)object2).setLocation((int)((float)(jRPrintElement.getX() + n2) * this.realZoom), (int)((float)(jRPrintElement.getY() + n3) * this.realZoom));
                    ((Component)object2).setSize((int)((float)jRPrintElement.getWidth() * this.realZoom), (int)((float)jRPrintElement.getHeight() * this.realZoom));
                    ((JComponent)object2).setOpaque(false);
                    String string = this.getHyperlinkTooltip(jRPrintHyperlink);
                    if (string == null && bl2) {
                        string = "";
                    }
                    ((JComponent)object2).setToolTipText(string);
                    this.pnlLinks.add((Component)object2);
                    this.linksMap.put((JPanel)object2, jRPrintHyperlink);
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                object2 = (JRPrintFrame)jRPrintElement;
                n4 = n2 + object2.getX() + object2.getLineBox().getLeftPadding();
                int n6 = n3 + object2.getY() + object2.getLineBox().getTopPadding();
                this.createHyperlinks(object2.getElements(), n4, n6);
            }
        }
    }

    protected String getHyperlinkTooltip(JRPrintHyperlink jRPrintHyperlink) {
        String string = jRPrintHyperlink == null ? null : jRPrintHyperlink.getHyperlinkTooltip();
        if (string == null) {
            string = this.getFallbackTooltip(jRPrintHyperlink);
        }
        return string;
    }

    protected String getFallbackTooltip(JRPrintHyperlink jRPrintHyperlink) {
        if (jRPrintHyperlink == null) {
            return null;
        }
        String string = null;
        switch (jRPrintHyperlink.getHyperlinkTypeValue()) {
            case REFERENCE: {
                string = jRPrintHyperlink.getHyperlinkReference();
                break;
            }
            case LOCAL_ANCHOR: {
                if (jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                string = "#" + jRPrintHyperlink.getHyperlinkAnchor();
                break;
            }
            case LOCAL_PAGE: {
                if (jRPrintHyperlink.getHyperlinkPage() == null) break;
                string = "#page " + jRPrintHyperlink.getHyperlinkPage();
                break;
            }
            case REMOTE_ANCHOR: {
                string = "";
                if (jRPrintHyperlink.getHyperlinkReference() != null) {
                    string = string + jRPrintHyperlink.getHyperlinkReference();
                }
                if (jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                string = string + "#" + jRPrintHyperlink.getHyperlinkAnchor();
                break;
            }
            case REMOTE_PAGE: {
                string = "";
                if (jRPrintHyperlink.getHyperlinkReference() != null) {
                    string = string + jRPrintHyperlink.getHyperlinkReference();
                }
                if (jRPrintHyperlink.getHyperlinkPage() == null) break;
                string = string + "#page " + jRPrintHyperlink.getHyperlinkPage();
            }
        }
        return string;
    }

    private void a(Container container) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            for (Component component : componentArray) {
                if (!(component instanceof Container)) continue;
                this.a((Container)component);
            }
        }
        container.removeAll();
    }

    private float d() {
        float f2 = this.zoom;
        try {
            f2 = this.zoomDecimalFormat.parse(String.valueOf(this.cmbZoom.getEditor().getItem())).floatValue() / 100.0f;
        }
        catch (ParseException parseException) {}
        return f2;
    }

    public void setZoomRatio(float f2) {
        if (f2 > 0.0f) {
            this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(f2 * 100.0f) + "%");
            if (this.zoom != f2) {
                this.zoom = f2;
                this.realZoom = this.zoom * (float)this.screenResolution / 72.0f;
                this.refreshPage();
            }
        }
    }

    private void a(float f2) {
        if (f2 > 0.0f && this.realZoom != f2) {
            this.zoom = f2 * 72.0f / (float)this.screenResolution;
            this.realZoom = f2;
            this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(this.zoom * 100.0f) + "%");
            this.refreshPage();
        }
    }

    public void setFitWidthZoomRatio() {
        JRViewer jRViewer = this;
        jRViewer.a(((float)jRViewer.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.c().getPageWidth().intValue());
    }

    public void setFitPageZoomRatio() {
        JRViewer jRViewer = this;
        jRViewer.a(((float)jRViewer.pnlInScroll.getVisibleRect().getHeight() - 20.0f) / (float)this.c().getPageHeight().intValue());
    }

    protected JRGraphics2DExporter getGraphics2DExporter() {
        return new JRGraphics2DExporter(this.jasperReportsContext);
    }

    protected void paintPage(Graphics2D graphics2D) {
        if (this.pageError) {
            this.paintPageError(graphics2D);
            return;
        }
        try {
            if (this.exporter == null) {
                this.exporter = this.getGraphics2DExporter();
            } else {
                this.exporter.reset();
            }
            this.exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
            SimpleGraphics2DExporterOutput simpleGraphics2DExporterOutput = new SimpleGraphics2DExporterOutput();
            simpleGraphics2DExporterOutput.setGraphics2D((Graphics2D)graphics2D.create());
            this.exporter.setExporterOutput((ExporterOutput)simpleGraphics2DExporterOutput);
            simpleGraphics2DExporterOutput = new SimpleGraphics2DReportConfiguration();
            simpleGraphics2DExporterOutput.setPageIndex(Integer.valueOf(this.pageIndex));
            simpleGraphics2DExporterOutput.setZoomRatio(Float.valueOf(this.realZoom));
            simpleGraphics2DExporterOutput.setOffsetX(Integer.valueOf(1));
            simpleGraphics2DExporterOutput.setOffsetY(Integer.valueOf(1));
            this.exporter.setConfiguration((ReportExportConfiguration)simpleGraphics2DExporterOutput);
            this.exporter.exportReport();
            return;
        }
        catch (Exception exception) {
            if (a.isErrorEnabled()) {
                a.error((Object)"Page paint error.", (Throwable)exception);
            }
            this.pageError = true;
            this.paintPageError(graphics2D);
            SwingUtilities.invokeLater(() -> {
                JRViewer jRViewer = this;
                JOptionPane.showMessageDialog(jRViewer, jRViewer.getBundleString("error.displaying"));
            });
            return;
        }
    }

    protected void paintPageError(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(1.0, 1.0);
        affineTransform2.scale(this.realZoom, this.realZoom);
        graphics2D.transform(affineTransform2);
        try {
            this.drawPageError(graphics2D);
            return;
        }
        finally {
            graphics2D.setTransform(affineTransform);
        }
    }

    protected void drawPageError(Graphics graphics) {
        PrintPageFormat printPageFormat = this.c();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, printPageFormat.getPageWidth() + 1, printPageFormat.getPageHeight() + 1);
    }

    protected void keyNavigate(KeyEvent serializable) {
        boolean bl2 = true;
        switch (((KeyEvent)serializable).getKeyCode()) {
            case 34: 
            case 40: {
                KeyEvent keyEvent = serializable;
                serializable = this;
                int n2 = ((JRViewer)serializable).scrollPane.getVerticalScrollBar().getValue();
                ((JRViewer)serializable).scrollPane.dispatchEvent(keyEvent);
                if (((JRViewer)serializable).scrollPane.getViewport().getHeight() <= ((JRViewer)serializable).pnlPage.getHeight() && ((JRViewer)serializable).scrollPane.getVerticalScrollBar().getValue() != n2 || ((JRViewer)serializable).pageIndex >= ((JRViewer)serializable).jasperPrint.getPages().size() - 1) break;
                Serializable serializable2 = serializable;
                super.a(((JRViewer)serializable2).pageIndex + 1);
                if (!((JRViewer)serializable).scrollPane.isEnabled()) break;
                ((JRViewer)serializable).scrollPane.getVerticalScrollBar().setValue(0);
                break;
            }
            case 33: 
            case 38: {
                KeyEvent keyEvent = serializable;
                serializable = this;
                if ((((JRViewer)serializable).scrollPane.getViewport().getHeight() > ((JRViewer)serializable).pnlPage.getHeight() || ((JRViewer)serializable).scrollPane.getVerticalScrollBar().getValue() == 0) && ((JRViewer)serializable).pageIndex > 0) {
                    Serializable serializable3 = serializable;
                    super.a(((JRViewer)serializable3).pageIndex - 1);
                    if (!((JRViewer)serializable).scrollPane.isEnabled()) break;
                    ((JRViewer)serializable).scrollPane.getVerticalScrollBar().setValue(((JRViewer)serializable).scrollPane.getVerticalScrollBar().getMaximum());
                    break;
                }
                ((JRViewer)serializable).scrollPane.dispatchEvent(keyEvent);
                break;
            }
            case 36: {
                this.b(0);
                break;
            }
            case 35: {
                JRViewer jRViewer = this;
                jRViewer.b(jRViewer.jasperPrint.getPages().size() - 1);
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (bl2) {
            this.refreshPage();
        }
    }

    private void b(int n2) {
        this.a(n2);
        if (this.scrollPane.isEnabled()) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    private void e() {
        PrintPageFormat printPageFormat = this.c();
        float f2 = ((float)this.pnlInScroll.getVisibleRect().getHeight() - 20.0f) / (float)printPageFormat.getPageHeight().intValue();
        float f3 = ((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)printPageFormat.getPageWidth().intValue();
        this.a(Math.min(f2, f3));
    }

    private static ExportFormat a(Component component, String string) {
        ExportFormat[] exportFormatArray = new ExportFormat[]{ExportFormat.PDF, ExportFormat.XLSX, ExportFormat.CSV};
        return (ExportFormat)((Object)JOptionPane.showInputDialog(component, "Choose a format", string, 3, null, (Object[])exportFormatArray, (Object)exportFormatArray[0]));
    }

    private void a(File file, ExportFormat exportFormat) {
        switch (exportFormat) {
            case PDF: {
                exportFormat = new JRPdfExporter(this.getJasperReportsContext());
                exportFormat.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
                exportFormat.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
                exportFormat.exportReport();
                return;
            }
            case XLSX: {
                exportFormat = new JRXlsxExporter(this.getJasperReportsContext());
                exportFormat.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
                exportFormat.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
                file = new SimpleXlsxReportConfiguration();
                file.setDetectCellType(Boolean.TRUE);
                file.setOnePagePerSheet(Boolean.FALSE);
                file.setWhitePageBackground(Boolean.FALSE);
                file.setIgnorePageMargins(Boolean.TRUE);
                file.setIgnoreGraphics(Boolean.TRUE);
                file.setIgnoreCellBackground(Boolean.TRUE);
                file.setIgnoreCellBorder(Boolean.TRUE);
                file.setRemoveEmptySpaceBetweenRows(Boolean.TRUE);
                file.setRemoveEmptySpaceBetweenColumns(Boolean.TRUE);
                file.setCollapseRowSpan(Boolean.TRUE);
                file.setShowGridLines(Boolean.TRUE);
                exportFormat.setConfiguration((ReportExportConfiguration)file);
                exportFormat.exportReport();
                return;
            }
            case CSV: {
                exportFormat = new JRCsvExporter(this.getJasperReportsContext());
                exportFormat.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
                exportFormat.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(file, StandardCharsets.UTF_8.name()));
                file = new SimpleCsvExporterConfiguration();
                exportFormat.setConfiguration((ExporterConfiguration)file);
                exportFormat.exportReport();
            }
        }
    }

    private /* synthetic */ void a(File file, ExportFormat exportFormat, MessageEmail messageEmail) {
        try {
            this.a(file, exportFormat);
            String string = "Dear Customer,\r\n\r\nWe are happy to offer you the facility of receiving reports on email. Now, you can access your reports from anywhere in the world.\r\n\r\nThank you,\r\nSaleculator Online Services\r\nwww.saleculator.com";
            MessageEmail messageEmail2 = messageEmail;
            messageEmail2.SendMailwithAttachment(messageEmail2.getEmailTo(), "Saleculator Report", string, file, "SaleculatorReport." + exportFormat.ext);
            SwingUtilities.invokeLater(() -> {
                MessageInf messageInf = new MessageInf(-83886080, "Email sent.");
                messageInf.show(this);
            });
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            SwingUtilities.invokeLater(() -> {
                JRViewer jRViewer = this;
                JOptionPane.showMessageDialog(jRViewer, jRViewer.getBundleString("error.saving"));
            });
            return;
        }
        finally {
            SwingUtilities.invokeLater(() -> {
                this.setCursor(Cursor.getDefaultCursor());
                this.btnEmail.setEnabled(true);
            });
        }
    }

    private /* synthetic */ void b(File serializable, ExportFormat exportFormat) {
        try {
            this.a((File)serializable, exportFormat);
            SwingUtilities.invokeLater(() -> {
                MessageInf messageInf = new MessageInf(-83886080, "Report saved.");
                messageInf.show(this);
            });
            return;
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
            SwingUtilities.invokeLater(() -> {
                JRViewer jRViewer = this;
                JOptionPane.showMessageDialog(jRViewer, jRViewer.getBundleString("error.saving"));
            });
            return;
        }
        finally {
            SwingUtilities.invokeLater(() -> {
                this.setCursor(Cursor.getDefaultCursor());
                this.btnSave.setEnabled(true);
            });
        }
    }

    static {
        try {
            JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).setProperty("net.sf.jasperreports.compiler.class", "net.sf.jasperreports.engine.design.JRJdtCompiler");
            JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).setProperty("net.sf.jasperreports.export.pdf.classic.mode", "false");
        }
        catch (Throwable throwable) {}
    }

    class PageRenderer
    extends JLabel {
        private static final long serialVersionUID = 10200L;
        private boolean renderImage;
        JRViewer viewer = null;

        public PageRenderer(JRViewer jRViewer2) {
            this.viewer = jRViewer2;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.isRenderImage()) {
                super.paintComponent(graphics);
                return;
            }
            this.viewer.paintPage((Graphics2D)graphics.create());
        }

        public boolean isRenderImage() {
            return this.renderImage;
        }

        public void setRenderImage(boolean bl2) {
            this.renderImage = bl2;
        }
    }

    protected class ImageMapPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 10200L;
        protected final List<JRPrintImageAreaHyperlink> imageAreaHyperlinks;

        public ImageMapPanel(Rectangle rectangle, ImageMapRenderable imageMapRenderable) {
            try {
                this.imageAreaHyperlinks = imageMapRenderable.getImageAreaHyperlinks((Rectangle2D)rectangle);
            }
            catch (JRException jRException) {
                throw new JRRuntimeException((Throwable)jRException);
            }
            ImageMapPanel imageMapPanel = this;
            imageMapPanel.addMouseListener(imageMapPanel);
            ImageMapPanel imageMapPanel2 = this;
            imageMapPanel2.addMouseMotionListener(imageMapPanel2);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = this.getImageMapArea(mouseEvent);
            if (jRPrintImageAreaHyperlink != null) {
                string = JRViewer.this.getHyperlinkTooltip(jRPrintImageAreaHyperlink.getHyperlink());
            }
            if (string == null) {
                string = super.getToolTipText(mouseEvent);
            }
            return string;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JRViewer.this.pnlLinksMouseDragged(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = this.getImageMapArea(mouseEvent);
            if (jRPrintImageAreaHyperlink != null && jRPrintImageAreaHyperlink.getHyperlink().getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }

        protected JRPrintImageAreaHyperlink getImageMapArea(MouseEvent mouseEvent) {
            return this.getImageMapArea((int)((float)mouseEvent.getX() / JRViewer.this.realZoom), (int)((float)mouseEvent.getY() / JRViewer.this.realZoom));
        }

        protected JRPrintImageAreaHyperlink getImageMapArea(int n2, int n3) {
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = null;
            if (this.imageAreaHyperlinks != null) {
                ListIterator<JRPrintImageAreaHyperlink> listIterator = this.imageAreaHyperlinks.listIterator(this.imageAreaHyperlinks.size());
                while (jRPrintImageAreaHyperlink == null && listIterator.hasPrevious()) {
                    JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink2 = listIterator.previous();
                    if (!jRPrintImageAreaHyperlink2.getArea().containsPoint(n2, n3)) continue;
                    jRPrintImageAreaHyperlink = jRPrintImageAreaHyperlink2;
                }
            }
            return jRPrintImageAreaHyperlink;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent = this.getImageMapArea(mouseEvent)) != null) {
                JRViewer.this.hyperlinkClicked(mouseEvent.getHyperlink());
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(13));
            JRViewer.this.pnlLinksMousePressed(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            JRViewer.this.pnlLinksMouseReleased(mouseEvent);
        }
    }

    private static enum ExportFormat {
        PDF("pdf", "PDF"),
        XLSX("xlsx", "Excel"),
        CSV("csv", "CSV");

        final String ext;
        final String label;

        private ExportFormat(String string2, String string3) {
            this.ext = string2;
            this.label = string3;
        }

        public final String toString() {
            return this.label;
        }
    }
}

