/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import java.io.File;
import java.nio.charset.StandardCharsets;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleDocxReportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;

public final class ReportExportUtil {
    private ReportExportUtil() {
    }

    public static void export(JasperPrint jasperPrint, File object, Format format) {
        Object object2 = format.ext;
        String string = ((String)(object = ((File)object).getAbsolutePath())).toLowerCase();
        object = string.endsWith("." + (String)object2) ? object : (String)object + "." + (String)object2;
        switch (format) {
            case PDF: {
                object2 = object;
                object = jasperPrint;
                JasperExportManager.exportReportToPdfFile((JasperPrint)object, (String)object2);
                return;
            }
            case XLSX: {
                object2 = object;
                object = jasperPrint;
                string = new JRXlsxExporter();
                string.setExporterInput((ExporterInput)new SimpleExporterInput((JasperPrint)object));
                string.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((String)object2));
                jasperPrint = new SimpleXlsxReportConfiguration();
                jasperPrint.setDetectCellType(Boolean.TRUE);
                jasperPrint.setCollapseRowSpan(Boolean.FALSE);
                jasperPrint.setWhitePageBackground(Boolean.FALSE);
                jasperPrint.setRemoveEmptySpaceBetweenRows(Boolean.TRUE);
                jasperPrint.setOnePagePerSheet(Boolean.FALSE);
                string.setConfiguration((ReportExportConfiguration)jasperPrint);
                string.exportReport();
                return;
            }
            case CSV: {
                object2 = object;
                object = jasperPrint;
                string = new JRCsvExporter();
                string.setExporterInput((ExporterInput)new SimpleExporterInput((JasperPrint)object));
                string.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((String)object2, StandardCharsets.UTF_8.name()));
                jasperPrint = new SimpleCsvExporterConfiguration();
                jasperPrint.setFieldDelimiter(",");
                string.setConfiguration((ExporterConfiguration)jasperPrint);
                string.exportReport();
                return;
            }
            case DOCX: {
                object2 = object;
                object = jasperPrint;
                string = new JRDocxExporter();
                string.setExporterInput((ExporterInput)new SimpleExporterInput((JasperPrint)object));
                string.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((String)object2));
                string.setConfiguration((ReportExportConfiguration)new SimpleDocxReportConfiguration());
                string.exportReport();
                return;
            }
            case HTML: {
                object2 = object;
                object = jasperPrint;
                JasperExportManager.exportReportToHtmlFile((JasperPrint)object, (String)object2);
                return;
            }
        }
        throw new JRException("Unsupported format: " + (Object)((Object)format));
    }

    public static enum Format {
        PDF("pdf"),
        XLSX("xlsx"),
        CSV("csv"),
        DOCX("docx"),
        HTML("html");

        public final String ext;

        private Format(String string2) {
            this.ext = string2;
        }
    }
}

