/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.pos.forms.AppProperties;
import com.posics.pos.printer.escpos.TlvBox;
import com.posics.pos.util.Base64Encoder;
import com.posics.pos.util.ZatcaQrGenerator;
import com.posics.pos.util.ZatcaXmlGenerator;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.EmailValidator;

public class StringUtils {
    private static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static boolean m_blIsOnline;
    public static boolean m_blsecondDisplayAvailable;
    public static boolean m_blIsNetworkPrinterOnline;
    public static boolean m_blIsDemo;
    public static boolean m_blIsTrial;
    public static String m_sSerial;
    public static String m_sMac;
    public static int m_intTrialDays;
    public static boolean m_blIsActivated;
    public static boolean m_blIsPCheckRunning;
    public static boolean m_blIsPriceEdited;
    public static double m_dContinuousWeight;
    public static AppProperties config;
    public static Map<String, String> ticketEvents;
    public static Properties props;
    public static boolean m_blIsRTL;
    public static boolean m_blIsTunnelActive;
    public static boolean m_blIsTerminalTunnelActive;
    public static boolean m_blIsDynEnabled;
    public static boolean m_blIsHidLoaded;
    public static boolean m_blTableLayoutRunning;
    public static StringBuffer m_sReceiptBarcode;
    public static String m_sGlobalVariable1;
    public static boolean m_blTicketProperties;
    public static List<String> networkprinterpool;
    public static String m_sZatcaJson;
    public static String m_sZatcaPrivateKey;

    private StringUtils() {
    }

    public static String getCardNumber() {
        return "Card";
    }

    public static String encodeXML(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c2 == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c2 == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c2 == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c2 == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String byte2hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length << 1);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = (byArray[i2] & 0xF0) >> 4;
            int n3 = byArray[i2] & 0xF;
            stringBuffer.append(a[n2]);
            stringBuffer.append(a[n3]);
        }
        return stringBuffer.toString();
    }

    public static byte[] hex2byte(String string) {
        int n2 = string.length();
        if ((n2 & 1) != 0) {
            throw new IllegalArgumentException("odd number of characters.");
        }
        byte[] byArray = new byte[n2 >> 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = Character.digit(string.charAt(n4++), 16) << 4;
            byArray[n3] = (byte)(n5 |= Character.digit(string.charAt(n4++), 16));
            ++n3;
        }
        return byArray;
    }

    public static String readResource(String object) {
        int n2;
        InputStream inputStream = StringUtils.class.getResourceAsStream((String)object);
        if (inputStream == null) {
            throw new FileNotFoundException((String)object);
        }
        object = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) > 0) {
            ((ByteArrayOutputStream)object).write(byArray, 0, n2);
        }
        object = ((ByteArrayOutputStream)object).toByteArray();
        return new String((byte[])object, "UTF-8");
    }

    public static boolean isNumber(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '0' || c2 == '1' || c2 == '2' || c2 == '3' || c2 == '4' || c2 == '5' || c2 == '6' || c2 == '7' || c2 == '8' || c2 == '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isDouble(String string) {
        return Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", string);
    }

    public static boolean isValidIPAddress(String stringArray) {
        if ((stringArray = stringArray.split("\\.")).length != 4) {
            return false;
        }
        for (String string : stringArray) {
            int n2 = Integer.parseInt(string);
            if (n2 >= 0 && n2 <= 255) continue;
            return false;
        }
        return true;
    }

    public static String asciiBytesToString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        char[] cArray = new char[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if ((char)byArray[i2] <= '\u001f' || (char)byArray[i2] >= '\u007f') continue;
            cArray[i2] = (char)byArray[i2];
        }
        return new String(cArray);
    }

    public static String getZatcaQR(String stringArray) {
        stringArray = stringArray.split("\\r?\\n|\\r");
        TlvBox tlvBox = TlvBox.create();
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            tlvBox.put(i2, stringArray[i2]);
        }
        byte[] byArray = tlvBox.serialize();
        return Base64Encoder.encode(byArray);
    }

    public static String getZatcaQRPhase2(String object) {
        try {
            String string;
            String[] stringArray = ((String)object).split("\\r?\\n|\\r");
            Object object2 = new ArrayList<String>();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                string = stringArray2[i2];
                if (string == null || string.trim().isEmpty()) continue;
                object2.add(string.trim());
            }
            if (object2.size() < 5) {
                throw new IllegalArgumentException("Insufficient QR fields provided.");
            }
            String string2 = (String)object2.get(0);
            String string3 = (String)object2.get(1);
            String string4 = (String)object2.get(2);
            string = (String)object2.get(3);
            object2 = (String)object2.get(4);
            String string5 = ZatcaXmlGenerator.generateInvoiceXml(m_sZatcaJson);
            String string6 = m_sZatcaPrivateKey;
            return ZatcaQrGenerator.generatePhase2QrCodeWithXmlHash(string2, string3, string4, string, (String)object2, string5, string6);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return "QR_ERROR";
        }
    }

    public static boolean isValidEmail(String string) {
        EmailValidator emailValidator = EmailValidator.getInstance();
        return emailValidator.isValid(string);
    }

    static {
        new DecimalFormat("000000");
        new Random();
        m_blIsOnline = false;
        m_blsecondDisplayAvailable = false;
        m_blIsNetworkPrinterOnline = false;
        m_blIsDemo = false;
        m_blIsTrial = false;
        m_sSerial = "";
        m_sMac = "";
        m_intTrialDays = 0;
        m_blIsActivated = false;
        m_blIsPCheckRunning = false;
        m_blIsPriceEdited = false;
        m_dContinuousWeight = -999.999;
        m_blIsRTL = false;
        m_blIsTunnelActive = false;
        m_blIsTerminalTunnelActive = false;
        m_blIsDynEnabled = false;
        m_blIsHidLoaded = false;
        m_blTableLayoutRunning = false;
        m_blTicketProperties = false;
        networkprinterpool = new ArrayList<String>();
    }
}

