/*
 * Decompiled with CFR 0.152.
 */
package com.posics.possync;

import com.posics.basic.BasicException;
import com.posics.data.gui.MessageInf;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.ProcessAction;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.ticket.TicketLineInfo;
import com.posics.possync.DataLogicIntegration;
import com.posics.possync.ExternalSalesHelper;
import com.posics.ws.externalsales.BPartner;
import com.posics.ws.externalsales.Order;
import com.posics.ws.externalsales.OrderIdentifier;
import com.posics.ws.externalsales.OrderLine;
import com.posics.ws.externalsales.Payment;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.List;
import javax.xml.rpc.ServiceException;

public class OrdersSync
implements ProcessAction {
    private DataLogicSystem a;
    private DataLogicIntegration b;
    private ExternalSalesHelper c;

    public OrdersSync(DataLogicSystem dataLogicSystem, DataLogicIntegration dataLogicIntegration) {
        this.a = dataLogicSystem;
        this.b = dataLogicIntegration;
        this.c = null;
    }

    @Override
    public MessageInf execute() {
        try {
            if (this.c == null) {
                this.c = new ExternalSalesHelper(this.a);
            }
            List list = this.b.getTickets();
            for (TicketInfo ticketInfo : list) {
                ticketInfo.setLines(this.b.getTicketLines(ticketInfo.getId()));
                ticketInfo.setPayments(this.b.getTicketPayments(ticketInfo.getId()));
            }
            if (list.size() == 0) {
                return new MessageInf(-67108864, AppLocal.getIntString("message.zeroorders"));
            }
            Order[] orderArray = new Order[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                TicketInfo ticketInfo = (TicketInfo)list.get(i2);
                orderArray[i2] = new Order();
                Object object = new OrderIdentifier();
                Payment[] paymentArray = Calendar.getInstance();
                paymentArray.setTime(ticketInfo.getDate());
                ((OrderIdentifier)object).setDateNew((Calendar)paymentArray);
                ((OrderIdentifier)object).setDocumentNo(Integer.toString(ticketInfo.getTicketId()));
                orderArray[i2].setOrderId((OrderIdentifier)object);
                orderArray[i2].setState(800175);
                if (ticketInfo.getCustomerId() == null) {
                    object = null;
                } else {
                    object = new BPartner();
                    ((BPartner)object).setId(ticketInfo.getCustomer().getSearchkey());
                    ((BPartner)object).setName(ticketInfo.getCustomer().getName());
                }
                orderArray[i2].setBusinessPartner((BPartner)object);
                object = new OrderLine[ticketInfo.getLines().size()];
                for (int i3 = 0; i3 < ticketInfo.getLines().size(); ++i3) {
                    TicketLineInfo ticketLineInfo = ticketInfo.getLines().get(i3);
                    object[i3] = new OrderLine();
                    object[i3].setOrderLineId(String.valueOf(ticketLineInfo.getTicketLine()));
                    if (ticketLineInfo.getProductID() == null) {
                        object[i3].setProductId("0");
                    } else {
                        object[i3].setProductId(ticketLineInfo.getProductID());
                    }
                    object[i3].setUnits(ticketLineInfo.getMultiply());
                    ((OrderLine)object[i3]).setPrice(ticketLineInfo.getPrice());
                    ((OrderLine)object[i3]).setTaxId(ticketLineInfo.getTaxInfo().getId());
                }
                orderArray[i2].setLines((OrderLine[])object);
                paymentArray = new Payment[ticketInfo.getPayments().size()];
                for (int i4 = 0; i4 < ticketInfo.getPayments().size(); ++i4) {
                    object = ticketInfo.getPayments().get(i4);
                    paymentArray[i4] = new Payment();
                    paymentArray[i4].setAmount(((PaymentInfo)object).getTotal());
                    if ("magcard".equals(((PaymentInfo)object).getName())) {
                        paymentArray[i4].setPaymentType("K");
                        continue;
                    }
                    if ("cheque".equals(((PaymentInfo)object).getName())) {
                        paymentArray[i4].setPaymentType("2");
                        continue;
                    }
                    if ("cash".equals(((PaymentInfo)object).getName())) {
                        paymentArray[i4].setPaymentType("B");
                        continue;
                    }
                    paymentArray[i4].setPaymentType(null);
                }
                orderArray[i2].setPayment(paymentArray);
            }
            if (!this.c.uploadOrders(orderArray)) {
                throw new BasicException(AppLocal.getIntString("message.returnnull"));
            }
            this.b.execTicketUpdate();
            return new MessageInf(-83886080, AppLocal.getIntString("message.syncordersok"), AppLocal.getIntString("message.syncordersinfo", orderArray.length));
        }
        catch (ServiceException serviceException) {
            throw new BasicException(AppLocal.getIntString("message.serviceexception"), serviceException);
        }
        catch (RemoteException remoteException) {
            throw new BasicException(AppLocal.getIntString("message.remoteexception"), remoteException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BasicException(AppLocal.getIntString("message.malformedurlexception"), malformedURLException);
        }
    }
}

