/*
 * Decompiled with CFR 0.152.
 */
package com.posics.possync;

import com.posics.basic.BasicException;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.IKeyed;
import com.posics.data.loader.ImageUtils;
import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.ProcessAction;
import com.posics.pos.inventory.MovementReason;
import com.posics.pos.inventory.TaxCategoryInfo;
import com.posics.pos.ticket.CategoryInfo;
import com.posics.pos.ticket.ProductInfoExt;
import com.posics.pos.ticket.TaxInfo;
import com.posics.possync.DataLogicIntegration;
import com.posics.possync.ExternalSalesHelper;
import com.posics.ws.customers.Customer;
import com.posics.ws.externalsales.Product;
import com.posics.ws.externalsales.ProductPlus;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.UUID;
import javax.xml.rpc.ServiceException;

public class ProductsSync
implements ProcessAction {
    private DataLogicSystem a;
    private DataLogicIntegration b;
    private DataLogicSales c;
    private String d;
    private ExternalSalesHelper e;

    public ProductsSync(DataLogicSystem dataLogicSystem, DataLogicIntegration dataLogicIntegration, DataLogicSales dataLogicSales, String string) {
        this.a = dataLogicSystem;
        this.b = dataLogicIntegration;
        this.c = dataLogicSales;
        this.d = string;
        this.e = null;
    }

    @Override
    public MessageInf execute() {
        try {
            Serializable serializable;
            int n2;
            Customer[] customerArray;
            if (this.e == null) {
                this.e = new ExternalSalesHelper(this.a);
            }
            Product[] productArray = this.e.getProductsCatalog();
            Customer[] customerArray2 = this.e.getCustomers();
            if (productArray == null || customerArray2 == null) {
                throw new BasicException(AppLocal.getIntString("message.returnnull"));
            }
            if (productArray.length > 0) {
                this.b.syncProductsBefore();
                customerArray = new Date();
                Product[] productArray2 = productArray;
                n2 = productArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    serializable = productArray2[i2];
                    TaxCategoryInfo taxCategoryInfo = new TaxCategoryInfo(((Product)serializable).getTax().getId(), ((Product)serializable).getTax().getName());
                    this.b.syncTaxCategory(taxCategoryInfo);
                    IKeyed iKeyed = new TaxInfo(((Product)serializable).getTax().getId(), ((Product)serializable).getTax().getName(), taxCategoryInfo.getID(), null, null, ((Product)serializable).getTax().getPercentage() / 100.0, false, 0);
                    this.b.syncTax((TaxInfo)iKeyed);
                    iKeyed = new CategoryInfo(((Product)serializable).getCategory().getId(), ((Product)serializable).getCategory().getName(), null);
                    this.b.syncCategory((CategoryInfo)iKeyed);
                    ProductInfoExt productInfoExt = new ProductInfoExt();
                    productInfoExt.setID(((Product)serializable).getId());
                    productInfoExt.setReference(((Product)serializable).getId());
                    productInfoExt.setCode(((Product)serializable).getEan() == null || ((Product)serializable).getEan().equals("") ? ((Product)serializable).getId() : ((Product)serializable).getEan());
                    productInfoExt.setName(((Product)serializable).getName());
                    productInfoExt.setCom(false);
                    productInfoExt.setScale(false);
                    productInfoExt.setPriceBuy(((Product)serializable).getPurchasePrice());
                    productInfoExt.setPriceSell(((Product)serializable).getListPrice());
                    productInfoExt.setCategoryID(((CategoryInfo)iKeyed).getID());
                    productInfoExt.setTaxCategoryID(taxCategoryInfo.getID());
                    productInfoExt.setImage(ImageUtils.readImage(((Product)serializable).getImageUrl()));
                    this.b.syncProduct(productInfoExt);
                    if (!(serializable instanceof ProductPlus)) continue;
                    serializable = (ProductPlus)serializable;
                    double d2 = ((ProductPlus)serializable).getQtyonhand() - this.c.findProductStock(this.d, productInfoExt.getID(), null);
                    Object[] objectArray = new Object[7];
                    serializable = objectArray;
                    objectArray[0] = UUID.randomUUID().toString();
                    serializable[1] = customerArray;
                    serializable[2] = d2 > 0.0 ? MovementReason.IN_MOVEMENT.getKey() : MovementReason.OUT_MOVEMENT.getKey();
                    serializable[3] = this.d;
                    serializable[4] = productInfoExt.getID();
                    serializable[5] = Double.valueOf(d2);
                    serializable[6] = new Double(productInfoExt.getPriceBuy());
                    this.c.getStockDiaryInsert().exec((Object[])serializable);
                }
            }
            if (customerArray2.length > 0) {
                this.b.syncCustomersBefore();
                customerArray = customerArray2;
                int n3 = customerArray2.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    Customer customer = customerArray[n2];
                    serializable = new CustomerInfoExt(customer.getId());
                    ((CustomerInfo)serializable).setSearchkey(customer.getSearchKey());
                    ((CustomerInfo)serializable).setName(customer.getName());
                    ((CustomerInfoExt)serializable).setNotes(customer.getDescription());
                    this.b.syncCustomer((CustomerInfoExt)serializable);
                }
            }
            if (productArray.length == 0 && customerArray2.length == 0) {
                return new MessageInf(-67108864, AppLocal.getIntString("message.zeroproducts"));
            }
            return new MessageInf(-83886080, AppLocal.getIntString("message.syncproductsok"), AppLocal.getIntString("message.syncproductsinfo", productArray.length, customerArray2.length));
        }
        catch (ServiceException serviceException) {
            throw new BasicException(AppLocal.getIntString("message.serviceexception"), serviceException);
        }
        catch (RemoteException remoteException) {
            throw new BasicException(AppLocal.getIntString("message.remoteexception"), remoteException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BasicException(AppLocal.getIntString("message.malformedurlexception"), malformedURLException);
        }
    }
}

