/*
 * Decompiled with CFR 0.152.
 */
package com.saleculator.scale;

import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.AppView;
import com.posics.pos.scale.DeviceScale;
import com.posics.pos.scale.ScaleMonitorObservable;
import com.saleculator.scale.a;
import com.saleculator.scale.b;
import com.saleculator.scale.c;
import com.saleculator.scale.d;
import com.saleculator.scale.e;
import com.saleculator.wizard.JWizardComponents;
import com.saleculator.wizard.JWizardFrame;
import com.saleculator.wizard.JWizardPanel;
import com.saleculator.wizard.Utilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CalibrationWizard
extends JWizardFrame {
    public static final int PANEL_FIRST = 0;
    public static final int PANEL_SECOND = 1;
    public static final int PANEL_THIRD = 2;
    public static final int PANEL_INPUT = 3;
    public static final int PANEL_LAST = 4;
    DeviceScale m_Scale;
    ScaleMonitorObserver scaleObserver;
    ScaleMonitorObservable observableScale;
    JWizardPanel panel;
    String m_Weight = "0.000";
    public long emptyValue = 0L;
    public double emptyWeight = 0.0;
    public long calibrationValue = 0L;
    public double calibrationWeight = 0.0;
    protected AppConfig m_Config;
    protected AppView m_App;

    public CalibrationWizard(AppView object, AppConfig appConfig) {
        this.m_App = object;
        object = this;
        ((Frame)object).setTitle("Weighing Scale Calibration");
        ((CalibrationWizard)object).panel = null;
        Object object2 = object;
        ((CalibrationWizard)object).panel = (CalibrationWizard)object2.new FirstWizardPanel(((JWizardFrame)object2).getWizardComponents());
        ((JWizardFrame)object).getWizardComponents().addWizardPanel(0, ((CalibrationWizard)object).panel);
        Object object3 = object;
        ((CalibrationWizard)object).panel = (CalibrationWizard)object3.new SecondWizardPanel(((JWizardFrame)object3).getWizardComponents());
        ((JWizardFrame)object).getWizardComponents().addWizardPanel(1, ((CalibrationWizard)object).panel);
        Object object4 = object;
        ((CalibrationWizard)object).panel = (CalibrationWizard)object4.new ThirdWizardPanel(((JWizardFrame)object4).getWizardComponents());
        ((JWizardFrame)object).getWizardComponents().addWizardPanel(2, ((CalibrationWizard)object).panel);
        Object object5 = object;
        ((CalibrationWizard)object).panel = (CalibrationWizard)object5.new ChooserWizardPanel(((JWizardFrame)object5).getWizardComponents());
        ((JWizardFrame)object).getWizardComponents().addWizardPanel(3, ((CalibrationWizard)object).panel);
        Object object6 = object;
        ((CalibrationWizard)object).panel = (CalibrationWizard)object6.new LastWizardPanel(((JWizardFrame)object6).getWizardComponents());
        ((JWizardFrame)object).getWizardComponents().addWizardPanel(4, ((CalibrationWizard)object).panel);
        Object object7 = object;
        ((JWizardFrame)object).getWizardComponents().setCancelAction(new a((CalibrationWizard)object7, ((JWizardFrame)object7).getWizardComponents()));
        Object object8 = object;
        ((JWizardFrame)object).getWizardComponents().setFinishAction(new b((CalibrationWizard)object8, ((JWizardFrame)object8).getWizardComponents()));
        ((Window)object).setSize(500, 300);
        Utilities.centerComponentOnScreen((Component)object);
        if (this.m_App.getDeviceScale() != null) {
            this.m_App.getDeviceScale().stopListening();
        }
        this.m_Config = appConfig;
        this.m_Scale = new DeviceScale(Boolean.TRUE, 0L, 0.0, 0L, 0.0);
        this.observableScale = new ScaleMonitorObservable(this.m_Scale);
        CalibrationWizard calibrationWizard = this;
        this.scaleObserver = new ScaleMonitorObserver(calibrationWizard, calibrationWizard.observableScale);
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public void loadCalibrationProperties() {
        this.emptyValue = Long.parseLong(this.m_Config.getProperty("Scale.emptyValue"));
        this.calibrationValue = Long.parseLong(this.m_Config.getProperty("Scale.calibrationValue"));
        this.calibrationWeight = Double.parseDouble(this.m_Config.getProperty("Scale.calibrationWeight"));
    }

    public void saveCalibrationProperties(long l2, long l3, double d2) {
        this.m_Config.setProperty("Scale.emptyValue", Long.toString(l2));
        this.m_Config.setProperty("Scale.calibrationValue", Long.toString(l3));
        this.m_Config.setProperty("Scale.calibrationWeight", Double.toString(d2));
    }

    static /* synthetic */ void access$000(CalibrationWizard calibrationWizard, String string) {
        if (string.equals("NaN")) {
            calibrationWizard.getWizardComponents().setPanelWeight("---");
            return;
        }
        calibrationWizard.getWizardComponents().setPanelWeight(string);
    }

    class LastWizardPanel
    extends LabelWizardPanel {
        public LastWizardPanel(JWizardComponents jWizardComponents) {
            super(jWizardComponents, "Calibration completed. You can finish now.");
        }
    }

    class ChooserWizardPanel
    extends JWizardPanel {
        private JTextField txtWeight;
        private JRadioButton optionGram;
        private JRadioButton optionKilo;
        private ButtonGroup bg;
        private int selectedOption;
        private double sampleWeight;

        public ChooserWizardPanel(JWizardComponents object) {
            super((JWizardComponents)object, "");
            this.selectedOption = 0;
            this.sampleWeight = 0.0;
            CalibrationWizard.this = this;
            this.txtWeight = new JTextField();
            ((ChooserWizardPanel)CalibrationWizard.this).txtWeight.setColumns(4);
            ((ChooserWizardPanel)CalibrationWizard.this).optionGram = new JRadioButton();
            ((ChooserWizardPanel)CalibrationWizard.this).optionKilo = new JRadioButton();
            object = new ButtonGroup();
            ((ButtonGroup)object).add(((ChooserWizardPanel)CalibrationWizard.this).optionGram);
            ((ButtonGroup)object).add(((ChooserWizardPanel)CalibrationWizard.this).optionKilo);
            CalibrationWizard.this.setLayout(new GridBagLayout());
            CalibrationWizard.this.add((Component)new JLabel("Enter the sample weight placed: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            Container container2 = CalibrationWizard.this;
            container2.add((Component)((ChooserWizardPanel)container2).txtWeight, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            ((ChooserWizardPanel)CalibrationWizard.this).txtWeight.getDocument().addDocumentListener(new c((ChooserWizardPanel)CalibrationWizard.this));
            Container container3 = CalibrationWizard.this;
            container3.add((Component)((ChooserWizardPanel)container3).optionGram, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            ((ChooserWizardPanel)CalibrationWizard.this).optionGram.addItemListener(new d((ChooserWizardPanel)CalibrationWizard.this));
            CalibrationWizard.this.add((Component)new JLabel("Gram"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            Container container4 = CalibrationWizard.this;
            container4.add((Component)((ChooserWizardPanel)container4).optionKilo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            ((ChooserWizardPanel)CalibrationWizard.this).optionKilo.addItemListener(new e((ChooserWizardPanel)CalibrationWizard.this));
            CalibrationWizard.this.add((Component)new JLabel("Kilo Gram"), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public void update() {
            ChooserWizardPanel chooserWizardPanel = this;
            chooserWizardPanel.setNextButtonEnabled((chooserWizardPanel.selectedOption == 1 || this.selectedOption == 2) && this.sampleWeight > 0.0);
        }

        @Override
        public void next() {
            if ((this.selectedOption == 1 || this.selectedOption == 2) && this.sampleWeight > 0.0) {
                CalibrationWizard.this.calibrationWeight = this.selectedOption == 1 ? this.sampleWeight / 1000.0 : this.sampleWeight;
                CalibrationWizard.this.saveCalibrationProperties(CalibrationWizard.this.emptyValue, CalibrationWizard.this.calibrationValue, CalibrationWizard.this.calibrationWeight);
                try {
                    CalibrationWizard.this.m_Scale.stopListening();
                    if (CalibrationWizard.this.observableScale != null) {
                        CalibrationWizard.this.observableScale.deleteObservers();
                    }
                    CalibrationWizard.this.m_Scale = new DeviceScale(Boolean.TRUE, CalibrationWizard.this.emptyValue, CalibrationWizard.this.emptyWeight, CalibrationWizard.this.calibrationValue, CalibrationWizard.this.calibrationWeight);
                    CalibrationWizard.this.observableScale = new ScaleMonitorObservable(CalibrationWizard.this.m_Scale);
                    CalibrationWizard.this.scaleObserver = new ScaleMonitorObserver(CalibrationWizard.this, CalibrationWizard.this.observableScale);
                    this.switchPanel(4);
                    return;
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
        }

        @Override
        public void back() {
            this.switchPanel(2);
        }

        static /* synthetic */ JTextField access$100(ChooserWizardPanel chooserWizardPanel) {
            return chooserWizardPanel.txtWeight;
        }

        static /* synthetic */ double access$202(ChooserWizardPanel chooserWizardPanel, double d2) {
            chooserWizardPanel.sampleWeight = d2;
            return chooserWizardPanel.sampleWeight;
        }

        static /* synthetic */ int access$300(ChooserWizardPanel chooserWizardPanel) {
            return chooserWizardPanel.selectedOption;
        }

        static /* synthetic */ void access$400(ChooserWizardPanel chooserWizardPanel, boolean bl2) {
            chooserWizardPanel.setNextButtonEnabled(bl2);
        }

        static /* synthetic */ void access$500(ChooserWizardPanel chooserWizardPanel, boolean bl2) {
            chooserWizardPanel.setNextButtonEnabled(bl2);
        }

        static /* synthetic */ int access$302(ChooserWizardPanel chooserWizardPanel, int n2) {
            chooserWizardPanel.selectedOption = n2;
            return chooserWizardPanel.selectedOption;
        }
    }

    class ThirdWizardPanel
    extends LabelWizardPanel {
        public ThirdWizardPanel(JWizardComponents jWizardComponents) {
            super(jWizardComponents, "Place the sample weight on weighing platform.");
            this.setPanelTitle("");
        }

        @Override
        public void next() {
            CalibrationWizard.this.calibrationValue = CalibrationWizard.this.m_Scale.getValue();
            System.out.println(CalibrationWizard.this.calibrationValue);
            this.switchPanel(3);
        }

        @Override
        public void back() {
            this.switchPanel(1);
        }
    }

    class SecondWizardPanel
    extends LabelWizardPanel {
        public SecondWizardPanel(JWizardComponents jWizardComponents) {
            super(jWizardComponents, "Remove all weights from the platform, and adjust weight to zero.");
            this.setPanelTitle("");
        }

        @Override
        public void next() {
            CalibrationWizard.this.emptyValue = CalibrationWizard.this.m_Scale.getValue();
            this.switchPanel(2);
        }

        @Override
        public void back() {
            this.switchPanel(0);
        }
    }

    class FirstWizardPanel
    extends LabelWizardPanel {
        public FirstWizardPanel(JWizardComponents jWizardComponents) {
            super(jWizardComponents, "Make sure the weighing scale is level and the platform is clean.");
            this.setPanelTitle("");
        }
    }

    class LabelWizardPanel
    extends JWizardPanel {
        public LabelWizardPanel(JWizardComponents jWizardComponents, String string) {
            super(jWizardComponents);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(string), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public class ScaleMonitorObserver
    implements Observer {
        private /* synthetic */ CalibrationWizard a;

        public ScaleMonitorObserver(CalibrationWizard calibrationWizard, ScaleMonitorObservable scaleMonitorObservable) {
            this.a = calibrationWizard;
            scaleMonitorObservable.addObserver(this);
            new Thread(scaleMonitorObservable).start();
        }

        @Override
        public void update(Observable object, Object object2) {
            object = Double.parseDouble(object2.toString());
            this.a.m_Weight = String.format("%.3f", object);
            CalibrationWizard.access$000(this.a, this.a.m_Weight);
        }
    }
}

