/*
 * Decompiled with CFR 0.152.
 */
package com.saleculator.scale;

import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinState;

public class HX711 {
    private final GpioPinDigitalOutput a;
    private final GpioPinDigitalInput b;
    private int c;
    public long emptyValue = 0L;
    public double emptyWeight = 0.0;
    public long calibrationValue = 0L;
    public double calibrationWeight = 0.0;
    public double fullCupWeight = 0.0;
    public double weight = 0.0;
    public long value = 0L;

    public HX711(GpioPinDigitalInput gpioPinDigitalInput, GpioPinDigitalOutput gpioPinDigitalOutput, int n2) {
        this.a = gpioPinDigitalOutput;
        this.b = gpioPinDigitalInput;
        this.setGain(n2);
    }

    public void read() {
        this.a.setState(PinState.LOW);
        while (!this.isReady()) {
            long l2 = 1L;
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        long l3 = 0L;
        for (int i2 = 0; i2 < this.c; ++i2) {
            this.a.setState(PinState.HIGH);
            l3 <<= 1;
            this.a.setState(PinState.LOW);
            if (!this.b.isHigh()) continue;
            ++l3;
        }
        this.a.setState(PinState.HIGH);
        this.a.setState(PinState.LOW);
        this.value = l3 ^= 0x800000L;
        this.weight = (double)(this.value - this.emptyValue) * ((this.calibrationWeight - this.emptyWeight) / (double)(this.calibrationValue - this.emptyValue));
    }

    public void setGain(int n2) {
        switch (n2) {
            case 128: {
                this.c = 24;
                break;
            }
            case 64: {
                this.c = 26;
                break;
            }
            case 32: {
                this.c = 25;
            }
        }
        this.a.setState(PinState.LOW);
        this.read();
    }

    public boolean isReady() {
        return this.b.isLow();
    }
}

