/*
 * Decompiled with CFR 0.152.
 */
package com.saleculator.scale;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.wiringpi.GpioUtil;
import com.posics.pos.scale.Scale;
import com.saleculator.scale.HX711;

public class ScaleAvia
implements Scale {
    private GpioPinDigitalInput a;
    private GpioPinDigitalOutput b;
    private GpioController c;
    private HX711 d;
    private double e = 0.0;
    private double f = 0.0;

    public ScaleAvia(Long l2, Double d2, Long l3, Double d3) {
        GpioUtil.enableNonPrivilegedAccess();
        this.c = GpioFactory.getInstance();
        this.a = this.c.provisionDigitalInputPin(RaspiPin.GPIO_16, "HX_DAT", PinPullResistance.OFF);
        this.b = this.c.provisionDigitalOutputPin(RaspiPin.GPIO_15, "HX_CLK", PinState.LOW);
        this.d = new HX711(this.a, this.b, 128);
        this.d.emptyValue = l2;
        this.d.emptyWeight = d2;
        this.d.calibrationValue = l3;
        this.d.calibrationWeight = d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Double readWeight() {
        var1_1 = this;
        synchronized (var1_1) {
            block7: {
                this.d.read();
                var2_2 = this.d.weight;
                if (!(this.e > 0.0)) break block7;
                var2_2 -= this.e;
                ** GOTO lbl-1000
            }
            if (this.f > 0.0) {
                var2_2 /= this.f;
                var2_2 = (int)(this.roundDouble(var2_2 / 0.5, 0) * 0.5);
            } else lbl-1000:
            // 2 sources

            {
                var2_2 = this.roundDouble(var2_2 / 0.01, 0) * 0.01;
            }
            if (var2_2 > 0.0) {
                if (var2_2 < 0.05) {
                    this.e = 0.0;
                }
                return var2_2;
            }
            return 0.0;
        }
    }

    @Override
    public void updateWeight() {
    }

    public double roundDouble(double d2, int n2) {
        if (n2 > 0) {
            return (double)Math.round(d2 * Math.pow(10.0, n2)) / Math.pow(10.0, n2);
        }
        return Math.round(d2);
    }

    @Override
    public void stopListening() {
        try {
            this.c.shutdown();
            this.c.unprovisionPin(new GpioPin[]{this.a});
            this.c.unprovisionPin(new GpioPin[]{this.b});
            return;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return;
        }
    }

    @Override
    public long getEmptyValue() {
        return this.d.emptyValue;
    }

    @Override
    public long getCalibrationValue() {
        return this.d.calibrationValue;
    }

    @Override
    public long getValue() {
        return this.d.value;
    }

    @Override
    public void setEmptyWeight(double d2) {
        if (d2 < 0.009) {
            this.e = 0.0;
            return;
        }
        this.e += d2;
        this.f = 0.0;
    }

    @Override
    public void setCounting(double d2) {
        if (this.f == 0.0) {
            this.f = d2;
            this.e = 0.0;
            return;
        }
        this.f = 0.0;
        this.e = 0.0;
    }
}

