/*
 * Decompiled with CFR 0.152.
 */
package com.saleculator.scale;

import com.posics.data.loader.IKeyed;
import com.posics.data.loader.SerializerRead;
import com.posics.format.Formats;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.util.StringUtils;
import com.saleculator.scale.r;
import java.io.Serializable;
import java.text.DecimalFormat;

public class ScaleProductInfo
implements IKeyed,
Serializable {
    protected String m_ID = null;
    protected String m_sRef = "0000";
    protected String m_sCode = "0000";
    protected String m_sName = null;
    protected boolean m_bScale = false;
    protected String categoryid = null;
    protected String taxcategoryid = null;
    private TaxInfo m_tax;
    protected double m_dPriceBuy = 0.0;
    protected double m_dPriceSell = 0.0;
    DecimalFormat decimalFormatter;
    protected boolean m_bIsSelected = true;

    public ScaleProductInfo() {
        int n2 = Formats.getCurrencyDecimals();
        if (n2 == 0) {
            this.decimalFormatter = new DecimalFormat("#0");
            return;
        }
        if (n2 == 1) {
            this.decimalFormatter = new DecimalFormat("#0.0");
            return;
        }
        if (n2 == 2) {
            this.decimalFormatter = new DecimalFormat("#0.00");
            return;
        }
        if (n2 == 3) {
            this.decimalFormatter = new DecimalFormat("#0.000");
            return;
        }
        if (n2 == 4) {
            this.decimalFormatter = new DecimalFormat("#0.0000");
            return;
        }
        this.decimalFormatter = new DecimalFormat("#0.00");
    }

    public final String getID() {
        return this.m_ID;
    }

    public final void setID(String string) {
        this.m_ID = string;
    }

    public final String getReference() {
        return this.m_sRef;
    }

    public final void setReference(String string) {
        this.m_sRef = string;
    }

    public final String getCode() {
        return this.m_sCode;
    }

    public final void setCode(String string) {
        this.m_sCode = string;
    }

    public final String getName() {
        return this.m_sName;
    }

    public final String printName() {
        return StringUtils.encodeXML(this.m_sName);
    }

    public final void setName(String string) {
        this.m_sName = string;
    }

    public final boolean isScale() {
        return this.m_bScale;
    }

    public final void setScale(boolean bl2) {
        this.m_bScale = bl2;
    }

    public final String getCategoryID() {
        return this.categoryid;
    }

    public final void setCategoryID(String string) {
        this.categoryid = string;
    }

    public final String getTaxCategoryID() {
        return this.taxcategoryid;
    }

    public final void setTaxCategoryID(String string) {
        this.taxcategoryid = string;
    }

    public final double getPriceBuy() {
        return this.m_dPriceBuy;
    }

    public final void setPriceBuy(double d2) {
        this.m_dPriceBuy = d2;
    }

    public final double getPriceSell() {
        return this.m_dPriceSell;
    }

    public final void setPriceSell(double d2) {
        this.m_dPriceSell = d2;
    }

    public final String getPriceSellTax() {
        double d2 = this.m_dPriceSell * (1.0 + this.m_tax.getRate());
        return this.decimalFormatter.format(d2);
    }

    public String printPriceSell() {
        return Formats.CURRENCY.formatValue(new Double(this.getPriceSell()));
    }

    public String printPriceSellTax() {
        return Formats.CURRENCY.formatValue(new Double(this.getPriceSellTax()));
    }

    public static SerializerRead getSerializerRead() {
        return new r();
    }

    public final String toString() {
        return this.m_sCode + " - " + this.m_sName + " (" + this.printPriceSellTax() + ")";
    }

    @Override
    public final String getKey() {
        return this.getCode();
    }

    public final void setSelected(boolean bl2) {
        this.m_bIsSelected = bl2;
    }

    public final boolean isSelected() {
        return this.m_bIsSelected;
    }

    public final void setTax(TaxInfo taxInfo) {
        this.m_tax = taxInfo;
    }
}

