/*
 * Decompiled with CFR 0.152.
 */
package com.saleculator.wc.oauth;

import com.saleculator.wc.HttpMethod;
import com.saleculator.wc.oauth.OAuthConfig;
import com.saleculator.wc.oauth.OAuthHeader;
import com.saleculator.wc.oauth.SpecialSymbol;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class OAuthSignature {
    private OAuthSignature() {
    }

    public static Map<String, String> getAsMap(OAuthConfig object, String string, HttpMethod object2, Map<String, String> object3) {
        if (object == null || string == null || object2 == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(OAuthHeader.OAUTH_CONSUMER_KEY.getValue(), ((OAuthConfig)object).getConsumerKey());
        hashMap.put(OAuthHeader.OAUTH_TIMESTAMP.getValue(), String.valueOf(System.currentTimeMillis() / 1000L));
        hashMap.put(OAuthHeader.OAUTH_NONCE.getValue(), UUID.randomUUID().toString());
        hashMap.put(OAuthHeader.OAUTH_SIGNATURE_METHOD.getValue(), "HMAC-SHA256");
        hashMap.putAll((Map<String, String>)object3);
        if (HttpMethod.DELETE.equals(object2)) {
            hashMap.put("force", Boolean.TRUE.toString());
        }
        object3 = hashMap;
        object = ((OAuthConfig)object).getConsumerSecret();
        object2 = object2.name();
        string = OAuthSignature.a(string);
        object3 = OAuthSignature.a(object3);
        object3 = new TreeMap<String, String>((Map<String, String>)object3);
        object3 = OAuthSignature.a(object3, SpecialSymbol.EQUAL.getEncoded(), SpecialSymbol.AMP.getEncoded());
        string = String.format("%s&%s&%s", object2, string, object3);
        object = (String)object + SpecialSymbol.AMP.getPlain();
        object = OAuthSignature.a((String)object, string);
        hashMap.put(OAuthHeader.OAUTH_SIGNATURE.getValue(), (String)object);
        return hashMap;
    }

    public static Map<String, String> getAsMap(OAuthConfig oAuthConfig, String string, HttpMethod httpMethod) {
        return OAuthSignature.getAsMap(oAuthConfig, string, httpMethod, Collections.emptyMap());
    }

    public static String getAsQueryString(OAuthConfig object, String string, HttpMethod httpMethod, Map<String, String> map) {
        if (object == null || string == null || httpMethod == null) {
            return "";
        }
        object = OAuthSignature.getAsMap((OAuthConfig)object, string, httpMethod, map);
        string = object.get(OAuthHeader.OAUTH_SIGNATURE.getValue()).replace(SpecialSymbol.PLUS.getPlain(), SpecialSymbol.PLUS.getEncoded());
        object.put(OAuthHeader.OAUTH_SIGNATURE.getValue(), string);
        return OAuthSignature.a((Map<String, String>)object, SpecialSymbol.EQUAL.getPlain(), SpecialSymbol.AMP.getPlain());
    }

    public static String getAsQueryString(OAuthConfig oAuthConfig, String string, HttpMethod httpMethod) {
        return OAuthSignature.getAsQueryString(oAuthConfig, string, httpMethod, Collections.emptyMap());
    }

    private static String a(String object, String string) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            object = new SecretKeySpec(((String)object).getBytes("UTF-8"), "HmacSHA256");
            mac.init((Key)object);
            return Base64.encodeBase64String((byte[])mac.doFinal(string.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static String a(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static String a(Map<String, String> map, String string, String string2) {
        return map.entrySet().stream().map(entry -> (String)entry.getKey() + string + (String)entry.getValue()).collect(Collectors.joining(string2));
    }

    private static Map<String, String> a(Map<String, String> object) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            String object2 = (String)entry.getValue();
            hashMap.put(OAuthSignature.b(string), OAuthSignature.b(object2));
        }
        return hashMap;
    }

    private static String b(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replace(SpecialSymbol.PLUS.getPlain(), SpecialSymbol.PLUS.getEncoded()).replace(SpecialSymbol.STAR.getPlain(), SpecialSymbol.STAR.getEncoded()).replace(SpecialSymbol.TILDE.getEncoded(), SpecialSymbol.TILDE.getPlain());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }
}

