--    Posics Saleculator - Billing System.
--    Copyright (C) Posics.
--    http://www.posics.com

-- Database initial script for MYSQL
-- 3.0

CREATE TABLE APPLICATIONS (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    VERSION VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);
INSERT INTO APPLICATIONS(ID, NAME, VERSION) VALUES($APP_ID{}, $APP_NAME{}, $APP_VERSION{});

CREATE TABLE ROLES (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    PERMISSIONS BLOB,
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ROLES_NAME_INX ON ROLES(NAME);
INSERT INTO ROLES(ID, NAME, PERMISSIONS) VALUES('0', 'Administrator role', $FILE{/com/posics/pos/templates/Role.Administrator.xml} );
INSERT INTO ROLES(ID, NAME, PERMISSIONS) VALUES('1', 'Manager role', $FILE{/com/posics/pos/templates/Role.Manager.xml} );
INSERT INTO ROLES(ID, NAME, PERMISSIONS) VALUES('2', 'Cashier role', $FILE{/com/posics/pos/templates/Role.Cashier.xml} );
INSERT INTO ROLES(ID, NAME, PERMISSIONS) VALUES('3', 'Guest role', $FILE{/com/posics/pos/templates/Role.Guest.xml} );

CREATE TABLE PEOPLE (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    APPPASSWORD VARCHAR(255) UNIQUE,
    CARD VARCHAR(255),
    ROLE VARCHAR(255) NOT NULL,
    VISIBLE SMALLINT NOT NULL,
    IMAGE BLOB,
    PRIMARY KEY (ID),
    CONSTRAINT PEOPLE_FK_1 FOREIGN KEY (ROLE) REFERENCES ROLES(ID)
);
CREATE UNIQUE INDEX PEOPLE_NAME_INX ON PEOPLE(NAME);
CREATE INDEX PEOPLE_CARD_INX ON PEOPLE(CARD);



INSERT INTO PEOPLE(ID, NAME, APPPASSWORD, ROLE, VISIBLE, IMAGE) VALUES ('0', 'Administrator', 'sha1:011C945F30CE2CBAFC452F39840F025693339C42', '0', 1, NULL);
INSERT INTO PEOPLE(ID, NAME, APPPASSWORD, ROLE, VISIBLE, IMAGE) VALUES ('1', 'Manager', 'sha1:FEA7F657F56A2A448DA7D4B535EE5E279CAF3D9A', '1', 1, NULL);
INSERT INTO PEOPLE(ID, NAME, APPPASSWORD, ROLE, VISIBLE, IMAGE) VALUES ('2', 'Cashier', 'sha1:F56D6351AA71CFF0DEBEA014D13525E42036187A', '2', 1, NULL);
INSERT INTO PEOPLE(ID, NAME, APPPASSWORD, ROLE, VISIBLE, IMAGE) VALUES ('3', 'Guest', NULL, '3', 0, NULL);

CREATE TABLE RESOURCES (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    RESTYPE INTEGER NOT NULL, 
    CONTENT BLOB,
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX RESOURCES_NAME_INX ON RESOURCES(NAME);
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('0', 'Printer.Start', 0, $FILE{/com/posics/pos/templates/Printer.Start.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('1', 'Printer.Ticket', 0, $FILE{/com/posics/pos/templates/Printer.Ticket.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('2', 'Printer.Ticket2', 0, $FILE{/com/posics/pos/templates/Printer.Ticket2.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('3', 'Printer.TicketPreview', 0, $FILE{/com/posics/pos/templates/Printer.TicketPreview.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('4', 'Printer.TicketTotal', 0, $FILE{/com/posics/pos/templates/Printer.TicketTotal.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('5', 'Printer.OpenDrawer', 0, $FILE{/com/posics/pos/templates/Printer.OpenDrawer.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('6', 'Printer.Ticket.Logo', 1, $FILE{/com/posics/pos/templates/Printer.Ticket.Logo.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('7', 'Printer.TicketLine', 0, $FILE{/com/posics/pos/templates/Printer.TicketLine.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('8', 'Printer.CloseCash', 0, $FILE{/com/posics/pos/templates/Printer.CloseCash.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('9', 'Window.Logo', 1, $FILE{/com/posics/pos/templates/Window.Logo.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('10', 'Window.Title', 0, $FILE{/com/posics/pos/templates/Window.Title.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('11', 'Ticket.Buttons', 0, $FILE{/com/posics/pos/templates/Ticket.Buttons.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('12', 'Ticket.Line', 0, $FILE{/com/posics/pos/templates/Ticket.Line.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('13', 'Printer.Inventory', 0, $FILE{/com/posics/pos/templates/Printer.Inventory.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('14', 'Menu.Root', 0, $FILE{/com/posics/pos/templates/Menu.Root.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('15', 'Printer.CustomerPaid', 0, $FILE{/com/posics/pos/templates/Printer.CustomerPaid.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('16', 'Printer.CustomerPaid2', 0, $FILE{/com/posics/pos/templates/Printer.CustomerPaid2.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('17', 'payment.cash', 0, $FILE{/com/posics/pos/templates/payment.cash.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('18', 'banknote.1000', 1, $FILE{/com/posics/pos/templates/banknote.1000.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('19', 'banknote.500', 1, $FILE{/com/posics/pos/templates/banknote.500.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('20', 'banknote.100', 1, $FILE{/com/posics/pos/templates/banknote.100.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('21', 'banknote.50', 1, $FILE{/com/posics/pos/templates/banknote.50.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('22', 'banknote.20', 1, $FILE{/com/posics/pos/templates/banknote.20.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('23', 'banknote.10', 1, $FILE{/com/posics/pos/templates/banknote.10.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('24', 'coin.5coin', 1, $FILE{/com/posics/pos/templates/coin.5coin.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('25', 'coin.2coin', 1, $FILE{/com/posics/pos/templates/coin.2coin.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('26', 'coin.1coin', 1, $FILE{/com/posics/pos/templates/coin.1coin.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('27', 'coin.50coin', 1, $FILE{/com/posics/pos/templates/coin.50coin.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('28', 'Printer.PartialCash', 0, $FILE{/com/posics/pos/templates/Printer.PartialCash.xml});

-- For Kitchen Order Printing
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('29', 'Script.SendOrder', 0, $FILE{/com/posics/pos/templates/Script.SendOrder.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('30', 'event.addline', 0, $FILE{/com/posics/pos/templates/event.addline.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('31', 'event.removeline', 0, $FILE{/com/posics/pos/templates/event.removeline.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('32', 'event.setline', 0, $FILE{/com/posics/pos/templates/event.setline.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('33', 'event.total', 0, $FILE{/com/posics/pos/templates/event.total.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('34', 'Printer.KOT1', 0, $FILE{/com/posics/pos/templates/Printer.KOT1.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('35', 'Printer.KOT1_Change', 0, $FILE{/com/posics/pos/templates/Printer.KOT1_Change.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('36', 'Printer.KOT2', 0, $FILE{/com/posics/pos/templates/Printer.KOT2.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('37', 'Printer.KOT2_Change', 0, $FILE{/com/posics/pos/templates/Printer.KOT2_Change.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('38', 'Printer.KOT3', 0, $FILE{/com/posics/pos/templates/Printer.KOT3.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('39', 'Printer.KOT3_Change', 0, $FILE{/com/posics/pos/templates/Printer.KOT3_Change.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('40', 'Examples', 0, $FILE{/com/posics/pos/templates/Examples.txt});

-- For Customer Discounts
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('41', 'Script.CustomerDiscount', 0, $FILE{/com/posics/pos/templates/Script.CustomerDiscount.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('42', 'Printer.Ticket.SpecialOffer.Logo', 1, $FILE{/com/posics/pos/templates/Printer.Ticket.SpecialOffer.Logo.png});

-- Receipt Note
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('43', 'Script.ReceiptNote', 0, $FILE{/com/posics/pos/templates/Script.ReceiptNote.txt});

-- Add Table to Receipt
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('44', 'Script.AddProperties', 0, $FILE{/com/posics/pos/templates/Script.AddProperties.txt});

-- Print Invoice Script
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('45', 'Script.PrintInvoice', 0, $FILE{/com/posics/pos/templates/Script.PrintInvoice.txt});

-- Discount on Total
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('46', 'Script.DiscountOnTotal', 0, $FILE{/com/posics/pos/templates/Script.DiscountOnTotal.txt});

-- Discount on Total
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('47', 'Script.Delivery', 0, $FILE{/com/posics/pos/templates/Script.Delivery.txt});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('48', 'Printer.Catalog', 0, $FILE{/com/posics/pos/templates/Printer.Catalog.xml});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('49', 'voucher.0', 1, $FILE{/com/posics/pos/templates/voucher.0.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('50', 'voucher.1', 1, $FILE{/com/posics/pos/templates/voucher.1.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('51', 'payment.voucher', 0, $FILE{/com/posics/pos/templates/payment.voucher.txt});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('52', 'voucher.2', 1, $FILE{/com/posics/pos/templates/voucher.2.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('53', 'payment.points', 0, $FILE{/com/posics/pos/templates/payment.points.txt});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('54', 'payment.receipt.tabs', 0, $FILE{/com/posics/pos/templates/payment.receipt.tabs.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('55', 'payment.refund.tabs', 0, $FILE{/com/posics/pos/templates/payment.refund.tabs.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('56', 'payment.customer.tabs', 0, $FILE{/com/posics/pos/templates/payment.customer.tabs.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('57', 'payment.supplier.tabs', 0, $FILE{/com/posics/pos/templates/payment.supplier.tabs.txt});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('58', 'payment.icon.cash', 1, $FILE{/com/posics/pos/templates/payment.icon.cash.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('59', 'payment.icon.cheque', 1, $FILE{/com/posics/pos/templates/payment.icon.cheque.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('60', 'payment.icon.voucher', 1, $FILE{/com/posics/pos/templates/payment.icon.voucher.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('61', 'payment.icon.card', 1, $FILE{/com/posics/pos/templates/payment.icon.card.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('62', 'payment.icon.free', 1, $FILE{/com/posics/pos/templates/payment.icon.free.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('63', 'payment.icon.debt', 1, $FILE{/com/posics/pos/templates/payment.icon.debt.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('64', 'payment.icon.points', 1, $FILE{/com/posics/pos/templates/payment.icon.points.png});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('65', 'event.delete', 0, $FILE{/com/posics/pos/templates/event.delete.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('66', 'Printer.Token', 0, $FILE{/com/posics/pos/templates/Printer.Token.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('67', 'Printer.CustomerDiary', 0, $FILE{/com/posics/pos/templates/Printer.CustomerDiary.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('68', 'Printer.DriverDiary', 0, $FILE{/com/posics/pos/templates/Printer.DriverDiary.xml});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('69', 'SQL.DeleteTransactions', 0, $FILE{/com/posics/pos/templates/SQL.DeleteTransactions.sql});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('70', 'SQL.BackupTables', 0, $FILE{/com/posics/pos/templates/SQL.BackupTables.sql});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('71', 'Printer.CloseCashMail', 0, $FILE{/com/posics/pos/templates/Printer.CloseCashMail.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('72', 'Printer.CustomerAdvancePaid', 0, $FILE{/com/posics/pos/templates/Printer.CustomerAdvancePaid.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('73', 'Printer.CustomerAdvancePaid2', 0, $FILE{/com/posics/pos/templates/Printer.CustomerAdvancePaid2.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('74', 'Printer.CloseCashExample', 0, $FILE{/com/posics/pos/templates/Printer.CloseCashExample.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('75', 'Printer.TicketExample', 0, $FILE{/com/posics/pos/templates/Printer.TicketExample.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('76', 'CloseCash.Reports', 0, $FILE{/com/posics/pos/templates/CloseCash.Reports.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('77', 'Printer.Label', 0, $FILE{/com/posics/pos/templates/Printer.Label.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('78', 'payment.icon.online', 1, $FILE{/com/posics/pos/templates/payment.icon.online.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('79', 'Printer.CloseCashBlind', 0, $FILE{/com/posics/pos/templates/Printer.CloseCashBlind.xml});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('80', 'POS.Reports', 0, $FILE{/com/posics/pos/templates/POS.Reports.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('81', 'POS.Report.SalesLog', 0, $FILE{/com/posics/pos/templates/POS.Report.SalesLog.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('82', 'POS.Report.Payments', 0, $FILE{/com/posics/pos/templates/POS.Report.Payments.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('83', 'POS.Report.CashClosed', 0, $FILE{/com/posics/pos/templates/POS.Report.CashClosed.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('84', 'POS.Report.CurrentInventory', 0, $FILE{/com/posics/pos/templates/POS.Report.CurrentInventory.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('85', 'POS.Report.ProductSales', 0, $FILE{/com/posics/pos/templates/POS.Report.ProductSales.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('86', 'Printer.OrderPreview', 0, $FILE{/com/posics/pos/templates/Printer.OrderPreview.xml});

CREATE TABLE TAXCUSTCATEGORIES (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX TAXCUSTCAT_NAME_INX ON TAXCUSTCATEGORIES(NAME);

CREATE TABLE CUSTOMERS (
    ID VARCHAR(255) NOT NULL,
    SEARCHKEY VARCHAR(255) NOT NULL,
    TAXID VARCHAR(255),
    NAME VARCHAR(255) NOT NULL,
    TAXCATEGORY VARCHAR(255),
    CARD VARCHAR(255),
    MAXDEBT DOUBLE DEFAULT 0 NOT NULL,
    ADDRESS VARCHAR(255),
    ADDRESS2 VARCHAR(255),
    POSTAL VARCHAR(255),
    CITY VARCHAR(255),
    REGION VARCHAR(255),
    COUNTRY VARCHAR(255),
    FIRSTNAME VARCHAR(255),
    LASTNAME VARCHAR(255),
    EMAIL VARCHAR(255),
    PHONE VARCHAR(255),
    PHONE2 VARCHAR(255),
    FAX VARCHAR(255),
    NOTES VARCHAR(255),
    VISIBLE SMALLINT DEFAULT 1 NOT NULL,
    CURDATE TIMESTAMP,
    CURDEBT DOUBLE,
    POINTS DOUBLE DEFAULT 0 NOT NULL,
    ADVANCE DOUBLE,
    ADVANCEDATE TIMESTAMP,
    PRIMARY KEY (ID),
    CONSTRAINT CUSTOMERS_TAXCAT FOREIGN KEY (TAXCATEGORY) REFERENCES TAXCUSTCATEGORIES(ID)
);
CREATE UNIQUE INDEX CUSTOMERS_SKEY_INX ON CUSTOMERS(SEARCHKEY);
CREATE INDEX CUSTOMERS_TAXID_INX ON CUSTOMERS(TAXID);
CREATE INDEX CUSTOMERS_NAME_INX ON CUSTOMERS(NAME);
CREATE INDEX CUSTOMERS_CARD_INX ON CUSTOMERS(CARD);

CREATE TABLE SUPPLIERS (
  ID VARCHAR(255) NOT NULL,
  SEARCHKEY VARCHAR(255) NOT NULL,
  TAXID VARCHAR(255) DEFAULT NULL,
  NAME VARCHAR(255) NOT NULL,
  TAXCATEGORY VARCHAR(255) DEFAULT NULL,
  CARD VARCHAR(255) DEFAULT NULL,
  MAXDEBT DOUBLE NOT NULL DEFAULT 0,
  ADDRESS VARCHAR(255) DEFAULT NULL,
  ADDRESS2 VARCHAR(255) DEFAULT NULL,
  POSTAL VARCHAR(255) DEFAULT NULL,
  CITY VARCHAR(255) DEFAULT NULL,
  REGION VARCHAR(255) DEFAULT NULL,
  COUNTRY VARCHAR(255) DEFAULT NULL,
  FIRSTNAME VARCHAR(255) DEFAULT NULL,
  LASTNAME VARCHAR(255) DEFAULT NULL,
  EMAIL VARCHAR(255) DEFAULT NULL,
  PHONE VARCHAR(255) DEFAULT NULL,
  PHONE2 VARCHAR(255) DEFAULT NULL,
  FAX VARCHAR(255) DEFAULT NULL,
  NOTES VARCHAR(255) DEFAULT NULL,
  VISIBLE SMALLINT DEFAULT 1 NOT NULL,
  CURDATE TIMESTAMP DEFAULT NULL,
  CURDEBT DOUBLE DEFAULT NULL,
  PRIMARY KEY (ID),
  CONSTRAINT SUPPLIERS_TAXCAT FOREIGN KEY (TAXCATEGORY) REFERENCES TAXCUSTCATEGORIES(ID)
);
CREATE UNIQUE INDEX SUPPLIERS_SKEY_INX ON SUPPLIERS(SEARCHKEY);
CREATE INDEX SUPPLIERS_TAXID_INX ON SUPPLIERS(TAXID);
CREATE INDEX SUPPLIERS_NAME_INX ON SUPPLIERS(NAME);
CREATE INDEX SUPPLIERS_CARD_INX ON SUPPLIERS(CARD);

CREATE TABLE CATEGORIES (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    PARENTID VARCHAR(255),
    IMAGE BLOB,
    PRIMARY KEY(ID),
    CONSTRAINT CATEGORIES_FK_1 FOREIGN KEY (PARENTID) REFERENCES CATEGORIES(ID)
);
CREATE UNIQUE INDEX CATEGORIES_NAME_INX ON CATEGORIES(NAME);
INSERT INTO CATEGORIES(ID, NAME, PARENTID, IMAGE) VALUES ('-1', 'Materials', null, null);
INSERT INTO CATEGORIES(ID, NAME, PARENTID, IMAGE) VALUES ('1', 'Standard', null, null);


CREATE TABLE TAXCATEGORIES (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX TAXCAT_NAME_INX ON TAXCATEGORIES(NAME);
INSERT INTO TAXCATEGORIES(ID, NAME) VALUES ('000', 'Tax Exempt');
INSERT INTO TAXCATEGORIES(ID, NAME) VALUES ('111', 'Tax 5%');
-- INSERT INTO TAXCATEGORIES(ID, NAME) VALUES ('-1', 'NOTAX');

CREATE TABLE TAXES (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    CATEGORY VARCHAR(255) NOT NULL,
    CUSTCATEGORY VARCHAR(255),
    PARENTID VARCHAR(255),
    RATE DOUBLE NOT NULL,
    RATECASCADE SMALLINT DEFAULT 0 NOT NULL,
    RATEORDER INTEGER,
    PRIMARY KEY(ID),
    CONSTRAINT TAXES_CAT_FK FOREIGN KEY (CATEGORY) REFERENCES TAXCATEGORIES(ID),
    CONSTRAINT TAXES_CUSTCAT_FK FOREIGN KEY (CUSTCATEGORY) REFERENCES TAXCUSTCATEGORIES(ID),
    CONSTRAINT TAXES_TAXES_FK FOREIGN KEY (PARENTID) REFERENCES TAXES(ID)
);
CREATE UNIQUE INDEX TAXES_NAME_INX ON TAXES(NAME);
INSERT INTO TAXES(ID, NAME, CATEGORY, CUSTCATEGORY, PARENTID, RATE, RATECASCADE, RATEORDER) VALUES ('000', 'Tax Exempt', '000', NULL, NULL, 0, 0, NULL);
INSERT INTO TAXES(ID, NAME, CATEGORY, CUSTCATEGORY, PARENTID, RATE, RATECASCADE, RATEORDER) VALUES ('111', 'Tax 5%', '111', NULL, NULL, 0.05, 0, NULL);
-- INSERT INTO TAXES(ID, NAME, CATEGORY, CUSTCATEGORY, PARENTID, RATE, RATECASCADE, RATEORDER) VALUES ('-1', 'NOTAX', '-1', NULL, NULL, 0, FALSE, NULL);

CREATE TABLE ATTRIBUTE (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    ATYPE SMALLINT, 
-- 0: Abc1 1:abc1 2:ABC1 3:123 4:Date 5:Select
    PRIMARY KEY (ID)
);

CREATE TABLE ATTRIBUTEVALUE (
    ID VARCHAR(255) NOT NULL,
    ATTRIBUTE_ID VARCHAR(255) NOT NULL,
    VALUE VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT ATTVAL_ATT FOREIGN KEY (ATTRIBUTE_ID) REFERENCES ATTRIBUTE(ID) ON DELETE CASCADE
);

CREATE TABLE ATTRIBUTESET (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);

CREATE TABLE ATTRIBUTEUSE (
    ID VARCHAR(255) NOT NULL,
    ATTRIBUTESET_ID VARCHAR(255) NOT NULL,
    ATTRIBUTE_ID VARCHAR(255) NOT NULL,
    LINENO INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT ATTUSE_SET FOREIGN KEY (ATTRIBUTESET_ID) REFERENCES ATTRIBUTESET(ID) ON DELETE CASCADE,
    CONSTRAINT ATTUSE_ATT FOREIGN KEY (ATTRIBUTE_ID) REFERENCES ATTRIBUTE(ID)
);
CREATE UNIQUE INDEX ATTUSE_LINE ON ATTRIBUTEUSE(ATTRIBUTESET_ID, LINENO);

CREATE TABLE ATTRIBUTESETINSTANCE (
    ID VARCHAR(255) NOT NULL,
    ATTRIBUTESET_ID VARCHAR(255) NOT NULL,
    DESCRIPTION VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT ATTSETINST_SET FOREIGN KEY (ATTRIBUTESET_ID) REFERENCES ATTRIBUTESET(ID) ON DELETE CASCADE
);

CREATE TABLE ATTRIBUTEINSTANCE (
    ID VARCHAR(255) NOT NULL,
    ATTRIBUTESETINSTANCE_ID VARCHAR(255) NOT NULL,
    ATTRIBUTE_ID VARCHAR(255) NOT NULL,
    VALUE VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT ATTINST_SET FOREIGN KEY (ATTRIBUTESETINSTANCE_ID) REFERENCES ATTRIBUTESETINSTANCE(ID) ON DELETE CASCADE,
    CONSTRAINT ATTINST_ATT FOREIGN KEY (ATTRIBUTE_ID) REFERENCES ATTRIBUTE(ID)
);

CREATE TABLE PRODUCTS (
    ID VARCHAR(255) NOT NULL,
    REFERENCE VARCHAR(255) NOT NULL,
    CODE VARCHAR(255) NOT NULL,
    CODETYPE VARCHAR(255),
    NAME VARCHAR(255) NOT NULL,
    PRICEBUY DOUBLE NOT NULL,
    PRICESELL DOUBLE NOT NULL,
    CATEGORY VARCHAR(255) NOT NULL,
    TAXCAT VARCHAR(255) NOT NULL,
    ATTRIBUTESET_ID VARCHAR(255),
    STOCKCOST DOUBLE,
    STOCKVOLUME DOUBLE,
    IMAGE BLOB,
    ISCOM SMALLINT DEFAULT 0 NOT NULL,
    ISSCALE SMALLINT DEFAULT 0 NOT NULL,
    ATTRIBUTES BLOB,
    INCAT SMALLINT DEFAULT 1 NOT NULL,
    CATORDER INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT PRODUCTS_FK_1 FOREIGN KEY (CATEGORY) REFERENCES CATEGORIES(ID),
    CONSTRAINT PRODUCTS_TAXCAT_FK FOREIGN KEY (TAXCAT) REFERENCES TAXCATEGORIES(ID),
    CONSTRAINT PRODUCTS_ATTRSET_FK FOREIGN KEY (ATTRIBUTESET_ID) REFERENCES ATTRIBUTESET(ID)
);
CREATE UNIQUE INDEX PRODUCTS_INX_0 ON PRODUCTS(REFERENCE);
CREATE UNIQUE INDEX PRODUCTS_INX_1 ON PRODUCTS(CODE);
CREATE UNIQUE INDEX PRODUCTS_NAME_INX ON PRODUCTS(NAME);

CREATE TABLE PRODUCTS_COM (
    ID VARCHAR(255) NOT NULL,
    PRODUCT VARCHAR(255) NOT NULL,
    PRODUCT2 VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT PRODUCTS_COM_FK_1 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT PRODUCTS_COM_FK_2 FOREIGN KEY (PRODUCT2) REFERENCES PRODUCTS(ID)
);
CREATE UNIQUE INDEX PCOM_INX_PROD ON PRODUCTS_COM(PRODUCT, PRODUCT2);

CREATE TABLE LOCATIONS (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    ADDRESS VARCHAR(255),
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX LOCATIONS_NAME_INX ON LOCATIONS(NAME);
INSERT INTO LOCATIONS(ID, NAME,ADDRESS) VALUES('0', 'General', NULL);

CREATE TABLE STOCKDIARY (
    ID VARCHAR(255) NOT NULL,
    DATENEW TIMESTAMP NOT NULL,
    REASON INTEGER NOT NULL, 
-- +1: stock.in.purchase +2: stock.in.refund +4: stock.in.movement +5: stock.in.production -1: stock.out.sale  -2: stock.out.refund -3: stock.out.break -4: stock.out.movement 999: stock.nil.request 1000: stock.out.crossing
    LOCATION VARCHAR(255) NOT NULL,
    PRODUCT VARCHAR(255) NOT NULL,
    ATTRIBUTESETINSTANCE_ID VARCHAR(255),
    UNITS DOUBLE NOT NULL,
    PRICE DOUBLE NOT NULL,
    SUPPLIER VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT STOCKDIARY_FK_1 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT STOCKDIARY_ATTSETINST FOREIGN KEY (ATTRIBUTESETINSTANCE_ID) REFERENCES ATTRIBUTESETINSTANCE(ID),
    CONSTRAINT STOCKDIARY_FK_2 FOREIGN KEY (LOCATION) REFERENCES LOCATIONS(ID)
);
CREATE INDEX STOCKDIARY_INX_1 ON STOCKDIARY(DATENEW);

CREATE TABLE STOCKLEVEL (
    ID VARCHAR(255) NOT NULL,
    LOCATION VARCHAR(255) NOT NULL,
    PRODUCT VARCHAR(255) NOT NULL,
    STOCKSECURITY DOUBLE,
    STOCKMAXIMUM DOUBLE,
    PRIMARY KEY (ID),
    CONSTRAINT STOCKLEVEL_PRODUCT FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT STOCKLEVEL_LOCATION FOREIGN KEY (LOCATION) REFERENCES LOCATIONS(ID)
 );

CREATE TABLE STOCKCURRENT (
    LOCATION VARCHAR(255) NOT NULL,
    PRODUCT VARCHAR(255) NOT NULL,
    ATTRIBUTESETINSTANCE_ID VARCHAR(255),
    UNITS DOUBLE NOT NULL,
    CONSTRAINT STOCKCURRENT_FK_1 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT STOCKCURRENT_ATTSETINST FOREIGN KEY (ATTRIBUTESETINSTANCE_ID) REFERENCES ATTRIBUTESETINSTANCE(ID),
    CONSTRAINT STOCKCURRENT_FK_2 FOREIGN KEY (LOCATION) REFERENCES LOCATIONS(ID)
);
CREATE UNIQUE INDEX STOCKCURRENT_INX ON STOCKCURRENT(LOCATION, PRODUCT, ATTRIBUTESETINSTANCE_ID);

CREATE TABLE CLOSEDCASH (
    MONEY VARCHAR(255) NOT NULL,
    HOST VARCHAR(255) NOT NULL,
    HOSTSEQUENCE INTEGER NOT NULL,
    DATESTART TIMESTAMP NOT NULL,
    DATEEND TIMESTAMP,
    ACTUALCASH DOUBLE,
    ACTUALCARD DOUBLE,
    NOTES VARCHAR(255),
    PRINTCOUNT INTEGER DEFAULT 0,
    PRIMARY KEY(MONEY)
);
CREATE INDEX CLOSEDCASH_INX_1 ON CLOSEDCASH(DATESTART);
CREATE UNIQUE INDEX CLOSEDCASH_INX_SEQ ON CLOSEDCASH(HOST, HOSTSEQUENCE);

CREATE TABLE ACCOUNTHEADS (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    PRIMARY KEY(ID)
);

INSERT INTO ACCOUNTHEADS VALUES('1', 'Sale');
INSERT INTO ACCOUNTHEADS VALUES('2', 'Purchase');

CREATE TABLE RECEIPTS (
    ID VARCHAR(255) NOT NULL,
    MONEY VARCHAR(255) NOT NULL,
    DATENEW TIMESTAMP NOT NULL,
    ATTRIBUTES BLOB,
    ACCOUNTHEAD VARCHAR(255) NOT NULL DEFAULT '1',
    PRIMARY KEY(ID),
    CONSTRAINT RECEIPTS_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY),
    CONSTRAINT RECEIPTS_FK_PHEAD FOREIGN KEY (ACCOUNTHEAD) REFERENCES ACCOUNTHEADS(ID)
);
CREATE INDEX RECEIPTS_INX_1 ON RECEIPTS(DATENEW);
CREATE INDEX RECEIPTS_MONEY_INX ON RECEIPTS(MONEY);

CREATE TABLE TICKETS (
    ID VARCHAR(255) NOT NULL,
    TICKETTYPE INTEGER DEFAULT 0 NOT NULL, 
-- 0: Sale 1: Refund 2: Customer Payment 3: Supplier Payment
    TICKETID INTEGER NOT NULL,
    PERSON VARCHAR(255) NOT NULL,
    CUSTOMER VARCHAR(255),
    SUPPLIER VARCHAR(255),
    STATUS INTEGER DEFAULT 0 NOT NULL, 
    PRIMARY KEY (ID),
    CONSTRAINT TICKETS_FK_ID FOREIGN KEY (ID) REFERENCES RECEIPTS(ID),
    CONSTRAINT TICKETS_FK_2 FOREIGN KEY (PERSON) REFERENCES PEOPLE(ID),
    CONSTRAINT TICKETS_CUSTOMERS_FK FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID),
    CONSTRAINT TICKETS_SUPPLIERS_FK FOREIGN KEY (SUPPLIER) REFERENCES SUPPLIERS(ID)
);
CREATE INDEX TICKETS_TICKETID ON TICKETS(TICKETTYPE, TICKETID);

CREATE TABLE TICKETSNUM (ID INTEGER NOT NULL);
INSERT INTO TICKETSNUM VALUES(0);

CREATE TABLE TICKETSNUM_REFUND (ID INTEGER NOT NULL);
INSERT INTO TICKETSNUM_REFUND VALUES(0);

CREATE TABLE TICKETSNUM_PAYMENT (ID INTEGER NOT NULL);
INSERT INTO TICKETSNUM_PAYMENT VALUES(0);

CREATE TABLE TICKETSNUM_SUPPLIER (ID INTEGER NOT NULL);
INSERT INTO TICKETSNUM_SUPPLIER VALUES(0);


CREATE TABLE TICKETLINES (
    TICKET VARCHAR(255) NOT NULL,
    LINE INTEGER NOT NULL,
    PRODUCT VARCHAR(255),
    ATTRIBUTESETINSTANCE_ID VARCHAR(255),
    UNITS DOUBLE NOT NULL,
    PRICE DOUBLE NOT NULL,
    TAXID VARCHAR(255) NOT NULL,
    ATTRIBUTES BLOB,
    PRIMARY KEY (TICKET, LINE),
    CONSTRAINT TICKETLINES_FK_TICKET FOREIGN KEY (TICKET) REFERENCES TICKETS(ID),
    CONSTRAINT TICKETLINES_FK_2 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT TICKETLINES_ATTSETINST FOREIGN KEY (ATTRIBUTESETINSTANCE_ID) REFERENCES ATTRIBUTESETINSTANCE(ID),
    CONSTRAINT TICKETLINES_FK_3 FOREIGN KEY (TAXID) REFERENCES TAXES(ID)
);

CREATE TABLE PAYMENTS (
    ID VARCHAR(255) NOT NULL,
    RECEIPT VARCHAR(255) NOT NULL,
    PAYMENT VARCHAR(255) NOT NULL, 
-- cash, cashin, cashout, cheque, voucher, points, card, free, debt, debtpaid, creditpaid, currency, advance, advancepaid
    TOTAL DOUBLE NOT NULL,
    TRANSID VARCHAR(255),
    RETURNMSG BLOB,
    NOTES VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT PAYMENTS_FK_RECEIPT FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS(ID)
);
CREATE INDEX PAYMENTS_INX_1 ON PAYMENTS(PAYMENT);
CREATE INDEX PAYMENTS_RECEIPT_INX ON PAYMENTS(RECEIPT);

CREATE TABLE TAXLINES (
    ID VARCHAR(255) NOT NULL,
    RECEIPT VARCHAR(255) NOT NULL,
    TAXID VARCHAR(255) NOT NULL, 
    BASE DOUBLE NOT NULL, 
    AMOUNT DOUBLE NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT TAXLINES_TAX FOREIGN KEY (TAXID) REFERENCES TAXES(ID),
    CONSTRAINT TAXLINES_RECEIPT FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS(ID)
);
CREATE INDEX TAXLINES_RECEIPT_INX ON TAXLINES(RECEIPT);

CREATE TABLE FLOORS (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    IMAGE BLOB,
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX FLOORS_NAME_INX ON FLOORS(NAME);
INSERT INTO FLOORS(ID, NAME, IMAGE) VALUES ('0', 'Restaurant floor', $FILE{/com/posics/pos/templates/restaurantsample.png});

CREATE TABLE PLACES (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER NOT NULL,
    FLOOR VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT PLACES_FK_1 FOREIGN KEY (FLOOR) REFERENCES FLOORS(ID)
);
CREATE UNIQUE INDEX PLACES_NAME_INX ON PLACES(NAME);
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('1', 'Table 1', 133, 151, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('2', 'Table 2', 532, 151, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('3', 'Table 3', 133, 264, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('4', 'Table 4', 266, 264, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('5', 'Table 5', 399, 264, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('6', 'Table 6', 532, 264, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('7', 'Table 7', 133, 377, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('8', 'Table 8', 266, 377, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('9', 'Table 9', 399, 377, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('10', 'Table 10', 532, 377, '0');

CREATE TABLE RESERVATIONS (
    ID VARCHAR(255) NOT NULL,
    CREATED TIMESTAMP NOT NULL,
    DATENEW TIMESTAMP DEFAULT '2001-01-01 00:00:00' NOT NULL,
    TITLE VARCHAR(255) NOT NULL,
    CHAIRS INTEGER NOT NULL,
    ISDONE SMALLINT NOT NULL,
    DESCRIPTION VARCHAR(255),
    PRIMARY KEY (ID)
);
CREATE INDEX RESERVATIONS_INX_1 ON RESERVATIONS(DATENEW);

CREATE TABLE RESERVATION_CUSTOMERS (
    ID VARCHAR(255) NOT NULL,
    CUSTOMER VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT RES_CUST_FK_1 FOREIGN KEY (ID) REFERENCES RESERVATIONS(ID),
    CONSTRAINT RES_CUST_FK_2 FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID)
);

CREATE TABLE SHAREDTICKETS (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    CONTENT BLOB,
    BMODE SMALLINT DEFAULT 0 NOT NULL,
    LOCKED VARCHAR(255),
    PRIMARY KEY(ID)
);

CREATE TABLE  UNITS(
  ID varchar(255) NOT NULL,
  NAME varchar(255) NOT NULL,
  SYMBOL varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX UNITS_NAME_INX ON UNITS(NAME);

INSERT INTO UNITS VALUES('1', 'Centimeter', 'cm');
INSERT INTO UNITS VALUES('2', 'Foot', 'ft');
INSERT INTO UNITS VALUES('3', 'Gram', 'gm');
INSERT INTO UNITS VALUES('4', 'Inch', 'in');
INSERT INTO UNITS VALUES('5', 'Kilogram', 'Kg');
INSERT INTO UNITS VALUES('6', 'Liter', 'L');
INSERT INTO UNITS VALUES('7', 'Meter', 'm');
INSERT INTO UNITS VALUES('8', 'Milligram', 'mg');
INSERT INTO UNITS VALUES('9', 'Milliliter', 'ml');
INSERT INTO UNITS VALUES('10', 'Millimeter', 'mm');
INSERT INTO UNITS VALUES('11', 'Numbers', 'Nos');
INSERT INTO UNITS VALUES('12', 'Piece', 'Pc');

CREATE TABLE  PRODUCTS_MAT (
  PRODUCT varchar(255) NOT NULL,
  MATERIAL varchar(255) NOT NULL,
  AMOUNT double NOT NULL,
  PRIMARY KEY (PRODUCT,MATERIAL),
  CONSTRAINT PROD_MAT_FK_1 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS (ID),
  CONSTRAINT PROD_MAT_FK_2 FOREIGN KEY (MATERIAL) REFERENCES PRODUCTS (ID)
);
CREATE INDEX PROD_MAT_FK_2 ON PRODUCTS_MAT(MATERIAL);

CREATE TABLE  MATERIALS_UNITS (
  MATERIAL varchar(255) NOT NULL,
  UNIT varchar(255) NOT NULL,
  AMOUNT double NOT NULL,
  PRICEBUY double NOT NULL,
  PRIMARY KEY (MATERIAL,UNIT),
  CONSTRAINT MAT_UNIT_FK_1 FOREIGN KEY (MATERIAL) REFERENCES PRODUCTS (ID),
  CONSTRAINT MAT_UNIT_FK_2 FOREIGN KEY (UNIT) REFERENCES UNITS (ID)
);
CREATE INDEX MAT_UNIT_FK_2 ON MATERIALS_UNITS(UNIT);

CREATE TABLE TARIFFAREAS (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    TARIFFORDER INTEGER DEFAULT 0,
    PRIMARY KEY(ID)
);
CREATE UNIQUE INDEX TARIFFAREAS_NAME_INX ON TARIFFAREAS(NAME);

CREATE TABLE TARIFFAREAS_PROD (
    TARIFFID VARCHAR(255) NOT NULL,
    PRODUCTID VARCHAR(255) NOT NULL,
    PRICESELL DOUBLE NOT NULL,
    PRIMARY KEY (TARIFFID, PRODUCTID),
    CONSTRAINT TARIFFAREAS_PROD_FK_1 FOREIGN KEY (TARIFFID) REFERENCES TARIFFAREAS(ID) ON DELETE CASCADE,
    CONSTRAINT TARIFFAREAS_PROD_FK_2 FOREIGN KEY (PRODUCTID) REFERENCES PRODUCTS(ID) ON DELETE CASCADE
);

CREATE TABLE BANKS (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    CODE VARCHAR(255) NOT NULL,
    PRIMARY KEY(ID)
);
CREATE UNIQUE INDEX BANKS_NAME_INX ON BANKS(NAME);


--
-- SCRIPTS FOR WEBIN
--


-- TABLES FOR WEBIN

CREATE TABLE PRODUCTGROUPS (
  ID VARCHAR(255) NOT NULL,
  NAME VARCHAR(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX PRODUCTGROUPS_NAME_INX ON PRODUCTGROUPS(NAME);

CREATE TABLE PRODUCTGROUPS_PROD (
  PRODUCTGROUP VARCHAR(255) NOT NULL,
  PRODUCT VARCHAR(255) NOT NULL,
  PRIMARY KEY (PRODUCTGROUP,PRODUCT),
  CONSTRAINT PRODUCTGROUPS_PROD_FK_2 FOREIGN KEY (PRODUCTGROUP) REFERENCES PRODUCTGROUPS (ID),
  CONSTRAINT PRODUCTGROUPS_FK_3 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS (ID)
);

CREATE TABLE STOCKDIARY_GRN (
    STOCKDIARYID VARCHAR(255) NOT NULL,
    GRNUMBER INT NOT NULL,
    REFID VARCHAR(255) NOT NULL,
    CONSTRAINT PO_GRN_ML_FK_2 FOREIGN KEY (STOCKDIARYID) REFERENCES STOCKDIARY(ID)
);

CREATE TABLE COMPANYINFO(
    ID VARCHAR(255) NOT NULL,
    COMPANYNAME VARCHAR(255) NOT NULL,
    ADDRESS1 VARCHAR(255),
    ADDRESS2 VARCHAR(255),
    POSTAL VARCHAR(255),
    CITY VARCHAR(255),
    REGION VARCHAR(255),
    COUNTRY VARCHAR(255),
    PHONE1 VARCHAR(255),
    PHONE2 VARCHAR(255),
    FAX VARCHAR(255),
    EMAIL VARCHAR(255),
    WEBSITE VARCHAR(255),
    CURRENCY VARCHAR(10),
    TAXID VARCHAR(255),
    DISPLAYLOGO BLOB,
    PRINTLOGO BLOB,
    PRIMARY KEY (ID)
);

INSERT INTO COMPANYINFO (ID, COMPANYNAME, ADDRESS1, ADDRESS2, CITY, POSTAL, REGION, COUNTRY, PHONE1, PHONE2, EMAIL, WEBSITE) VALUES('0', 'Posics Technologies', 'Address1', 'Address2', 'City', '123456', 'State', 'Country', '01234', '01234', 'info@posics.com', 'www.posics.com');

CREATE TABLE LOCATIONS_PROD (
  LOCATION varchar(255) NOT NULL,
  PRODUCT varchar(255) NOT NULL,
  PRIMARY KEY (LOCATION,PRODUCT),
  CONSTRAINT LOCATIONS_FK_3 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS (ID),
  CONSTRAINT LOCATIONS_PROD_FK_2 FOREIGN KEY (LOCATION) REFERENCES LOCATIONS (ID)
);
CREATE INDEX LOCATIONS_FK_3 ON LOCATIONS_PROD(PRODUCT);

CREATE TABLE PRODUCT_LABEL_DIMENSIONS (
ID varchar(255) NOT NULL,
DIMENSIONNAME varchar(255) NOT NULL,
PAGEWIDTH SMALLINT,
PAGEHEIGHT SMALLINT,
LEFTMARGIN SMALLINT,
TOPMARGIN SMALLINT,
NUMBEROFCOLUMNS SMALLINT,
LABELWIDTH SMALLINT,
LABELHEIGHT SMALLINT,
HORIZONTALGAP SMALLINT,
VERTICALGAP SMALLINT,
PRIMARY KEY (ID)
);

CREATE TABLE PRODUCT_LABELS (
ID varchar(255) NOT NULL,
PRODUCT varchar(255) NOT NULL,
DIMENSION varchar(255) NOT NULL,
TITLE varchar(255),
QUANTITY DOUBLE,
INGREDIENTS varchar(255) NOT NULL,
INSTRUCTION varchar(255) NOT NULL,
LINE1 varchar(255) NOT NULL,
LINE2 varchar(255) NOT NULL,
LINE3 varchar(255) NOT NULL,
PRIMARY KEY (ID),
CONSTRAINT LABELS_FK_1 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS (ID),
CONSTRAINT LABELS_FK_2 FOREIGN KEY (DIMENSION) REFERENCES PRODUCT_LABEL_DIMENSIONS (ID)
);

CREATE TABLE REPORTS(
ID INT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
REPORTNAME VARCHAR(255) NOT NULL,
CONTENT BLOB,
PRIMARY KEY (ID)
); 


-- WEBIN DEFAULT ROLE AND USER

INSERT INTO ROLES(ID, NAME, PERMISSIONS) VALUES('501', 'Webadmin', $FILE{/com/posics/pos/templates/webin/Role.Webadmin.xml} );
INSERT INTO PEOPLE(ID, NAME, APPPASSWORD, ROLE, VISIBLE, IMAGE) VALUES ('501', 'webadmin', 'sha1:5BAA61E4C9B93F3F0682250B6CF8331B7EE68FD8', '501', 0, NULL);


-- WEBIN RESOURCES

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('501', 'Webin.Menu',0, $FILE{/com/posics/pos/templates/webin/Resource.Webmenu.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('502', 'label.sizes',0,$FILE{/com/posics/pos/templates/webin/Resource.label.sizes.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('503', 'label.formats',0,$FILE{/com/posics/pos/templates/webin/Resource.label.formats.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('504', 'Webin.Dashboard.Databoxes',0,$FILE{/com/posics/pos/templates/webin/Resource.Databoxes.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('505', 'Webin.Reports',0,$FILE{/com/posics/pos/templates/webin/Resource.Webin.Reports.xml});

-- WEBIN REPORTS
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Account Summary',$FILE{/com/posics/pos/templates/webin/Report.AccountSummary.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Category Sales',$FILE{/com/posics/pos/templates/webin/Report.CategorySales.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Closed Cash',$FILE{/com/posics/pos/templates/webin/Report.ClosedCash.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Current Inventory',$FILE{/com/posics/pos/templates/webin/Report.CurrentInventory.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Customer Diary',$FILE{/com/posics/pos/templates/webin/Report.CustomerDiary.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Customers List',$FILE{/com/posics/pos/templates/webin/Report.Customers.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Customers Defaulting',$FILE{/com/posics/pos/templates/webin/Report.CustomersDefaulting.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Expenses',$FILE{/com/posics/pos/templates/webin/Report.Expenses.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Expenses Summary',$FILE{/com/posics/pos/templates/webin/Report.ExpensesSummary.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Inventory Broken',$FILE{/com/posics/pos/templates/webin/Report.InventoryBroken.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'NonPopular Products',$FILE{/com/posics/pos/templates/webin/Report.NonPopularProducts.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Payments',$FILE{/com/posics/pos/templates/webin/Report.Payments.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Popular Products',$FILE{/com/posics/pos/templates/webin/Report.PopularProducts.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Product Purchase',$FILE{/com/posics/pos/templates/webin/Report.ProductPurchase.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Product Purchase Details',$FILE{/com/posics/pos/templates/webin/Report.ProductPurchaseDetails.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Product Sales',$FILE{/com/posics/pos/templates/webin/Report.ProductSales.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Product Sales Log',$FILE{/com/posics/pos/templates/webin/Report.ProductSalesLog.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Products List',$FILE{/com/posics/pos/templates/webin/Report.Products.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Purchase By Tax And Category',$FILE{/com/posics/pos/templates/webin/Report.PurchaseByTaxAndCategory.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Purchase Invoice',$FILE{/com/posics/pos/templates/webin/Report.PurchaseInvoice.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Purchase Log',$FILE{/com/posics/pos/templates/webin/Report.PurchaseLog.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Purchase Tax Log',$FILE{/com/posics/pos/templates/webin/Report.PurchaseTaxLog.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Purchase Tax Log Summary',$FILE{/com/posics/pos/templates/webin/Report.PurchaseTaxLogSummary.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Sales By Tax And Category',$FILE{/com/posics/pos/templates/webin/Report.SalesByTaxAndCategory.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Sales By User',$FILE{/com/posics/pos/templates/webin/Report.SalesByUser.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Sales Log',$FILE{/com/posics/pos/templates/webin/Report.SalesLog.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Sales Tax Log',$FILE{/com/posics/pos/templates/webin/Report.SalesTaxLog.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Sales Tax Log Summary',$FILE{/com/posics/pos/templates/webin/Report.SalesTaxLogSummary.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Stock Diary',$FILE{/com/posics/pos/templates/webin/Report.StockDiary.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Supplier Diary',$FILE{/com/posics/pos/templates/webin/Report.SupplierDiary.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Suppliers List',$FILE{/com/posics/pos/templates/webin/Report.Suppliers.xml});
INSERT INTO REPORTS( REPORTNAME, CONTENT) VALUES( 'Suppliers Defaulting',$FILE{/com/posics/pos/templates/webin/Report.SuppliersDefaulting.xml});

-- DELIVERY MODULE
CREATE TABLE CALLS (
    ID VARCHAR(255) NOT NULL,
    CALLERID VARCHAR(255) NOT NULL,
    DATENEW TIMESTAMP NOT NULL,
    LINEID VARCHAR(255),
    CUSTOMER VARCHAR(255),
    MONEY VARCHAR(255) NOT NULL,
    STATUS SMALLINT DEFAULT 0 NOT NULL, 
-- 0: IN COMING 1: ORDER TAKEN 2: BILL GENERATED 3: DELIVERED
    PRIMARY KEY (ID),
    CONSTRAINT CALLS_CUSTOMERS_FK FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID),
    CONSTRAINT CALLS_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY)
);


CREATE TABLE DRIVERS (
    ID VARCHAR(255) NOT NULL,
    DRIVERNAME VARCHAR(255) NOT NULL,
    CODE VARCHAR(255) NOT NULL,
    PRIMARY KEY(ID)
);

CREATE TABLE DELIVERYORDERS (
    ID VARCHAR(255) NOT NULL,
    CALLID VARCHAR(255),
    DRIVERID VARCHAR(255),
    RECEIPT VARCHAR(255),
    ORDERTYPE SMALLINT,
    DELIVERYDATE TIMESTAMP,
    PAYMENT VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT DRV_FK_1 FOREIGN KEY (DRIVERID) REFERENCES DRIVERS(ID),
    CONSTRAINT RECPT_FK_1 FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS(ID)
);

CREATE TABLE LINESREMOVED (
    ID VARCHAR(255) NOT NULL,
    MONEY VARCHAR(255) NOT NULL,
    DATENEW TIMESTAMP NOT NULL,
    TICKETID INTEGER,
    PRODUCT VARCHAR(255) NOT NULL,
    UNITS DOUBLE NOT NULL,
    PRICE DOUBLE NOT NULL,
    ATTRIBUTES BLOB,
    PERSON VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT REMOVEDLINES_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY)
);

CREATE TABLE CONFIGURATION(
POTERMS VARCHAR(255),
NEXTREQNO INT,
NEXTPONO INT,
NEXTGRNO INT,
NEXTBARCODE INT,
COUNTRY VARCHAR(8),
FORMATINTEGER VARCHAR(20),
FORMATDOUBLE VARCHAR(20),
FORMATCURRENCY VARCHAR(20),
FORMATPERCENT VARCHAR(20),
FORMATDATE VARCHAR(45),
FORMATTIME VARCHAR(45),
FORMATTIMESTAMP VARCHAR(45)
);
INSERT INTO CONFIGURATION VALUES('Supplier shall issue accurate invoices to Buyer for Goods.\nShipments must be made to meet the date specified in the Purchase Order.', 1, 1, 1, 10001, 'en_US', '#0', '#0.0', '#0.00', '#0%', 'd-m-Y', 'h:i', 'd-m-Y h:i');

CREATE TABLE ACCOUNTS(
    ID VARCHAR(255) NOT NULL,
    ACCOUNT_NAME VARCHAR(255) NOT NULL,
    ACCOUNT_NUMBER VARCHAR(255),
    INITIAL_BALANCE DOUBLE NOT NULL,
    AVAILABLE_BALANCE DOUBLE NOT NULL,
    PRIMARY KEY (ID) 
) ;
INSERT INTO ACCOUNTS (ID, ACCOUNT_NAME, ACCOUNT_NUMBER, INITIAL_BALANCE, AVAILABLE_BALANCE) VALUES ('PURCHASE', 'PURCHASE', 'PURCHASE', 0, 0);
INSERT INTO ACCOUNTS (ID, ACCOUNT_NAME, ACCOUNT_NUMBER, INITIAL_BALANCE, AVAILABLE_BALANCE) VALUES ('SALE', 'SALE', 'SALE', 0, 0);


CREATE TABLE PAYMENTHEADS (
  ID VARCHAR(255) NOT NULL,
  PAYMENTHEAD VARCHAR(255) NOT NULL,
  PRIMARY KEY (ID)
);
INSERT INTO PAYMENTHEADS (ID, PAYMENTHEAD) VALUES ('DEPOSIT', 'DEPOSIT');
INSERT INTO PAYMENTHEADS (ID, PAYMENTHEAD) VALUES ('PURCHASE', 'PURCHASE');
INSERT INTO PAYMENTHEADS (ID, PAYMENTHEAD) VALUES ('PURCHASERETURN', 'PURCHASE RETURN');

CREATE TABLE TRANSACTIONS (
  ID VARCHAR(255) NOT NULL,
  TRANSACTION_DATE TIMESTAMP NOT NULL,
  TRANSACTION_TYPE_ID SMALLINT NOT NULL,
-- 0. Deposit 1. Withdrawal
  ACCOUNT_ID VARCHAR(255) NOT NULL,
  PAYMENTHEAD_ID VARCHAR(255) NOT NULL,
  AMOUNT DOUBLE NOT NULL,
  COMMENTS VARCHAR(1024),
  STATUS SMALLINT NOT NULL,
-- 0-Created, 1-Approved, 2-Rejected
  CREATED TIMESTAMP NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  APPROVED TIMESTAMP NOT NULL,
  APPROVED_BY VARCHAR(255) NOT NULL,
  PRIMARY KEY (ID),
  CONSTRAINT TRANSACTIONS_FK_1 FOREIGN KEY (ACCOUNT_ID) REFERENCES ACCOUNTS(ID),
  CONSTRAINT TRANSACTIONS_FK_2 FOREIGN KEY (PAYMENTHEAD_ID) REFERENCES PAYMENTHEADS(ID),
  CONSTRAINT TRANSACTIONS_FK_3 FOREIGN KEY (CREATED_BY) REFERENCES PEOPLE(ID),
  CONSTRAINT TRANSACTIONS_FK_4 FOREIGN KEY (APPROVED_BY) REFERENCES PEOPLE(ID)
) ;

CREATE TABLE PURCHASEINVOICE(
    ID VARCHAR(255) NOT NULL,
    REFERENCE VARCHAR(255),
    SUPPLIERID VARCHAR(255),
    DELIVERYDATE TIMESTAMP,
    COMMENTS VARCHAR(1024),
    FREIGHTAMOUNT DOUBLE,
    DISCOUNT DOUBLE,
    ADJUSTMENT DOUBLE,
    CREATEDBY VARCHAR(255) NOT NULL,
    CREATEDDATE TIMESTAMP NOT NULL,
    APPROVEDBY VARCHAR(255),
    APPROVEDDATE TIMESTAMP,
    STATUS SMALLINT,
    -- 1. Created 2. Submitted 3. Partially Paid 4. Paid 5. Rejected -2. Purchase Return Submitted
    PRIMARY KEY (ID),
    CONSTRAINT PI_EMP_FK_1 FOREIGN KEY (CREATEDBY) REFERENCES PEOPLE(ID),
    CONSTRAINT PI_EMP_FK_2 FOREIGN KEY (APPROVEDBY) REFERENCES PEOPLE(ID),
    CONSTRAINT PI_SU_FK_3 FOREIGN KEY (SUPPLIERID) REFERENCES SUPPLIERS(ID)
);

CREATE TABLE PURCHASEINVOICELINES (
    ID VARCHAR(255) NOT NULL,
    PIID VARCHAR(255) NOT NULL,
    PRODUCT VARCHAR(255) NOT NULL,    
    DESCRIPTION VARCHAR(255),
    QUANTITY DOUBLE,
    UNITPRICE DOUBLE NOT NULL,
    TAXID VARCHAR(255) NOT NULL,
    DISCOUNT DOUBLE ,
    PRIMARY KEY (ID),
    CONSTRAINT PIL_PI_FK_1 FOREIGN KEY (PIID) REFERENCES PURCHASEINVOICE(ID),
    CONSTRAINT PIL_PRO_FK_2 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT PIL_TAX_FK_3 FOREIGN KEY (TAXID) REFERENCES TAXES(ID)
);

CREATE TABLE PURCHASEINVOICETAXES (
    ID VARCHAR(255) NOT NULL,
    PIID VARCHAR(255) NOT NULL,
    TAXID VARCHAR(255) NOT NULL,
    BASEAMOUNT DOUBLE NOT NULL,
    TAXAMOUNT DOUBLE NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT PILT_PI_FK_1 FOREIGN KEY (PIID) REFERENCES PURCHASEINVOICE(ID),
    CONSTRAINT PILT_TAX_FK_2 FOREIGN KEY (TAXID) REFERENCES TAXES(ID)
);

CREATE TABLE PURCHASEINVOICE_PAYMENTS (
  ID VARCHAR(255) NOT NULL,
  PURCHASEINVOICE_ID VARCHAR(255) NOT NULL,
  TRANSACTION_ID VARCHAR(255) NOT NULL,
  PRIMARY KEY (ID),
  CONSTRAINT PURCHASE__FK_1 FOREIGN KEY (PURCHASEINVOICE_ID) REFERENCES PURCHASEINVOICE(ID),
  CONSTRAINT PPAYMENTS_FK_2 FOREIGN KEY (TRANSACTION_ID) REFERENCES TRANSACTIONS(ID)
);

CREATE TABLE ONLINEORDERS (
  ID VARCHAR(255) NOT NULL,
  CREATED_AT TIMESTAMP NOT NULL,
  MONEY VARCHAR(255) NOT NULL,
  PORTAL VARCHAR(255) NOT NULL,
  ORDERID INTEGER NOT NULL,
  ORDERCONTENT VARCHAR(16000) NOT NULL,
  ORDERED_AT TIMESTAMP,
  ACCEPTED_AT TIMESTAMP,
  PREPARED_AT TIMESTAMP,
  ASSIGNED_AT TIMESTAMP,
  PICKED_AT TIMESTAMP,
  DELIVERED_AT TIMESTAMP,
  REJECTED_AT TIMESTAMP,
  STATUS SMALLINT NOT NULL DEFAULT 0,
  RECEIPT VARCHAR(255),
  PRIMARY KEY (ID),
  CONSTRAINT OO_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH (MONEY),
  CONSTRAINT OO_FK_RECEIPT FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS (ID)
);


CREATE TABLE CUSTOMERS_ADDRESS (
    ID VARCHAR(255) NOT NULL,
    CUSTOMER VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    ADDRESS VARCHAR(255),
    PHONE VARCHAR(255),
    LATITUDE VARCHAR(255),
    LONGITUDE VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT ADDRESS_CUSTOMER FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID)
);

CREATE TABLE APPORDERS (
  ID varchar(255) NOT NULL,
  CREATED_AT TIMESTAMP NOT NULL,
  MONEY varchar(255) ,
  DEVICEID varchar(255) NOT NULL,
  WAITERID varchar(255) NOT NULL,
  TABLEID varchar(255) NOT NULL,
  ORDERCONTENT VARCHAR(1024) NOT NULL,
  AMOUNT DOUBLE NOT NULL,
  STATUS SMALLINT DEFAULT 0 NOT NULL,
  RECEIPT varchar(255),
  TICKETID INTEGER,
  PRIMARY KEY (ID),
  CONSTRAINT AO_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH (MONEY),
  CONSTRAINT AO_FK_RECEIPT FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS (ID)
);
