UPDATE APPLICATIONS SET VERSION=4.3 WHERE ID=$APP_ID{};


--
-- SCRIPTS FOR WEBIN
--


UPDATE PEOPLE SET APPPASSWORD=null;
ALTER TABLE PEOPLE ADD UNIQUE (APPPASSWORD);
UPDATE PEOPLE SET APPPASSWORD='sha1:011C945F30CE2CBAFC452F39840F025693339C42' WHERE ROLE=0 LIMIT 1;

DELETE FROM SHAREDTICKETS;

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('65', 'event.delete', 0, $FILE{/com/posics/pos/templates/event.delete.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('66', 'Printer.Token', 0, $FILE{/com/posics/pos/templates/Printer.Token.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('67', 'Printer.CustomerDiary', 0, $FILE{/com/posics/pos/templates/Printer.CustomerDiary.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('68', 'Printer.DriverDiary', 0, $FILE{/com/posics/pos/templates/Printer.DriverDiary.xml});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('69', 'SQL.DeleteTransactions', 0, $FILE{/com/posics/pos/templates/SQL.DeleteTransactions.sql});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('70', 'SQL.BackupTables', 0, $FILE{/com/posics/pos/templates/SQL.BackupTables.sql});

-- TABLES FOR WEBIN

CREATE TABLE PRODUCTGROUPS (
  ID VARCHAR(255) NOT NULL,
  NAME VARCHAR(255) NOT NULL,
  PRIMARY KEY (ID),
  UNIQUE KEY PRODUCTGROUPS_NAME_INX (NAME)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE PRODUCTGROUPS_PROD (
  PRODUCTGROUP VARCHAR(255) NOT NULL,
  PRODUCT VARCHAR(255) NOT NULL,
  PRIMARY KEY (PRODUCTGROUP,PRODUCT),
  CONSTRAINT PRODUCTGROUPS_PROD_FK_2 FOREIGN KEY (PRODUCTGROUP) REFERENCES PRODUCTGROUPS (ID),
  CONSTRAINT PRODUCTGROUPS_FK_3 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE STOCKDIARY_GRN (
    STOCKDIARYID VARCHAR(255) NOT NULL,
    GRNUMBER INT NOT NULL,
    REFID VARCHAR(255) NOT NULL,
    CONSTRAINT PO_GRN_ML_FK_2 FOREIGN KEY (STOCKDIARYID) REFERENCES STOCKDIARY(ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE COMPANYINFO(
    ID VARCHAR(255) NOT NULL,
    COMPANYNAME VARCHAR(255) NOT NULL,
    ADDRESS1 VARCHAR(255) NULL,
    ADDRESS2 VARCHAR(255) NULL,
    POSTAL VARCHAR(255) NULL,
    CITY VARCHAR(255) NULL,
    REGION VARCHAR(255) NULL,
    COUNTRY VARCHAR(255) NULL,
    PHONE1 VARCHAR(255) NULL,
    PHONE2 VARCHAR(255) NULL,
    FAX VARCHAR(255) NULL,
    EMAIL VARCHAR(255) NULL,
    WEBSITE VARCHAR(255) NULL,
    CURRENCY VARCHAR(10) NULL,
    TAXID VARCHAR(255) NULL,
    DISPLAYLOGO MEDIUMBLOB NULL,
    PRINTLOGO MEDIUMBLOB NULL,
    PRIMARY KEY (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO COMPANYINFO (ID, COMPANYNAME, ADDRESS1, ADDRESS2, CITY, POSTAL, REGION, COUNTRY, PHONE1, PHONE2, EMAIL, WEBSITE) VALUES('0', 'Posics Technologies', 'Address1', 'Address2', 'City', '123456', 'State', 'Country', '01234', '01234', 'info@posics.com', 'www.posics.com');

CREATE TABLE CONFIGURATION(
POTERMS VARCHAR(255) NULL,
NEXTREQNO INT NULL DEFAULT 1,
NEXTPONO INT NULL DEFAULT 1,
NEXTGRNO INT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO CONFIGURATION (POTERMS, NEXTREQNO, NEXTPONO, NEXTGRNO) VALUES('Supplier shall issue accurate invoices to Buyer for Goods.\nShipments must be made to meet the date specified in the Purchase Order.', 1, 1, 1);


CREATE TABLE `LOCATIONS_PROD` (
  `LOCATION` varchar(255) NOT NULL,
  `PRODUCT` varchar(255) NOT NULL,
  PRIMARY KEY (`LOCATION`,`PRODUCT`),
  KEY `LOCATIONS_FK_3` (`PRODUCT`),
  CONSTRAINT `LOCATIONS_FK_3` FOREIGN KEY (`PRODUCT`) REFERENCES `PRODUCTS` (`ID`),
  CONSTRAINT `LOCATIONS_PROD_FK_2` FOREIGN KEY (`LOCATION`) REFERENCES `LOCATIONS` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE PRODUCT_LABEL_DIMENSIONS (
ID varchar(255) NOT NULL,
DIMENSIONNAME varchar(255) NOT NULL,
PAGEWIDTH SMALLINT,
PAGEHEIGHT SMALLINT,
LEFTMARGIN SMALLINT,
TOPMARGIN SMALLINT,
NUMBEROFCOLUMNS SMALLINT,
LABELWIDTH SMALLINT,
LABELHEIGHT SMALLINT,
HORIZONTALGAP SMALLINT,
VERTICALGAP SMALLINT,
PRIMARY KEY (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE PRODUCT_LABELS (
ID varchar(255) NOT NULL,
PRODUCT varchar(255) NOT NULL,
DIMENSION varchar(255) NOT NULL,
TITLE varchar(255),
QUANTITY DOUBLE,
INGREDIENTS varchar(255) NOT NULL,
INSTRUCTION varchar(255) NOT NULL,
LINE1 varchar(255) NOT NULL,
LINE2 varchar(255) NOT NULL,
LINE3 varchar(255) NOT NULL,
PRIMARY KEY (ID),
CONSTRAINT LABELS_FK_1 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS (ID),
CONSTRAINT LABELS_FK_2 FOREIGN KEY (DIMENSION) REFERENCES PRODUCT_LABEL_DIMENSIONS (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE REPORTS(
ID INT NOT NULL AUTO_INCREMENT,
REPORTNAME VARCHAR(255) NOT NULL,
CONTENT MEDIUMBLOB,
PRIMARY KEY (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8; 


-- WEBIN DEFAULT ROLE AND USER

INSERT INTO ROLES(ID, NAME, PERMISSIONS) VALUES('501', 'Webadmin', $FILE{/com/posics/pos/templates/webin/Role.Webadmin.xml} );
INSERT INTO PEOPLE(ID, NAME, APPPASSWORD, ROLE, VISIBLE, IMAGE) VALUES ('501', 'webadmin', 'sha1:5BAA61E4C9B93F3F0682250B6CF8331B7EE68FD8', '501', FALSE, NULL);


-- WEBIN RESOURCES

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('501', 'Webin.Menu','0', $FILE{/com/posics/pos/templates/webin/Resource.Webmenu.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('502', 'label.sizes','0',$FILE{/com/posics/pos/templates/webin/Resource.label.sizes.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('503', 'label.formats','0',$FILE{/com/posics/pos/templates/webin/Resource.label.formats.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('504', 'Webin.Dashboard.Databoxes','0',$FILE{/com/posics/pos/templates/webin/Resource.Databoxes.xml});

-- WEBIN REPORTS
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('PRODUCTSALES',$FILE{/com/posics/pos/templates/webin/Report.Productsales.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('CLOSEDCASH',$FILE{/com/posics/pos/templates/webin/Report.Closedcash.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('SALESLOG',$FILE{/com/posics/pos/templates/webin/Report.Saleslog.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('TARIFFSALES',$FILE{/com/posics/pos/templates/webin/Report.Tariffsales.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('CURRENTINVENTORY',$FILE{/com/posics/pos/templates/webin/Report.Currentinventory.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('CURRENTINVENTORYBROKEN',$FILE{/com/posics/pos/templates/webin/Report.Currentinventorybroken.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('STOCKDIARY',$FILE{/com/posics/pos/templates/webin/Report.Stockdiary.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('PRODUCTS',$FILE{/com/posics/pos/templates/webin/Report.Products.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('PRODUCTLABELS',$FILE{/com/posics/pos/templates/webin/Report.Productsales.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('CATALOG',$FILE{/com/posics/pos/templates/webin/Report.Catalog.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('CUSTOMERS',$FILE{/com/posics/pos/templates/webin/Report.Customers.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('CUSTOMERSDEFAULTING',$FILE{/com/posics/pos/templates/webin/Report.Customersdefaulting.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('CUSTOMERDIARY',$FILE{/com/posics/pos/templates/webin/Report.Customerdiary.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('SUPPLIERS',$FILE{/com/posics/pos/templates/webin/Report.Suppliers.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('SUPPLIERDIARY',$FILE{/com/posics/pos/templates/webin/Report.Supplierdiary.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('SUPPLIERDEFAULTING',$FILE{/com/posics/pos/templates/webin/Report.Supplierdefaulting.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('SUPPLIERDIARYDET',$FILE{/com/posics/pos/templates/webin/Report.Supplierdiarydet.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('WAREHOUSE',$FILE{/com/posics/pos/templates/webin/Report.Warehouse.xml});
INSERT INTO REPORTS(REPORTNAME, CONTENT) VALUES('INVENTORY',$FILE{/com/posics/pos/templates/webin/Report.Inventory.xml});

-- DELIVERY MODULE
CREATE TABLE CALLS (
    ID VARCHAR(255) NOT NULL,
    CALLERID VARCHAR(255) NOT NULL,
    DATENEW DATETIME NOT NULL,
    LINEID VARCHAR(255) NULL,
    CUSTOMER VARCHAR(255),
    MONEY VARCHAR(255) NOT NULL,
    STATUS SMALLINT DEFAULT 0 NOT NULL,
-- 0: IN COMING 1: ORDER TAKEN 2: BILL GENERATED 3: DELIVERED
    PRIMARY KEY (ID),
    CONSTRAINT CALLS_CUSTOMERS_FK FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID),
    CONSTRAINT CALLS_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE DRIVERS (
    ID VARCHAR(255) NOT NULL,
    DRIVERNAME VARCHAR(255) NOT NULL,
    CODE VARCHAR(255) NOT NULL,
    PRIMARY KEY(ID)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE DELIVERYORDERS (
    ID VARCHAR(255) NOT NULL,
    CALLID VARCHAR(255),
    DRIVERID VARCHAR(255),
    RECEIPT VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT CALL_FK_1 FOREIGN KEY (CALLID) REFERENCES CALLS(ID),
    CONSTRAINT DRV_FK_1 FOREIGN KEY (DRIVERID) REFERENCES DRIVERS(ID),
CONSTRAINT RECPT_FK_1 FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS(ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE PRODUCTS ADD COLUMN INCAT BIT DEFAULT b'1' NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN CATORDER INTEGER;
UPDATE PRODUCTS SET INCAT=0 WHERE ID NOT IN (SELECT PRODUCT FROM PRODUCTS_CAT);

ALTER TABLE SHAREDTICKETS ADD COLUMN BMODE SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE SHAREDTICKETS ADD COLUMN LOCKED VARCHAR(255);

CREATE TABLE LINESREMOVED (
    ID VARCHAR(255) NOT NULL,
    MONEY VARCHAR(255) NOT NULL,
    DATENEW DATETIME NOT NULL,
    TICKETID INTEGER,
    PRODUCT VARCHAR(255) NOT NULL,
    UNITS DOUBLE NOT NULL,
    PRICE DOUBLE NOT NULL,
    ATTRIBUTES MEDIUMBLOB,
    PERSON VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT REMOVEDLINES_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE ACCOUNTHEADS (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    PRIMARY KEY(ID)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO ACCOUNTHEADS VALUES('1', 'Sale');
INSERT INTO ACCOUNTHEADS VALUES('2', 'Purchase');
INSERT INTO ACCOUNTHEADS VALUES('3', 'Income');
INSERT INTO ACCOUNTHEADS VALUES('4', 'Expense');

ALTER TABLE RECEIPTS ADD COLUMN ACCOUNTHEAD VARCHAR(255) NOT NULL DEFAULT '1';
ALTER TABLE RECEIPTS ADD CONSTRAINT RECEIPTS_FK_PHEAD FOREIGN KEY (ACCOUNTHEAD) REFERENCES ACCOUNTHEADS(ID);
UPDATE RECEIPTS JOIN PAYMENTS ON RECEIPTS.ID=PAYMENTS.RECEIPT SET ACCOUNTHEAD = '4' WHERE PAYMENTS.PAYMENT LIKE 'cashout';
UPDATE RECEIPTS JOIN PAYMENTS ON RECEIPTS.ID=PAYMENTS.RECEIPT SET ACCOUNTHEAD = '3' WHERE PAYMENTS.PAYMENT LIKE 'cashin';
UPDATE RECEIPTS JOIN PAYMENTS ON RECEIPTS.ID=PAYMENTS.RECEIPT SET ACCOUNTHEAD = '2' WHERE PAYMENTS.PAYMENT LIKE '%credit%';

ALTER TABLE CUSTOMERS ADD COLUMN ADVANCE DOUBLE;
ALTER TABLE CUSTOMERS ADD COLUMN ADVANCEDATE DATETIME;
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('72', 'Printer.CustomerAdvancePaid', 0, $FILE{/com/posics/pos/templates/Printer.CustomerAdvancePaid.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('73', 'Printer.CustomerAdvancePaid2', 0, $FILE{/com/posics/pos/templates/Printer.CustomerAdvancePaid2.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('74', 'Printer.CloseCashExample', 0, $FILE{/com/posics/pos/templates/Printer.CloseCashExample.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('75', 'Printer.TicketExample', 0, $FILE{/com/posics/pos/templates/Printer.TicketExample.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('76', 'CloseCash.Reports', 0, $FILE{/com/posics/pos/templates/CloseCash.Reports.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('77', 'Printer.Label', 0, $FILE{/com/posics/pos/templates/Printer.Label.xml});

ALTER TABLE CONFIGURATION ADD COLUMN NEXTBARCODE INT NULL;
ALTER TABLE CONFIGURATION ADD COLUMN COUNTRY VARCHAR(8) NULL;
ALTER TABLE CONFIGURATION ADD COLUMN FORMATINTEGER VARCHAR(20) NULL;
ALTER TABLE CONFIGURATION ADD COLUMN FORMATDOUBLE VARCHAR(20) NULL;
ALTER TABLE CONFIGURATION ADD COLUMN FORMATCURRENCY VARCHAR(20) NULL;
ALTER TABLE CONFIGURATION ADD COLUMN FORMATPERCENT VARCHAR(20) NULL;
ALTER TABLE CONFIGURATION ADD COLUMN FORMATDATE VARCHAR(45) NULL;
ALTER TABLE CONFIGURATION ADD COLUMN FORMATTIME VARCHAR(45) NULL;
ALTER TABLE CONFIGURATION ADD COLUMN FORMATDATETIME VARCHAR(45) NULL;
DELETE FROM CONFIGURATION;
INSERT INTO CONFIGURATION VALUES('Supplier shall issue accurate invoices to Buyer for Goods.\nShipments must be made to meet the date specified in the Purchase Order.', 1, 1, 1, 10001, 'en_US', '#0', '#0.0', '#0.00', '#0%', 'd-m-y', 'h:i', 'd-m-y h:i');

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('78', 'payment.icon.online', 1, $FILE{/com/posics/pos/templates/payment.icon.online.png});

ALTER TABLE CLOSEDCASH ADD COLUMN ACTUALCASH DOUBLE;
ALTER TABLE CLOSEDCASH ADD COLUMN PRINTCOUNT INTEGER DEFAULT 0;
ALTER TABLE CLOSEDCASH ADD COLUMN NOTES VARCHAR(255);
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('79', 'Printer.CloseCashBlind', 0, $FILE{/com/posics/pos/templates/Printer.CloseCashBlind.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('80', 'POS.Reports', 0, $FILE{/com/posics/pos/templates/POS.Reports.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('81', 'POS.Report.SalesLog', 0, $FILE{/com/posics/pos/templates/POS.Report.SalesLog.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('82', 'POS.Report.Payments', 0, $FILE{/com/posics/pos/templates/POS.Report.Payments.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('83', 'POS.Report.CashClosed', 0, $FILE{/com/posics/pos/templates/POS.Report.CashClosed.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('84', 'POS.Report.CurrentInventory', 0, $FILE{/com/posics/pos/templates/POS.Report.CurrentInventory.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('85', 'POS.Report.ProductSales', 0, $FILE{/com/posics/pos/templates/POS.Report.ProductSales.xml});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('86', 'Printer.OrderPreview', 0, $FILE{/com/posics/pos/templates/Printer.OrderPreview.xml});

ALTER TABLE DELIVERYORDERS ADD COLUMN ORDERTYPE SMALLINT; 
--1: Delivery 2: Online Order
ALTER TABLE DELIVERYORDERS ADD COLUMN DELIVERYDATE DATETIME;
ALTER TABLE DELIVERYORDERS DROP FOREIGN KEY CALL_FK_1;

CREATE TABLE ONLINEORDERS (
  ID varchar(255) NOT NULL,
  CREATED_AT datetime NOT NULL,
  MONEY varchar(255) NOT NULL,
  PORTAL varchar(255) NOT NULL,
  ORDERID INTEGER NOT NULL,
  ORDERCONTENT TEXT NOT NULL,
  ORDERED_AT datetime,
  ACCEPTED_AT datetime,
  PREPARED_AT datetime,
  ASSIGNED_AT datetime,
  PICKED_AT datetime,
  DELIVERED_AT datetime,
  REJECTED_AT datetime,
  STATUS smallint(6) NOT NULL DEFAULT 0,
  RECEIPT varchar(255),
-- 0: CREATED 1: ACCEPTED 2: PREPARED 3: PICKEDUP 4: DELIVERED 5: REJECTED
  PRIMARY KEY (ID),
  CONSTRAINT OO_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH (MONEY),
  CONSTRAINT OO_FK_RECEIPT FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE CUSTOMERS_ADDRESS (
    ID VARCHAR(255) NOT NULL,
    CUSTOMER VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    ADDRESS VARCHAR(255),
    PHONE VARCHAR(255),
    LATITUDE VARCHAR(255),
    LONGITUDE VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT ADDRESS_CUSTOMER FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE CLOSEDCASH ADD COLUMN ACTUALCARD DOUBLE ;
ALTER TABLE DELIVERYORDERS ADD COLUMN PAYMENT VARCHAR(255);

CREATE TABLE APPORDERS (
  ID varchar(255) NOT NULL,
  CREATED_AT datetime NOT NULL,
  MONEY varchar(255) ,
  DEVICEID varchar(255) NOT NULL,
  WAITERID varchar(255) NOT NULL,
  TABLEID varchar(255) NOT NULL,
  ORDERCONTENT TEXT NOT NULL,
  AMOUNT DOUBLE NOT NULL,
  STATUS smallint(6) NOT NULL DEFAULT 0 ,
  RECEIPT varchar(255),
  TICKETID int(11),
  PRIMARY KEY (ID),
  CONSTRAINT AO_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH (MONEY),
  CONSTRAINT AO_FK_RECEIPT FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE TICKETHISTORY (
    ORDERID VARCHAR(255) NOT NULL,
    ORDERNUMBER SMALLINT NOT NULL,
    TICKETNAME VARCHAR(255) NOT NULL,
    TICKETCONTENT MEDIUMBLOB,
    TICKETMODE SMALLINT DEFAULT 0 NOT NULL,
-- 1: Standard, 2: Restaurant 3: Delivery 4: Online 5: Waiter App 6: Purchase
    TICKETLOCATION VARCHAR(255) NOT NULL,
    TICKETDATE DATETIME NOT NULL,
	TICKETUSER VARCHAR(255),
    MONEY VARCHAR(255) NOT NULL,
    PRIMARY KEY(ORDERID),
    CONSTRAINT TH_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8;

CREATE TABLE TICKETSNUM_ORDER (
    ID INTEGER NOT NULL, 
    MONEY VARCHAR(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('87', 'Printer.TicketOrder', 0, $FILE{/com/posics/pos/templates/Printer.TicketOrder.xml});

ALTER TABLE TICKETLINES ADD COLUMN COST DOUBLE DEFAULT 0 NOT NULL AFTER UNITS;

CREATE TABLE ZATCA_INVOICES (
    ID INT AUTO_INCREMENT PRIMARY KEY,
    RECEIPT VARCHAR(255) NOT NULL,
-- Unique Invoice Identifier
    JSON_DATA TEXT NOT NULL,
-- JSON Data of the Invoice
    STATUS VARCHAR(50) DEFAULT 'PENDING',
-- PENDING, SUCCESS, FAILED
    ATTEMPTS INT DEFAULT 0,
-- Number of Upload Attempts
    LAST_ATTEMPT DATETIME NULL,
-- Timestamp of Last Attempt
    RESPONSE_CODE VARCHAR(50) NULL,
-- ZATCA Response Code (e.g., 200, 400)
    RESPONSE_MESSAGE TEXT NULL,
-- ZATCA Response Message
    CREATED_AT DATETIME DEFAULT CURRENT_TIMESTAMP,
-- Record Creation Timestamp
    UPDATED_AT DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
-- Record Update Timestamp
);

ALTER TABLE TICKETHISTORY MODIFY COLUMN TICKETLOCATION VARCHAR(255) DEFAULT NULL;