UPDATE APPLICATIONS SET VERSION=4.3 WHERE ID=$APP_ID{};

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('69', 'SQL.DeleteTransactions', 0, $FILE{/com/posics/pos/templates/SQL.DeleteTransactions.sql});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('70', 'SQL.BackupTables', 0, $FILE{/com/posics/pos/templates/SQL.BackupTables.sql});
-- DELIVERY MODULE
CREATE TABLE CALLS (
    ID VARCHAR(255) NOT NULL,
    CALLERID VARCHAR(255) NOT NULL,
    DATENEW DATETIME NOT NULL,
    LINEID VARCHAR(255) NULL,
    CUSTOMER VARCHAR(255),
    MONEY VARCHAR(255) NOT NULL,
    STATUS SMALLINT DEFAULT 0 NOT NULL,
-- 0: IN COMING 1: ORDER TAKEN 2: BILL GENERATED 3: DELIVERED
    PRIMARY KEY (ID),
    CONSTRAINT CALLS_CUSTOMERS_FK FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID),
    CONSTRAINT CALLS_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE DRIVERS (
    ID VARCHAR(255) NOT NULL,
    DRIVERNAME VARCHAR(255) NOT NULL,
    CODE VARCHAR(255) NOT NULL,
    PRIMARY KEY(ID)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE DELIVERYORDERS (
    ID VARCHAR(255) NOT NULL,
    CALLID VARCHAR(255),
    DRIVERID VARCHAR(255),
    RECEIPT VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT CALL_FK_1 FOREIGN KEY (CALLID) REFERENCES CALLS(ID),
    CONSTRAINT DRV_FK_1 FOREIGN KEY (DRIVERID) REFERENCES DRIVERS(ID),
CONSTRAINT RECPT_FK_1 FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS(ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE PRODUCTS ADD COLUMN INCAT BIT DEFAULT b'1' NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN CATORDER INTEGER;
UPDATE PRODUCTS SET INCAT=0 WHERE ID NOT IN (SELECT PRODUCT FROM PRODUCTS_CAT);
DROP TABLE PRODUCTS_CAT;

ALTER TABLE SHAREDTICKETS ADD COLUMN BMODE SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE SHAREDTICKETS ADD COLUMN LOCKED VARCHAR(255);

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('504', 'Webin.Dashboard.Databoxes','0',$FILE{/com/posics/pos/templates/webin/Resource.Databoxes.xml});

CREATE TABLE LINESREMOVED (
    ID VARCHAR(255) NOT NULL,
    MONEY VARCHAR(255) NOT NULL,
    DATENEW DATETIME NOT NULL,
    TICKETID INTEGER,
    PRODUCT VARCHAR(255) NOT NULL,
    UNITS DOUBLE NOT NULL,
    PRICE DOUBLE NOT NULL,
    ATTRIBUTES MEDIUMBLOB,
    PERSON VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT REMOVEDLINES_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE ACCOUNTHEADS (
    ID VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    PRIMARY KEY(ID)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO ACCOUNTHEADS VALUES('1', 'Sale');
INSERT INTO ACCOUNTHEADS VALUES('2', 'Purchase');
INSERT INTO ACCOUNTHEADS VALUES('3', 'Income');
INSERT INTO ACCOUNTHEADS VALUES('4', 'Expense');

ALTER TABLE RECEIPTS ADD COLUMN ACCOUNTHEAD VARCHAR(255) NOT NULL DEFAULT '1';
ALTER TABLE RECEIPTS ADD CONSTRAINT RECEIPTS_FK_PHEAD FOREIGN KEY (ACCOUNTHEAD) REFERENCES ACCOUNTHEADS(ID);
UPDATE RECEIPTS JOIN PAYMENTS ON RECEIPTS.ID=PAYMENTS.RECEIPT SET ACCOUNTHEAD = '4' WHERE PAYMENTS.PAYMENT LIKE 'cashout';
UPDATE RECEIPTS JOIN PAYMENTS ON RECEIPTS.ID=PAYMENTS.RECEIPT SET ACCOUNTHEAD = '3' WHERE PAYMENTS.PAYMENT LIKE 'cashin';
UPDATE RECEIPTS JOIN PAYMENTS ON RECEIPTS.ID=PAYMENTS.RECEIPT SET ACCOUNTHEAD = '2' WHERE PAYMENTS.PAYMENT LIKE '%credit%';

ALTER TABLE CUSTOMERS ADD COLUMN ADVANCE DOUBLE;
ALTER TABLE CUSTOMERS ADD COLUMN ADVANCEDATE DATETIME;
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('72', 'Printer.CustomerAdvancePaid', 0, $FILE{/com/posics/pos/templates/Printer.CustomerAdvancePaid.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('73', 'Printer.CustomerAdvancePaid2', 0, $FILE{/com/posics/pos/templates/Printer.CustomerAdvancePaid2.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('74', 'Printer.CloseCashExample', 0, $FILE{/com/posics/pos/templates/Printer.CloseCashExample.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('75', 'Printer.TicketExample', 0, $FILE{/com/posics/pos/templates/Printer.TicketExample.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('76', 'CloseCash.Reports', 0, $FILE{/com/posics/pos/templates/CloseCash.Reports.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('77', 'Printer.Label', 0, $FILE{/com/posics/pos/templates/Printer.Label.xml});

DROP TABLE CONFIGURATION;
CREATE TABLE CONFIGURATION(
POTERMS VARCHAR(255) NULL,
NEXTREQNO INT NULL,
NEXTPONO INT NULL,
NEXTGRNO INT NULL,
NEXTBARCODE INT NULL,
COUNTRY VARCHAR(8) NULL,
FORMATINTEGER VARCHAR(20) NULL,
FORMATDOUBLE VARCHAR(20) NULL,
FORMATCURRENCY VARCHAR(20) NULL,
FORMATPERCENT VARCHAR(20) NULL,
FORMATDATE VARCHAR(45) NULL,
FORMATTIME VARCHAR(45) NULL,
FORMATDATETIME VARCHAR(45) NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO CONFIGURATION VALUES('Supplier shall issue accurate invoices to Buyer for Goods.\nShipments must be made to meet the date specified in the Purchase Order.', 1, 1, 1, 10001, 'en_US', '#0', '#0.0', '#0.00', '#0%', 'd-m-Y', 'h:i', 'd-m-Y h:i');

CREATE TABLE ACCOUNTS(
    ID VARCHAR(255) NOT NULL,
    ACCOUNT_NAME VARCHAR(255) NOT NULL,
    ACCOUNT_NUMBER VARCHAR(255),
    INITIAL_BALANCE DOUBLE NOT NULL,
    AVAILABLE_BALANCE DOUBLE NOT NULL,
    PRIMARY KEY (ID) 
) ENGINE=INNODB DEFAULT CHARSET=UTF8;
INSERT INTO ACCOUNTS (ID, ACCOUNT_NAME, ACCOUNT_NUMBER, INITIAL_BALANCE, AVAILABLE_BALANCE) VALUES ('PURCHASE', 'PURCHASE', 'PURCHASE', '0', '0');
INSERT INTO ACCOUNTS (ID, ACCOUNT_NAME, ACCOUNT_NUMBER, INITIAL_BALANCE, AVAILABLE_BALANCE) VALUES ('SALE', 'SALE', 'SALE', '0', '0');

CREATE TABLE PAYMENTHEADS (
  ID VARCHAR(255) NOT NULL,
  PAYMENTHEAD VARCHAR(255) NOT NULL,
  PRIMARY KEY (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO PAYMENTHEADS (ID, PAYMENTHEAD) VALUES ('DEPOSIT', 'DEPOSIT');
INSERT INTO PAYMENTHEADS (ID, PAYMENTHEAD) VALUES ('PURCHASE', 'PURCHASE');
INSERT INTO PAYMENTHEADS (ID, PAYMENTHEAD) VALUES ('PURCHASERETURN', 'PURCHASE RETURN');

CREATE TABLE TRANSACTIONS (
  ID VARCHAR(255) NOT NULL,
  TRANSACTION_DATE DATE NOT NULL,
  TRANSACTION_TYPE_ID SMALLINT NOT NULL,
-- 0. Deposit 1. Withdrawal
  ACCOUNT_ID VARCHAR(255) NOT NULL,
  PAYMENTHEAD_ID VARCHAR(255) NOT NULL,
  AMOUNT DOUBLE NOT NULL,
  COMMENTS TEXT,
  STATUS SMALLINT NOT NULL,
-- 0-Created, 1-Approved, 2-Rejected
  CREATED DATETIME NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  APPROVED DATETIME NOT NULL,
  APPROVED_BY VARCHAR(255) NOT NULL,
  PRIMARY KEY (ID),
  CONSTRAINT TRANSACTIONS_FK_1 FOREIGN KEY (ACCOUNT_ID) REFERENCES ACCOUNTS(ID),
  CONSTRAINT TRANSACTIONS_FK_2 FOREIGN KEY (PAYMENTHEAD_ID) REFERENCES PAYMENTHEADS(ID),
  CONSTRAINT TRANSACTIONS_FK_3 FOREIGN KEY (CREATED_BY) REFERENCES PEOPLE(ID),
  CONSTRAINT TRANSACTIONS_FK_4 FOREIGN KEY (APPROVED_BY) REFERENCES PEOPLE(ID)
) ENGINE=INNODB DEFAULT CHARSET=UTF8;

ALTER TABLE PURCHASEINVOICELINES DROP COLUMN UOM, DROP COLUMN TAXAMOUNT;
ALTER TABLE PURCHASEINVOICELINES MODIFY COLUMN ID VARCHAR(255) NOT NULL;
ALTER TABLE PURCHASEINVOICELINES DROP FOREIGN KEY PIL_PI_FK_1;
ALTER TABLE PURCHASEINVOICELINES MODIFY COLUMN PIID VARCHAR(255) NOT NULL;
ALTER TABLE PURCHASEINVOICELINES ADD COLUMN TAXID VARCHAR(255) NOT NULL;
UPDATE PURCHASEINVOICELINES SET TAXID='000';
ALTER TABLE PURCHASEINVOICELINES ADD CONSTRAINT PIL_TAX_FK_3 FOREIGN KEY (TAXID) REFERENCES TAXES(ID);
ALTER TABLE PURCHASEINVOICE MODIFY COLUMN ID VARCHAR(255) NOT NULL;
ALTER TABLE PURCHASEINVOICELINES ADD CONSTRAINT PIL_PI_FK_1 FOREIGN KEY (PIID) REFERENCES PURCHASEINVOICE(ID);
ALTER TABLE PURCHASEINVOICE DROP COLUMN REVISION, DROP COLUMN TAXAMOUNT, DROP COLUMN TOTALAMOUNT;
ALTER TABLE PURCHASEINVOICE DROP FOREIGN KEY PI_EMP_FK_2;
ALTER TABLE PURCHASEINVOICE CHANGE UPDATEDBY APPROVEDBY VARCHAR(255) DEFAULT NULL;
ALTER TABLE PURCHASEINVOICE CHANGE UPDATEDDATE APPROVEDDATE TIMESTAMP;
ALTER TABLE PURCHASEINVOICE ADD CONSTRAINT PI_EMP_FK_2 FOREIGN KEY (APPROVEDBY) REFERENCES people(ID);
ALTER TABLE PURCHASEINVOICE CHANGE TERMS COMMENTS TEXT;

CREATE TABLE PURCHASEINVOICETAXES (
    ID VARCHAR(255) NOT NULL,
    PIID VARCHAR(255) NOT NULL,
    TAXID VARCHAR(255) NOT NULL,
    BASEAMOUNT DOUBLE NOT NULL,
    TAXAMOUNT DOUBLE NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT PILT_PI_FK_1 FOREIGN KEY (PIID) REFERENCES PURCHASEINVOICE(ID),
    CONSTRAINT PILT_TAX_FK_2 FOREIGN KEY (TAXID) REFERENCES TAXES(ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE PURCHASEINVOICE_PAYMENTS (
  ID VARCHAR(255) NOT NULL,
  PURCHASEINVOICE_ID VARCHAR(255) NOT NULL,
  TRANSACTION_ID VARCHAR(255) NOT NULL,
  PRIMARY KEY (ID),
  CONSTRAINT PURCHASE__FK_1 FOREIGN KEY (PURCHASEINVOICE_ID) REFERENCES PURCHASEINVOICE(ID),
  CONSTRAINT PPAYMENTS_FK_2 FOREIGN KEY (TRANSACTION_ID) REFERENCES TRANSACTIONS(ID)
) ENGINE=INNODB DEFAULT CHARSET=UTF8;

ALTER TABLE CLOSEDCASH ADD COLUMN ACTUALCASH DOUBLE;
ALTER TABLE CLOSEDCASH ADD COLUMN PRINTCOUNT INTEGER DEFAULT 0;
ALTER TABLE CLOSEDCASH ADD COLUMN NOTES VARCHAR(255);
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('79', 'Printer.CloseCashBlind', 0, $FILE{/com/posics/pos/templates/Printer.CloseCashBlind.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('80', 'POS.Reports', 0, $FILE{/com/posics/pos/templates/POS.Reports.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('81', 'POS.Report.SalesLog', 0, $FILE{/com/posics/pos/templates/POS.Report.SalesLog.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('82', 'POS.Report.Payments', 0, $FILE{/com/posics/pos/templates/POS.Report.Payments.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('83', 'POS.Report.CashClosed', 0, $FILE{/com/posics/pos/templates/POS.Report.CashClosed.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('84', 'POS.Report.CurrentInventory', 0, $FILE{/com/posics/pos/templates/POS.Report.CurrentInventory.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('85', 'POS.Report.ProductSales', 0, $FILE{/com/posics/pos/templates/POS.Report.ProductSales.xml});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('86', 'Printer.OrderPreview', 0, $FILE{/com/posics/pos/templates/Printer.OrderPreview.xml});

ALTER TABLE DELIVERYORDERS ADD COLUMN ORDERTYPE SMALLINT; 
--1: Delivery 2: Online Order
ALTER TABLE DELIVERYORDERS ADD COLUMN DELIVERYDATE DATETIME;
ALTER TABLE DELIVERYORDERS DROP FOREIGN KEY CALL_FK_1;

CREATE TABLE ONLINEORDERS (
  ID varchar(255) NOT NULL,
  CREATED_AT datetime NOT NULL,
  MONEY varchar(255) NOT NULL,
  PORTAL varchar(255) NOT NULL,
  ORDERID INTEGER NOT NULL,
  ORDERCONTENT TEXT NOT NULL,
  ORDERED_AT datetime,
  ACCEPTED_AT datetime,
  PREPARED_AT datetime,
  ASSIGNED_AT datetime,
  PICKED_AT datetime,
  DELIVERED_AT datetime,
  REJECTED_AT datetime,
  STATUS smallint(6) NOT NULL DEFAULT 0,
  RECEIPT varchar(255),
-- 0: CREATED 1: ACCEPTED 2: PREPARED 3: PICKEDUP 4: DELIVERED 5: REJECTED
  PRIMARY KEY (ID),
  CONSTRAINT OO_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH (MONEY),
  CONSTRAINT OO_FK_RECEIPT FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE CUSTOMERS_ADDRESS (
    ID VARCHAR(255) NOT NULL,
    CUSTOMER VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    ADDRESS VARCHAR(255),
    PHONE VARCHAR(255),
    LATITUDE VARCHAR(255),
    LONGITUDE VARCHAR(255),
    PRIMARY KEY (ID),
    CONSTRAINT ADDRESS_CUSTOMER FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE CLOSEDCASH ADD COLUMN ACTUALCARD DOUBLE ;
ALTER TABLE DELIVERYORDERS ADD COLUMN PAYMENT VARCHAR(255);

CREATE TABLE APPORDERS (
  ID varchar(255) NOT NULL,
  CREATED_AT datetime NOT NULL,
  MONEY varchar(255) ,
  DEVICEID varchar(255) NOT NULL,
  WAITERID varchar(255) NOT NULL,
  TABLEID varchar(255) NOT NULL,
  ORDERCONTENT TEXT NOT NULL,
  AMOUNT DOUBLE NOT NULL,
  STATUS smallint(6) NOT NULL DEFAULT 0 ,
  RECEIPT varchar(255),
  TICKETID int(11),
  PRIMARY KEY (ID),
  CONSTRAINT AO_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH (MONEY),
  CONSTRAINT AO_FK_RECEIPT FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE TICKETHISTORY (
    ORDERID VARCHAR(255) NOT NULL,
    ORDERNUMBER SMALLINT NOT NULL,
    TICKETNAME VARCHAR(255) NOT NULL,
    TICKETCONTENT MEDIUMBLOB,
    TICKETMODE SMALLINT DEFAULT 0 NOT NULL,
-- 1: Standard, 2: Restaurant 3: Delivery 4: Online 5: Waiter App 6: Purchase
    TICKETLOCATION VARCHAR(255) NOT NULL,
    TICKETDATE DATETIME NOT NULL,
	TICKETUSER VARCHAR(255),
    MONEY VARCHAR(255) NOT NULL,
    PRIMARY KEY(ORDERID),
    CONSTRAINT TH_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8;

CREATE TABLE TICKETSNUM_ORDER (
    ID INTEGER NOT NULL, 
    MONEY VARCHAR(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('87', 'Printer.TicketOrder', 0, $FILE{/com/posics/pos/templates/Printer.TicketOrder.xml});

ALTER TABLE TICKETLINES ADD COLUMN COST DOUBLE DEFAULT 0 NOT NULL AFTER UNITS;

CREATE TABLE ZATCA_INVOICES (
    ID INT AUTO_INCREMENT PRIMARY KEY,
    RECEIPT VARCHAR(255) NOT NULL,
-- Unique Invoice Identifier
    JSON_DATA TEXT NOT NULL,
-- JSON Data of the Invoice
    STATUS VARCHAR(50) DEFAULT 'PENDING',
-- PENDING, SUCCESS, FAILED
    ATTEMPTS INT DEFAULT 0,
-- Number of Upload Attempts
    LAST_ATTEMPT DATETIME NULL,
-- Timestamp of Last Attempt
    RESPONSE_CODE VARCHAR(50) NULL,
-- ZATCA Response Code (e.g., 200, 400)
    RESPONSE_MESSAGE TEXT NULL,
-- ZATCA Response Message
    CREATED_AT DATETIME DEFAULT CURRENT_TIMESTAMP,
-- Record Creation Timestamp
    UPDATED_AT DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
-- Record Update Timestamp
);

ALTER TABLE TICKETHISTORY MODIFY COLUMN TICKETLOCATION VARCHAR(255) DEFAULT NULL;