UPDATE APPLICATIONS SET VERSION=4.3 WHERE ID=$APP_ID{};

ALTER TABLE CLOSEDCASH ADD COLUMN ACTUALCARD DOUBLE ;
ALTER TABLE DELIVERYORDERS ADD COLUMN PAYMENT VARCHAR(255);

CREATE TABLE APPORDERS (
  ID varchar(255) NOT NULL,
  CREATED_AT datetime NOT NULL,
  MONEY varchar(255) ,
  DEVICEID varchar(255) NOT NULL,
  WAITERID varchar(255) NOT NULL,
  TABLEID varchar(255) NOT NULL,
  ORDERCONTENT TEXT NOT NULL,
  AMOUNT DOUBLE NOT NULL,
  STATUS smallint(6) NOT NULL DEFAULT 0 ,
  RECEIPT varchar(255),
  TICKETID int(11),
  PRIMARY KEY (ID),
  CONSTRAINT AO_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH (MONEY),
  CONSTRAINT AO_FK_RECEIPT FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE TICKETHISTORY (
    ORDERID VARCHAR(255) NOT NULL,
    ORDERNUMBER SMALLINT NOT NULL,
    TICKETNAME VARCHAR(255) NOT NULL,
    TICKETCONTENT MEDIUMBLOB,
    TICKETMODE SMALLINT DEFAULT 0 NOT NULL,
-- 1: Standard, 2: Restaurant 3: Delivery 4: Online 5: Waiter App 6: Purchase
    TICKETLOCATION VARCHAR(255) NOT NULL,
    TICKETDATE DATETIME NOT NULL,
	TICKETUSER VARCHAR(255),
    MONEY VARCHAR(255) NOT NULL,
    PRIMARY KEY(ORDERID),
    CONSTRAINT TH_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8;

CREATE TABLE TICKETSNUM_ORDER (
    ID INTEGER NOT NULL, 
    MONEY VARCHAR(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('87', 'Printer.TicketOrder', 0, $FILE{/com/posics/pos/templates/Printer.TicketOrder.xml});

ALTER TABLE TICKETLINES ADD COLUMN COST DOUBLE DEFAULT 0 NOT NULL AFTER UNITS;

CREATE TABLE ZATCA_INVOICES (
    ID INT AUTO_INCREMENT PRIMARY KEY,
    RECEIPT VARCHAR(255) NOT NULL,
-- Unique Invoice Identifier
    JSON_DATA TEXT NOT NULL,
-- JSON Data of the Invoice
    STATUS VARCHAR(50) DEFAULT 'PENDING',
-- PENDING, SUCCESS, FAILED
    ATTEMPTS INT DEFAULT 0,
-- Number of Upload Attempts
    LAST_ATTEMPT DATETIME NULL,
-- Timestamp of Last Attempt
    RESPONSE_CODE VARCHAR(50) NULL,
-- ZATCA Response Code (e.g., 200, 400)
    RESPONSE_MESSAGE TEXT NULL,
-- ZATCA Response Message
    CREATED_AT DATETIME DEFAULT CURRENT_TIMESTAMP,
-- Record Creation Timestamp
    UPDATED_AT DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
-- Record Update Timestamp
);

ALTER TABLE TICKETHISTORY MODIFY COLUMN TICKETLOCATION VARCHAR(255) DEFAULT NULL;