//    Posics Saleculator - Billing System.
//    Copyright (C) Posics.
//    http://www.posics.com
//



report = new com.posics.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Closing");
report.setReport("/com/posics/reports/closedpos");
report.setResourceBundle("com/posics/reports/closedpos_messages");

report.setSentence("SELECT " + 
                    "CLOSEDCASH.HOST, " +
                    "CLOSEDCASH.HOSTSEQUENCE, " +
                    "CLOSEDCASH.MONEY, " +
                    "CLOSEDCASH.DATESTART, " +
                    "CLOSEDCASH.DATEEND, " +
                    "PAYMENTS.PAYMENT, " +
                    "PAYMENTS.NOTES, " +
                    "SUM(PAYMENTS.TOTAL) AS TOTAL " +
                    "FROM CLOSEDCASH, PAYMENTS, RECEIPTS " +
                    "WHERE CLOSEDCASH.MONEY = RECEIPTS.MONEY AND PAYMENTS.RECEIPT = RECEIPTS.ID AND ?(QBF_FILTER) " +
                    "GROUP BY CLOSEDCASH.HOST, CLOSEDCASH.HOSTSEQUENCE, CLOSEDCASH.MONEY, CLOSEDCASH.DATESTART, CLOSEDCASH.DATEEND, PAYMENTS.PAYMENT, PAYMENTS.NOTES " +
                    "ORDER BY CLOSEDCASH.HOST, CLOSEDCASH.HOSTSEQUENCE");
report.addParameter("CLOSEDCASH.DATEEND");
report.addParameter("CLOSEDCASH.DATEEND");
paramdates = new com.posics.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.posics.beans.DateUtils.getToday());
report.addQBFFilter(paramdates);
report.addParameter("CLOSEDCASH.HOST");
paramhost = new com.posics.pos.reports.JParamsHost();
report.addQBFFilter(paramhost);

report.addField("HOST", com.posics.data.loader.Datas.STRING);
report.addField("SEQUENCE", com.posics.data.loader.Datas.INT);
report.addField("MONEY", com.posics.data.loader.Datas.STRING);
report.addField("DATESTART", com.posics.data.loader.Datas.TIMESTAMP);
report.addField("DATEEND", com.posics.data.loader.Datas.TIMESTAMP);
report.addField("PAYMENT", com.posics.data.loader.Datas.STRING);
report.addField("NOTES", com.posics.data.loader.Datas.STRING);
report.addField("TOTAL", com.posics.data.loader.Datas.DOUBLE);

report;

