//    Posics Saleculator - Billing System.
//    Copyright (C) Posics.
//    http://www.posics.com
//




report = new com.posics.pos.reports.PanelReportBean();

report.setTitleKey("Menu.ClosedProducts");
report.setReport("/com/posics/reports/closedproducts");
report.setResourceBundle("com/posics/reports/closedproducts_messages");

report.setSentence("SELECT " +
"CATEGORIES.NAME AS CATEGORY, " +                
"PRODUCTS.CODE, " +
                "PRODUCTS.NAME, " +
"IF(ISNULL(TICKETLINES.COST),0, SUM(TICKETLINES.UNITS * TICKETLINES.COST)) AS COST, " +
"PRODUCTS.PRICESELL AS PRICE, " +
                "SUM(TICKETLINES.UNITS) AS UNITS, " +
                "SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS TOTAL, " +
"IF(ISNULL(TICKETLINES.COST),SUM(TICKETLINES.UNITS * TICKETLINES.PRICE),SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) - (SUM(TICKETLINES.UNITS) * TICKETLINES.COST )) AS PROFIT, " +
"IF(ISNULL(TICKETLINES.COST),100,(SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) - (SUM(TICKETLINES.UNITS) * TICKETLINES.COST))/SUM(TICKETLINES.UNITS * TICKETLINES.COST)*100) AS PCT " +
                "FROM RECEIPTS, TICKETS, TICKETLINES LEFT OUTER JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID LEFT OUTER JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID " +
                "WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.ID = TICKETLINES.TICKET AND ?(QBF_FILTER) " +
                "GROUP BY CATEGORIES.NAME, PRODUCTS.CODE, PRODUCTS.NAME, TICKETLINES.COST, PRODUCTS.PRICESELL " +
                "ORDER BY CATEGORIES.NAME, PRODUCTS.NAME");
report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
paramdates = new com.posics.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.posics.beans.DateUtils.getToday());
report.addQBFFilter(paramdates);

report.addParameter("PRODUCTS.NAME");
report.addParameter("PRODUCTS.PRICEBUY");
report.addParameter("PRODUCTS.PRICESELL");
report.addParameter("PRODUCTS.CATEGORY");
report.addParameter("PRODUCTS.CODE");
report.addQBFFilter(new com.posics.pos.ticket.ProductFilter(false));

report.addField("CATEGORY", com.posics.data.loader.Datas.STRING);
report.addField("CODE", com.posics.data.loader.Datas.STRING);
report.addField("NAME", com.posics.data.loader.Datas.STRING);
report.addField("COST", com.posics.data.loader.Datas.DOUBLE);
report.addField("PRICE", com.posics.data.loader.Datas.DOUBLE);
report.addField("UNITS", com.posics.data.loader.Datas.DOUBLE);
report.addField("TOTAL", com.posics.data.loader.Datas.DOUBLE);
report.addField("PROFIT", com.posics.data.loader.Datas.DOUBLE);
report.addField("PCT", com.posics.data.loader.Datas.DOUBLE);

report;

