//    Posics Saleculator - Billing System.
//    Copyright (C) Posics.
//    http://www.posics.com
//

report = new com.posics.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Delivery");
report.setReport("/com/posics/reports/delivery");
report.setResourceBundle("com/posics/reports/delivery_messages");

report.setSentence("SELECT RECEIPTS.DATENEW, DRIVERS.DRIVERNAME, TICKETS.TICKETID AS TICKETID, CUSTOMERS.NAME, SUM((TICKETLINES.PRICE + TICKETLINES.PRICE * TAXES.RATE) * TICKETLINES.UNITS) AS TOTAL  " +
                 "FROM RECEIPTS " +
                 "LEFT JOIN TICKETS ON RECEIPTS.ID = TICKETS.ID LEFT JOIN TICKETLINES ON TICKETLINES.TICKET = TICKETS.ID " +
                "LEFT JOIN CUSTOMERS ON TICKETS.CUSTOMER = CUSTOMERS.ID " +
                "JOIN TAXES ON TICKETLINES.TAXID = TAXES.ID "+
                ", DELIVERYORDERS  LEFT JOIN DRIVERS ON DELIVERYORDERS.DRIVERID=DRIVERS.ID " +
"WHERE RECEIPTS.ID = DELIVERYORDERS.RECEIPT  AND ?(QBF_FILTER) GROUP BY TICKETLINES.TICKET, RECEIPTS.DATENEW, DRIVERS.DRIVERNAME, TICKETS.TICKETID, CUSTOMERS.NAME ORDER BY DRIVERS.DRIVERNAME, TICKETID");
report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
paramdates = new com.posics.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.posics.beans.DateUtils.getToday());
report.addQBFFilter(paramdates);

report.addParameter("DELIVERYORDERS.DRIVERID");
report.addQBFFilter(new com.posics.pos.reports.JParamsDriver());

report.addField("DATENEW", com.posics.data.loader.Datas.TIMESTAMP);
report.addField("DRIVERNAME", com.posics.data.loader.Datas.STRING);
report.addField("TICKETID", com.posics.data.loader.Datas.STRING);
report.addField("NAME", com.posics.data.loader.Datas.STRING);
report.addField("TOTAL", com.posics.data.loader.Datas.DOUBLE);

report;

