//    Posics Saleculator - Billing System.
//    Copyright (C) Posics.
//    http://www.posics.com
//

//




//




//



report = new com.posics.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Inventory");
report.setReport("/com/posics/reports/inventory");
report.setResourceBundle("com/posics/reports/inventory_messages");

report.setSentence("SELECT " +
                "STOCKCURRENT.LOCATION AS LOCATIONID, " +
                "LOCATIONS.NAME AS LOCATIONNAME, " +
                "PRODUCTS.REFERENCE, " +
                "PRODUCTS.NAME AS PRODUCTNAME, " +
                "PRODUCTS.CATEGORY, " +
                "CATEGORIES.NAME AS CATEGORYNAME, " +
                "SUM(STOCKCURRENT.UNITS) AS UNITS, " +
                "PRODUCTS.PRICEBUY, " +
                "PRODUCTS.PRICESELL, " +
                "COALESCE(PRODUCTS.STOCKVOLUME, 0) AS STOCKVOLUME, " +
                "COALESCE(PRODUCTS.STOCKCOST, 0) AS STOCKCOST, " +
                "COALESCE(STOCKLEVEL.STOCKSECURITY, 0) AS STOCKSECURITY, " +
                "COALESCE(STOCKLEVEL.STOCKMAXIMUM, 0) AS STOCKMAXIMUM " +
                "FROM STOCKCURRENT " +
                "JOIN LOCATIONS ON STOCKCURRENT.LOCATION = LOCATIONS.ID " +
                "JOIN PRODUCTS ON STOCKCURRENT.PRODUCT = PRODUCTS.ID " +
                "JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID " +
                "LEFT OUTER JOIN STOCKLEVEL ON STOCKCURRENT.LOCATION = STOCKLEVEL.LOCATION AND STOCKCURRENT.PRODUCT = STOCKLEVEL.PRODUCT " +
                "WHERE ?(QBF_FILTER) " +
                "GROUP BY STOCKCURRENT.LOCATION, LOCATIONS.NAME, PRODUCTS.REFERENCE, PRODUCTS.NAME, PRODUCTS.CATEGORY, CATEGORIES.NAME, PRODUCTS.PRICEBUY, PRODUCTS.PRICESELL, PRODUCTS.STOCKVOLUME, PRODUCTS.STOCKCOST, STOCKLEVEL.STOCKSECURITY, STOCKLEVEL.STOCKMAXIMUM " +
                "ORDER BY STOCKCURRENT.LOCATION, CATEGORIES.NAME, PRODUCTS.NAME");
report.addParameter("PRODUCTS.NAME");
report.addParameter("PRODUCTS.PRICEBUY");
report.addParameter("PRODUCTS.PRICESELL");
report.addParameter("PRODUCTS.CATEGORY");
report.addParameter("PRODUCTS.CODE");
report.addQBFFilter(new com.posics.pos.ticket.ProductFilter(true));
report.addParameter("STOCKCURRENT.LOCATION");
report.addQBFFilter(new com.posics.pos.reports.JParamsLocationWithFirst());

report.addField("LOCATIONID", com.posics.data.loader.Datas.STRING);
report.addField("LOCATIONNAME", com.posics.data.loader.Datas.STRING);
report.addField("REFERENCE", com.posics.data.loader.Datas.STRING);
report.addField("NAME", com.posics.data.loader.Datas.STRING);
report.addField("CATEGORY", com.posics.data.loader.Datas.STRING);
report.addField("CATEGORYNAME", com.posics.data.loader.Datas.STRING);
report.addField("UNITS", com.posics.data.loader.Datas.DOUBLE);
report.addField("PRICEBUY", com.posics.data.loader.Datas.DOUBLE);
report.addField("PRICESELL", com.posics.data.loader.Datas.DOUBLE);
report.addField("STOCKVOLUME", com.posics.data.loader.Datas.DOUBLE);
report.addField("STOCKCOST", com.posics.data.loader.Datas.DOUBLE);
report.addField("STOCKSECURITY", com.posics.data.loader.Datas.DOUBLE);
report.addField("STOCKMAXIMUM", com.posics.data.loader.Datas.DOUBLE);

report;
