report = new com.posics.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Logi");
report.setReport("/com/posics/reports/logi");
report.setResourceBundle("com/posics/reports/logi_messages");

report.setSentence("SELECT " +
                "TICKETS.TICKETID AS TICKET_NO, " +
                "RECEIPTS.DATENEW AS TICKET_DATE, " +
				"PAYMENTS.TOTAL AS MONEY, " +
				"CUSTOMERS.NAME AS CUSTOMER, " +
				"PAYMENTS.PAYMENT AS PAYMENT, " +
                                "ACCOUNTHEADS.NAME AS HEAD " +
                "FROM RECEIPTS " +
                "JOIN TICKETS ON RECEIPTS.ID = TICKETS.ID AND (TICKETS.TICKETTYPE=0 OR TICKETS.TICKETTYPE=1) " +
				"LEFT JOIN PAYMENTS ON RECEIPTS.ID = PAYMENTS.RECEIPT " +
                                "LEFT JOIN ACCOUNTHEADS ON RECEIPTS.ACCOUNTHEAD = ACCOUNTHEADS.ID " +
				"LEFT JOIN CUSTOMERS ON TICKETS.CUSTOMER = CUSTOMERS.ID " +
                "WHERE ?(QBF_FILTER) " +
                "ORDER BY RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
paramdates = new com.posics.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.posics.beans.DateUtils.getToday());
report.addQBFFilter(paramdates);
report.addParameter("TICKETS.TICKETTYPE");
report.addQBFFilter(new com.posics.pos.reports.JParamsSalesPayment());

report.addField("TICKET_NO", com.posics.data.loader.Datas.STRING);
report.addField("TICKET_DATE", com.posics.data.loader.Datas.TIMESTAMP);
report.addField("MONEY", com.posics.data.loader.Datas.DOUBLE);
report.addField("CUSTOMER", com.posics.data.loader.Datas.STRING);
report.addField("PAYMENT", com.posics.data.loader.Datas.STRING);
report.addField("HEAD", com.posics.data.loader.Datas.STRING);

return report;