report = new com.posics.pos.reports.PanelReportBean();

report.setTitleKey("Menu.SalesTaxLog");
report.setReport("/com/posics/reports/salestaxlog");
report.setResourceBundle("com/posics/reports/salestaxlog");

report.setSentence("SELECT TICKETS.TICKETID AS TICKET_NO, RECEIPTS.DATENEW AS TICKET_DATE, " +
" SUM((TICKETLINES.PRICE + TICKETLINES.PRICE * TAXES.RATE) * TICKETLINES.UNITS) AS MONEY, SUM((TICKETLINES.PRICE * TAXES.RATE) * TICKETLINES.UNITS) AS TAX, " +
 " CASE WHEN TICKETS.TICKETTYPE=0 THEN 'SALE' WHEN TICKETS.TICKETTYPE = 1 THEN 'REFUND' END AS HEAD, " +
                "CUSTOMERS.TAXID, CUSTOMERS.NAME FROM RECEIPTS " +
                "JOIN TICKETS ON RECEIPTS.ID = TICKETS.ID AND (TICKETS.TICKETTYPE=0 OR TICKETS.TICKETTYPE=1) "+
                "JOIN TICKETLINES ON TICKETLINES.TICKET = RECEIPTS.ID "+
                "JOIN TAXES ON TICKETLINES.TAXID = TAXES.ID "+
                "LEFT JOIN CUSTOMERS ON TICKETS.CUSTOMER = CUSTOMERS.ID "+
                "WHERE ?(QBF_FILTER) " +
                "GROUP BY RECEIPTS.ID, TICKETS.TICKETID, RECEIPTS.DATENEW, TICKETS.TICKETTYPE, CUSTOMERS.TAXID, CUSTOMERS.NAME " +
                "ORDER BY RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
paramdates = new com.posics.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.posics.beans.DateUtils.getToday());
report.addQBFFilter(paramdates);

report.addField("TICKET_NO", com.posics.data.loader.Datas.STRING);
report.addField("TICKET_DATE", com.posics.data.loader.Datas.TIMESTAMP);
report.addField("MONEY", com.posics.data.loader.Datas.DOUBLE);
report.addField("TAX", com.posics.data.loader.Datas.DOUBLE);
report.addField("HEAD", com.posics.data.loader.Datas.STRING);
report.addField("TAXID", com.posics.data.loader.Datas.STRING);
report.addField("CUSTOMER", com.posics.data.loader.Datas.STRING);

return report;