report = new com.posics.pos.reports.PanelReportBean();

report.setTitleKey("Menu.SalesTaxLogDaily");
report.setReport("/com/posics/reports/salestaxlogdaily");
report.setResourceBundle("com/posics/reports/salestaxlogdaily");

report.setSentence("SELECT DATE(RECEIPTS.DATENEW) AS TICKET_DATE, " +
"SUM((TICKETLINES.PRICE + TICKETLINES.PRICE * TAXES.RATE) * TICKETLINES.UNITS) AS MONEY, " +
"SUM((TICKETLINES.PRICE * TAXES.RATE ) * TICKETLINES.UNITS) AS TAX " +
"FROM RECEIPTS " +
"LEFT JOIN TICKETS ON RECEIPTS.ID = TICKETS.ID AND (TICKETS.TICKETTYPE=0 OR TICKETS.TICKETTYPE=1) " +
"JOIN TICKETLINES ON TICKETLINES.TICKET = RECEIPTS.ID " +
"JOIN TAXES ON TICKETLINES.TAXID = TAXES.ID "+
                "WHERE ?(QBF_FILTER) " +
                "GROUP BY DATE(RECEIPTS.DATENEW) " +
                "ORDER BY DATE(RECEIPTS.DATENEW)");
report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
paramdates = new com.posics.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.posics.beans.DateUtils.getToday());
report.addQBFFilter(paramdates);

report.addField("TICKET_DATE", com.posics.data.loader.Datas.TIMESTAMP);
report.addField("MONEY", com.posics.data.loader.Datas.DOUBLE);
report.addField("TAX", com.posics.data.loader.Datas.DOUBLE);

return report;