//    Posics Saleculator - Billing System.
//    Copyright (C) Posics.
//    http://www.posics.com
//
report = new com.posics.pos.reports.PanelReportBean();

report.setTitleKey("Menu.StockDiary");
report.setReport("/com/posics/reports/stockdiary");
report.setResourceBundle("com/posics/reports/stockdiary_messages");

report.setSentence("SELECT " +
                "LOCATIONS.ID AS LOCATIONID, LOCATIONS.NAME AS LOCATIONNAME, " +
                "PRODUCTS.CODE, PRODUCTS.NAME, " +
                "STOCKDIARY.ATTRIBUTESETINSTANCE_ID, ATTRIBUTESETINSTANCE.DESCRIPTION, " +
                "PRODUCTS.CATEGORY, CATEGORIES.NAME AS CATEGORYNAME, " +
"STOCKDIARY.DATENEW AS DATEIN, " +
"STOCKDIARY.UNITS AS UNITS, " +
                "STOCKDIARY.PRICE AS PRICE, " +
                "STOCKDIARY.UNITS * STOCKDIARY.PRICE AS TOTAL " +
                "FROM STOCKDIARY " +
                "JOIN LOCATIONS ON STOCKDIARY.LOCATION = LOCATIONS.ID " +
                "JOIN PRODUCTS ON PRODUCTS.ID = STOCKDIARY.PRODUCT " +
                "LEFT OUTER JOIN SUPPLIERS ON SUPPLIERS.ID = STOCKDIARY.SUPPLIER " +
                "LEFT OUTER JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID " +
                "LEFT OUTER JOIN ATTRIBUTESETINSTANCE ON STOCKDIARY.ATTRIBUTESETINSTANCE_ID = ATTRIBUTESETINSTANCE.ID " +
                "WHERE ?(QBF_FILTER) " +
                "ORDER BY LOCATIONS.ID, STOCKDIARY.DATENEW, CATEGORIES.NAME, PRODUCTS.NAME");
report.addParameter("STOCKDIARY.DATENEW");
report.addParameter("STOCKDIARY.DATENEW");
paramdates = new com.posics.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.posics.beans.DateUtils.getToday());
report.addQBFFilter(paramdates);

report.addParameter("LOCATIONS.ID");
report.addQBFFilter(new com.posics.pos.reports.JParamsLocationWithFirst());
report.addParameter("STOCKDIARY.REASON");
report.addQBFFilter(new com.posics.pos.reports.JParamsReason());

report.addParameter("PRODUCTS.NAME");
report.addParameter("PRODUCTS.CATEGORY");
report.addParameter("PRODUCTS.CODE");
report.addQBFFilter(new com.posics.pos.reports.JParamsProduct(false));

report.addParameter("SUPPLIERS.ID");
report.addParameter("SUPPLIERS.NAME");
report.addQBFFilter(new com.posics.pos.reports.JParamsSupplier());

report.addField("LOCATIONID", com.posics.data.loader.Datas.STRING);
report.addField("LOCATIONNAME", com.posics.data.loader.Datas.STRING);
report.addField("CODE", com.posics.data.loader.Datas.STRING);
report.addField("NAME", com.posics.data.loader.Datas.STRING);
report.addField("ATTINSTANCEID", com.posics.data.loader.Datas.STRING);
report.addField("ATTINSTANCEDESC", com.posics.data.loader.Datas.STRING);
report.addField("CATEGORY", com.posics.data.loader.Datas.STRING);
report.addField("CATEGORYNAME", com.posics.data.loader.Datas.STRING);
report.addField("DATEIN", com.posics.data.loader.Datas.TIMESTAMP);
report.addField("UNITS", com.posics.data.loader.Datas.DOUBLE);
report.addField("PRICE", com.posics.data.loader.Datas.DOUBLE);
report.addField("TOTAL", com.posics.data.loader.Datas.DOUBLE);

report;

