//    Posics Saleculator - Billing System.
//    Copyright (C) Posics.
//    http://www.posics.com
//

report = new com.posics.pos.reports.PanelReportBean();

report.setTitleKey("Menu.SuppliersDiary");
report.setReport("/com/posics/reports/suppliersdiary");
report.setResourceBundle("com/posics/reports/suppliersdiary_messages");

report.setSentence("SELECT * FROM (SELECT PURCHASEINVOICE.DELIVERYDATE AS DATENEW, PURCHASEINVOICE.REFERENCE AS TICKETID, 'Purchase' AS PAYMENT, SUM(PURCHASEINVOICETAXES.BASEAMOUNT+PURCHASEINVOICETAXES.TAXAMOUNT) AS TOTAL, SUPPLIERS.SEARCHKEY, SUPPLIERS.NAME AS SUPPLIERNAME, SUPPLIERS.ID AS SID, SUPPLIERS.TAXCATEGORY " +
                 "FROM PURCHASEINVOICE, SUPPLIERS, PURCHASEINVOICETAXES WHERE PURCHASEINVOICE.SUPPLIERID = SUPPLIERS.ID AND PURCHASEINVOICE.ID=PURCHASEINVOICETAXES.PIID AND PURCHASEINVOICE.STATUS=2 " +
                 "GROUP BY PURCHASEINVOICE.ID, PURCHASEINVOICE.DELIVERYDATE, PURCHASEINVOICE.REFERENCE, SUPPLIERS.SEARCHKEY, SUPPLIERS.NAME, SUPPLIERS.ID, SUPPLIERS.TAXCATEGORY " +
                 "UNION " +
                 "SELECT RECEIPTS.DATENEW AS DATENEW, CAST(TICKETS.TICKETID AS CHAR(50)), PAYMENT, PAYMENTS.TOTAL, SUPPLIERS.SEARCHKEY, SUPPLIERS.NAME AS SUPPLIERNAME, SUPPLIERS.ID AS SID, SUPPLIERS.TAXCATEGORY " +
                 "FROM RECEIPTS, TICKETS, SUPPLIERS, PAYMENTS WHERE RECEIPTS.ID = TICKETS.ID AND RECEIPTS.ID = PAYMENTS.RECEIPT AND TICKETS.SUPPLIER = SUPPLIERS.ID " +
                 "AND TICKETS.SUPPLIER=SUPPLIERS.ID " +
                 ") AS A " +
                 "WHERE ?(QBF_FILTER) " +
                 "ORDER BY SUPPLIERNAME, DATENEW ");
report.addParameter("SID");
report.addParameter("SUPPLIERNAME");
report.addQBFFilter(new com.posics.pos.reports.JParamsSupplier());

report.addParameter("DATENEW");
report.addParameter("DATENEW");
paramdates = new com.posics.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.posics.beans.DateUtils.getToday());
report.addQBFFilter(paramdates);

report.addParameter("TAXCATEGORY");
report.addQBFFilter(new com.posics.pos.reports.JParamsCustomerCategory());

report.addField("DATENEW", com.posics.data.loader.Datas.TIMESTAMP);
report.addField("TICKETID", com.posics.data.loader.Datas.STRING);
report.addField("PAYMENT", com.posics.data.loader.Datas.STRING);
report.addField("TOTAL", com.posics.data.loader.Datas.DOUBLE);
report.addField("SEARCHKEY", com.posics.data.loader.Datas.STRING);
report.addField("NAME", com.posics.data.loader.Datas.STRING);

report;

