

report = new com.posics.pos.reports.PanelReportBean();

report.setTitleKey("Menu.TaxCatSales");
report.setReport("/com/posics/reports/taxcatsales");
report.setResourceBundle("com/posics/reports/taxcatsales_messages");

report.setSentence(
	"SELECT " +
		"TAXES.NAME AS TAXNAME, CATEGORIES.NAME, " +
		"SUM(TICKETLINES.UNITS) AS QTY, " +
		"SUM(TICKETLINES.PRICE * TICKETLINES.UNITS) AS CATPRICE, " +
		"SUM((TICKETLINES.PRICE * TAXES.RATE ) * TICKETLINES.UNITS) AS CATTAX, "+
		"SUM((TICKETLINES.PRICE + TICKETLINES.PRICE * TAXES.RATE ) * TICKETLINES.UNITS) " +
		"AS CATTOTAL " +
		"FROM RECEIPTS " +
                "JOIN TICKETS ON RECEIPTS.ID = TICKETS.ID AND (TICKETS.TICKETTYPE=0 OR TICKETS.TICKETTYPE=1)  " +
                "JOIN TICKETLINES ON TICKETLINES.TICKET = RECEIPTS.ID  " +
                "JOIN TAXES ON TICKETLINES.TAXID = TAXES.ID  " +
                "LEFT OUTER JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID  " +
                "LEFT OUTER JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID  " +
		"WHERE ?(QBF_FILTER) " +
		"GROUP BY TAXES.NAME, CATEGORIES.NAME " +
		"ORDER BY TAXES.NAME, CATEGORIES.NAME");

report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
paramdates = new com.posics.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.posics.beans.DateUtils.getToday());
report.addQBFFilter(paramdates);

report.addField("TAXNAME", com.posics.data.loader.Datas.STRING);
report.addField("NAME", com.posics.data.loader.Datas.STRING);
report.addField("QTY", com.posics.data.loader.Datas.STRING);
report.addField("CATPRICE", com.posics.data.loader.Datas.DOUBLE);
report.addField("CATTAX", com.posics.data.loader.Datas.DOUBLE);
report.addField("CATTOTAL", com.posics.data.loader.Datas.DOUBLE);

report;