/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.luna.LunaLookAndFeel;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JRootPane;
import javax.swing.plaf.ColorUIResource;

public class LunaTitlePane
extends BaseTitlePane {
    public LunaTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    protected int getHorSpacing() {
        return 2;
    }

    protected int getVerSpacing() {
        return 5;
    }

    public void createButtons() {
        this.iconifyButton = new BaseTitleButton(this.iconifyAction, "Iconify", this.iconifyIcon, 1.0f);
        this.maxButton = new BaseTitleButton(this.restoreAction, "Maximize", this.maximizeIcon, 1.0f);
        this.closeButton = new BaseTitleButton(this.closeAction, "Close", this.closeIcon, 1.0f);
    }

    public void paintBorder(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
        } else {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0));
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        if (this.getFrame() != null) {
            this.setState(DecorationHelper.getExtendedState(this.getFrame()));
        }
        this.paintBackground(graphics);
        boolean bl = this.isLeftToRight();
        boolean bl2 = this.window == null ? true : JTattooUtilities.isWindowActive(this.window);
        ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowInactiveTitleForegroundColor();
        if (bl2) {
            colorUIResource = AbstractLookAndFeel.getWindowTitleForegroundColor();
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n2 - this.buttonsWidth - 4;
        int n5 = n = bl ? 4 : n2 - 4;
        if (this.getWindowDecorationStyle() == 1) {
            int n6 = this.menuBar.getWidth() + 4;
            n += bl ? n6 : -n6;
            n4 -= n3;
        }
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = JTattooUtilities.getClippedText(this.getTitle(), fontMetrics, n4);
        if (string != null) {
            int n7 = fontMetrics.stringWidth(string);
            int n8 = (n3 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() - 1;
            if (!bl) {
                n -= n7;
            }
            if (bl2) {
                graphics.setColor(LunaLookAndFeel.getTheme().getWindowBorderColor());
                JTattooUtilities.drawString(this.rootPane, graphics, string, n - 1, n8 - 1);
                JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n8 + 1);
            }
            graphics.setColor(colorUIResource);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n8);
            this.paintText(graphics, n, n8, string);
        }
    }
}

