/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class McWinBorders
extends BaseBorders {
    private static Border buttonBorder = null;
    private static Border rolloverToolButtonBorder = null;
    private static Border internalFrameBorder = null;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return McWinBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = this.isActive(component);
            boolean bl2 = this.isResizable(component);
            int n5 = this.getTitleHeight(component);
            ColorUIResource colorUIResource = McWinLookAndFeel.getWindowInactiveBorderColor();
            ColorUIResource colorUIResource2 = McWinLookAndFeel.getWindowInactiveTitleColorLight();
            ColorUIResource colorUIResource3 = McWinLookAndFeel.getWindowInactiveTitleColorDark();
            if (bl) {
                colorUIResource = McWinLookAndFeel.getWindowBorderColor();
                colorUIResource2 = McWinLookAndFeel.getWindowTitleColorLight();
                colorUIResource3 = McWinLookAndFeel.getWindowTitleColorDark();
            }
            if (!bl2) {
                Insets insets = this.getBorderInsets(component);
                graphics.setColor(colorUIResource);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                if (bl) {
                    graphics.setColor(McWinLookAndFeel.getWindowTitleColorDark());
                } else {
                    graphics.setColor(McWinLookAndFeel.getWindowInactiveTitleColorDark());
                }
                for (int i = 1; i < insets.left; ++i) {
                    graphics.drawRect(i, i, n3 - 2 * i - 1, n4 - 2 * i - 1);
                }
                graphics.setColor(ColorHelper.brighter(colorUIResource, 20.0));
                graphics.drawLine(insets.left - 1, n2 + n5 + insets.top, insets.left - 1, n2 + n4 - insets.bottom);
                graphics.drawLine(n3 - insets.right, n2 + n5 + insets.top, n3 - insets.right, n2 + n4 - insets.bottom);
                graphics.drawLine(insets.left - 1, n2 + n4 - insets.bottom, n3 - insets.right, n2 + n4 - insets.bottom);
                return;
            }
            graphics.setColor(colorUIResource2);
            graphics.fillRect(n, n2 + 1, n3, 4);
            graphics.setColor(colorUIResource3);
            graphics.fillRect(n + 1, n2 + n4 - 5, n3 - 2, 4);
            if (bl) {
                JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getWindowTitleColors(), 1, 5, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getWindowTitleColors(), n3 - 5, 5, 5, n5 + 1);
            } else {
                JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, 5, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getWindowInactiveTitleColors(), n3 - 5, 5, 5, n5 + 1);
            }
            graphics.setColor(colorUIResource3);
            graphics.fillRect(1, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.fillRect(n3 - 5, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.setColor(ColorHelper.darker(colorUIResource, 10.0));
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n + 5 - 1, n2 + 5 + n5, n + 5 - 1, n2 + n4 - 5);
            graphics.drawLine(n + n3 - 5, n2 + 5 + n5, n + n3 - 5, n2 + n4 - 5);
            graphics.drawLine(n + 5 - 1, n2 + n4 - 5, n + n3 - 5, n2 + n4 - 5);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);
        private static final Color HICOLOR = new Color(192, 192, 192);
        private static final Color LOCOLOR = new Color(164, 164, 164);
        private static final Color ROLLOVER_HICOLOR = new Color(144, 225, 181);
        private static final Color ROLLOVER_LOCOLOR = new Color(124, 195, 160);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                JTattooUtilities.draw3DBorder(graphics, LOCOLOR, HICOLOR, n, n2, n3 - 1, n4);
            } else if (buttonModel.isRollover()) {
                JTattooUtilities.draw3DBorder(graphics, ROLLOVER_HICOLOR, ROLLOVER_LOCOLOR, n, n2, n3 - 1, n4);
            } else {
                graphics.setColor(Color.lightGray);
                graphics.drawRect(n, n2, n3 - 2, n4 - 1);
            }
            graphics.setColor(Color.white);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 12, 2, 12);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

