/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.event.ActionEvent;
import java.io.InputStream;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.view.JRViewer;

public class JRDesignViewer
extends JRViewer {
    private static final long serialVersionUID = 10200L;

    public JRDesignViewer(String fileName, boolean isXML) throws JRException {
        super(fileName, isXML);
        this.hideUnusedComponents();
    }

    public JRDesignViewer(InputStream is, boolean isXML) throws JRException {
        super(is, isXML);
        this.hideUnusedComponents();
    }

    public JRDesignViewer(JRReport report) throws JRException {
        super(new ReportConverter(report, false, true).getJasperPrint());
        this.hideUnusedComponents();
    }

    private void hideUnusedComponents() {
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrevious.setVisible(false);
        this.btnNext.setVisible(false);
        this.txtGoTo.setVisible(false);
        this.pnlStatus.setVisible(false);
    }

    void btnReloadActionPerformed(ActionEvent evt) {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
                this.forceRefresh();
            }
            catch (JRException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading report design. See console for details.");
            }
        }
    }

    protected void loadReport(String fileName, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(fileName);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(fileName));
        }
        this.type = 1;
        this.isXML = isXmlReport;
        this.reportFileName = fileName;
    }

    protected void loadReport(InputStream is, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(is);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(is));
        }
        this.type = 2;
        this.isXML = isXmlReport;
    }

    public void loadReport(JRReport rep) throws JRException {
        this.setReport(rep);
        this.type = 3;
        this.isXML = false;
    }

    private void setReport(JRReport report) throws JRException {
        this.jasperPrint = new ReportConverter(report, false, true).getJasperPrint();
    }

    protected JRGraphics2DExporter getGraphics2DExporter() throws JRException {
        return new JRGraphics2DExporter(){

            protected void setDrawers() {
                super.setDrawers();
                this.frameDrawer.setClip(true);
            }
        };
    }
}

