/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.eventusermodel.HSSFRecordStream;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HSSFEventFactory {
    public void processWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException {
        DocumentInputStream in = fs.createDocumentInputStream("Workbook");
        this.processEvents(req, in);
    }

    public short abortableProcessWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException, HSSFUserException {
        DocumentInputStream in = fs.createDocumentInputStream("Workbook");
        return this.abortableProcessEvents(req, in);
    }

    public void processEvents(HSSFRequest req, InputStream in) throws IOException {
        try {
            this.genericProcessEvents(req, new RecordInputStream(in));
        }
        catch (HSSFUserException hSSFUserException) {
            // empty catch block
        }
    }

    public short abortableProcessEvents(HSSFRequest req, InputStream in) throws IOException, HSSFUserException {
        return this.genericProcessEvents(req, new RecordInputStream(in));
    }

    protected short genericProcessEvents(HSSFRequest req, RecordInputStream in) throws IOException, HSSFUserException {
        boolean going = true;
        short userCode = 0;
        Record r = null;
        HSSFRecordStream recordStream = new HSSFRecordStream(in);
        while (going) {
            r = recordStream.nextRecord();
            if (r != null) {
                userCode = req.processRecord(r);
                if (userCode == 0) continue;
                break;
            }
            going = false;
        }
        return userCode;
    }
}

