/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class ExternalNameRecord
extends Record {
    private static final Ptg[] EMPTY_PTG_ARRAY = new Ptg[0];
    public static final short sid = 35;
    private static final int OPT_BUILTIN_NAME = 1;
    private static final int OPT_AUTOMATIC_LINK = 2;
    private static final int OPT_PICTURE_LINK = 4;
    private static final int OPT_STD_DOCUMENT_NAME = 8;
    private static final int OPT_OLE_LINK = 16;
    private static final int OPT_ICONIFIED_PICTURE_LINK = 32768;
    private short field_1_option_flag;
    private short field_2_index;
    private short field_3_not_used;
    private String field_4_name;
    private Ptg[] field_5_name_definition;

    public boolean isBuiltInName() {
        return (this.field_1_option_flag & 1) != 0;
    }

    public boolean isAutomaticLink() {
        return (this.field_1_option_flag & 2) != 0;
    }

    public boolean isPicureLink() {
        return (this.field_1_option_flag & 4) != 0;
    }

    public boolean isStdDocumentNameIdentifier() {
        return (this.field_1_option_flag & 8) != 0;
    }

    public boolean isOLELink() {
        return (this.field_1_option_flag & 0x10) != 0;
    }

    public boolean isIconifiedPictureLink() {
        return (this.field_1_option_flag & 0x8000) != 0;
    }

    public String getText() {
        return this.field_4_name;
    }

    private int getDataSize() {
        int result = 8 + this.field_4_name.length();
        if (this.hasFormula()) {
            result += 2 + this.getNameDefinitionSize();
        }
        return result;
    }

    public int serialize(int offset, byte[] data) {
        int dataSize = this.getDataSize();
        LittleEndian.putShort(data, 0 + offset, (short)35);
        LittleEndian.putShort(data, 2 + offset, (short)dataSize);
        LittleEndian.putShort(data, 4 + offset, this.field_1_option_flag);
        LittleEndian.putShort(data, 6 + offset, this.field_2_index);
        LittleEndian.putShort(data, 8 + offset, this.field_3_not_used);
        int nameLen = this.field_4_name.length();
        LittleEndian.putUShort(data, 10 + offset, nameLen);
        StringUtil.putCompressedUnicode(this.field_4_name, data, 12 + offset);
        if (this.hasFormula()) {
            int defLen = this.getNameDefinitionSize();
            LittleEndian.putUShort(data, 12 + nameLen + offset, defLen);
            Ptg.serializePtgs(this.field_5_name_definition, data, 14 + nameLen + offset);
        }
        return dataSize + 4;
    }

    private int getNameDefinitionSize() {
        return Ptg.getEncodedSize(this.field_5_name_definition);
    }

    public int getRecordSize() {
        return 4 + this.getDataSize();
    }

    public ExternalNameRecord(RecordInputStream in) {
        this.field_1_option_flag = in.readShort();
        this.field_2_index = in.readShort();
        this.field_3_not_used = in.readShort();
        short nameLength = in.readShort();
        this.field_4_name = in.readCompressedUnicode(nameLength);
        if (!this.hasFormula()) {
            if (in.remaining() > 0) {
                throw this.readFail("Some unread data (is formula present?)");
            }
            this.field_5_name_definition = EMPTY_PTG_ARRAY;
            return;
        }
        if (in.remaining() <= 0) {
            throw this.readFail("Ran out of record data trying to read formula.");
        }
        short formulaLen = in.readShort();
        this.field_5_name_definition = Ptg.readTokens(formulaLen, in);
    }

    private RuntimeException readFail(String msg) {
        String fullMsg = msg + " fields: (option=" + this.field_1_option_flag + " index=" + this.field_2_index + " not_used=" + this.field_3_not_used + " name='" + this.field_4_name + "')";
        return new RuntimeException(fullMsg);
    }

    private boolean hasFormula() {
        return !this.isAutomaticLink();
    }

    public short getSid() {
        return 35;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" [EXTERNALNAME ");
        sb.append(" ").append(this.field_4_name);
        sb.append(" ix=").append(this.field_2_index);
        sb.append("]");
        return sb.toString();
    }
}

