/*
 * Decompiled with CFR 0.152.
 */
package com.codeminders.hidapi;

import com.codeminders.hidapi.HIDDevice;
import com.codeminders.hidapi.HIDManager;
import java.io.IOException;
import java.util.Observable;

public class AD101
extends Observable
implements Runnable {
    private static final long READ_UPDATE_DELAY_MS = 50L;
    HIDDevice dev;
    HIDManager hid_mgr = HIDManager.getInstance();
    int iLineId = 0;
    private static final int BUFSIZE = 2048;

    public AD101(String path, int lineid) throws Exception {
        this.dev = this.hid_mgr.openByPath(path);
        this.iLineId = lineid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        byte[] buffer = new byte[2048];
        StringBuilder sbRaw = new StringBuilder();
        StringBuilder sbData = new StringBuilder();
        String sCallerId = "";
        String sMessage = "";
        Boolean bCallerId = false;
        Boolean bMessage = false;
        block15: while (true) {
            try {
                while (true) {
                    sbRaw = new StringBuilder();
                    int n = this.dev.read(buffer);
                    for (int i = 0; i < n; ++i) {
                        int v = buffer[i];
                        if (v < 0) {
                            v += 256;
                        }
                        String hs = Integer.toHexString(v);
                        if (v < 16) {
                            hs = "0" + hs;
                        }
                        sbRaw.append(hs);
                    }
                    if (sbRaw.length() == 16) {
                        String sDat = sbRaw.substring(0, 2);
                        String sStat = sbRaw.substring(8, 10);
                        if (sDat.equals("aa")) {
                            if (bCallerId.booleanValue() && sbData.length() >= 16) {
                                bCallerId = false;
                                String sCallerIdType = sbData.substring(8, 10);
                                if (sCallerIdType.equals("80")) {
                                    sCallerId = AD101.readMDMF(sbData);
                                } else if (sCallerIdType.equals("04")) {
                                    sCallerId = AD101.readSDMF(sbData);
                                }
                                if (sCallerId.trim().length() > 0) {
                                    this.notifyParent(sCallerId);
                                }
                                sCallerId = "";
                                sbData = new StringBuilder();
                            } else if (bMessage.booleanValue()) {
                                sMessage = "";
                                bMessage = false;
                                sbData = new StringBuilder();
                            }
                            if (sStat.equals("0b")) {
                                this.notifyParent("0b");
                            } else if (sStat.equals("09")) {
                                this.notifyParent("09");
                            } else if (sStat.equals("07")) {
                                this.notifyParent("07");
                            } else if (sStat.equals("08")) {
                                this.notifyParent("08");
                            } else if (sStat.equals("06")) {
                                bMessage = true;
                                bCallerId = false;
                            } else if (sStat.equals("82")) {
                                bMessage = true;
                                bCallerId = false;
                            } else if (sStat.equals("81")) {
                                bMessage = true;
                                bCallerId = false;
                            } else if (sStat.equals("80") || sStat.equals("04")) {
                                sbData.append((CharSequence)sbRaw);
                                bCallerId = true;
                                bMessage = false;
                            }
                        } else {
                            sbData.append((CharSequence)sbRaw);
                        }
                    }
                    try {
                        Thread.sleep(50L);
                        continue block15;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ee) {
                this.notifyParent("00");
                try {
                    this.dev.close();
                    this.hid_mgr.release();
                    System.gc();
                    return;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                return;
            }
            catch (Exception e) {
                try {
                    System.err.println(e.getMessage());
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        this.dev.close();
                        this.hid_mgr.release();
                        System.gc();
                    }
                    catch (Exception e2) {
                        System.err.println(e2.getMessage());
                    }
                }
            }
            continue;
            break;
        }
    }

    private void notifyParent(String lstate) {
        this.setChanged();
        this.notifyObservers(lstate);
    }

    private static String readMDMF(StringBuilder sbData) {
        try {
            Integer iDataLength = 0;
            Integer iCidLength = 0;
            String telnumber = "";
            iDataLength = Integer.parseInt(sbData.substring(10, 12), 16);
            String next = "";
            if (sbData.length() >= iDataLength * 2 + 12) {
                for (int pos = 12; iDataLength * 2 + 12 > pos; pos += 2) {
                    next = sbData.substring(pos, pos + 2);
                    if (!next.equals("02")) continue;
                    iCidLength = Integer.parseInt(sbData.substring(pos += 2, pos + 2), 16);
                    if (sbData.length() <= (pos += 2) + iCidLength * 2) continue;
                    String rawnumber = sbData.substring(pos, pos + iCidLength * 2);
                    for (int rawi = 1; rawi < rawnumber.length(); rawi += 2) {
                        telnumber = telnumber + rawnumber.charAt(rawi);
                    }
                    pos += iCidLength * 2;
                }
            }
            return telnumber;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String readMDMF2(StringBuilder sbData) {
        try {
            Integer iDataLength = 0;
            Integer iCidLength = 0;
            String telnumber = "";
            iDataLength = Integer.parseInt(sbData.substring(6, 8), 16);
            String next = "";
            if (sbData.length() >= iDataLength * 2 + 12) {
                for (int pos = 8; iDataLength * 2 + 14 > pos; pos += 2) {
                    next = sbData.substring(pos, pos + 2);
                    next = next.replace('a', '0');
                    telnumber = telnumber + next.substring(1, 2);
                }
            }
            return telnumber;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String readSDMF(StringBuilder sbData) {
        try {
            Integer iDataLength = 0;
            String telnumber = "";
            iDataLength = Integer.parseInt(sbData.substring(10, 12), 16);
            if (sbData.length() >= iDataLength * 2 + 12) {
                String rawnumber = sbData.substring(28, iDataLength * 2 + 12);
                for (int rawi = 1; rawi < rawnumber.length(); rawi += 2) {
                    telnumber = telnumber + rawnumber.charAt(rawi);
                }
            }
            return telnumber;
        }
        catch (Exception e) {
            return "";
        }
    }

    public int getLineId() {
        return this.iLineId;
    }
}

