/*
 * Decompiled with CFR 0.152.
 */
package com.codeminders.hidapi;

import com.codeminders.hidapi.AD800;
import com.codeminders.hidapi.HIDDevice;
import com.codeminders.hidapi.HIDManager;
import com.codeminders.hidapi.LineMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.TimeUnit;

public class AD102
extends Observable
implements Runnable {
    public static final String TAG = "USBController";
    HIDDevice dev;
    HIDManager hid_mgr;
    int iLineId = 0;
    public static AD800 channel;
    public static String DeviceSN;
    public static String DeviceVer;
    public List<byte[]> m_ReadBuffList = new ArrayList<byte[]>();
    public List<byte[]> m_WriteBuffList = new ArrayList<byte[]>();
    private static final Object[] sWriteLock;
    private static final Object[] sReadLock;
    public byte m_DataPackIndex = 0;
    private int m_MemBuffLen = 0;
    private byte[] m_MemBuffer = new byte[256];
    private UsbReadRunnable mReadLoop;
    private UsbRunnable mLoop;
    private CountRunnable mCountLoop;
    private Thread mUsbThread;
    private Thread mUsbReadThread;
    private Thread mUsbWriteThread;
    private Thread mCountThread;
    private boolean mStop = false;

    public AD102(String path, int lineid) throws Exception {
        channel = new AD800(this);
        this.hid_mgr = HIDManager.getInstance();
        this.dev = this.hid_mgr.openByPath(path);
        this.iLineId = lineid;
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int iLen = 0;
        int iPos = 0;
        int iChannel = 0;
        try {
            while (!this.mStop) {
                try {
                    byte[] readBuff;
                    block20: {
                        block19: {
                            try {
                                if (!this.IsThereAnyReceivedData()) {
                                    this.Sleep(1);
                                }
                                break block19;
                            }
                            catch (Exception e) {
                                this.e("IsThereAnyReceivedData: " + e.getMessage());
                                this.Sleep(1);
                            }
                            continue;
                        }
                        readBuff = null;
                        try {
                            readBuff = this.GetReceivedDataFromQueue();
                            if (readBuff == null) {
                                this.Sleep(1);
                            }
                            break block20;
                        }
                        catch (Exception e) {
                            this.Sleep(1);
                        }
                        continue;
                    }
                    try {
                        iLen = readBuff[1] - 4;
                        iChannel = readBuff[3] & 0x7F;
                        iPos = 6;
                        if (iChannel < 0 || iChannel >= 8 || iLen < 0) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        this.e("UsbRunnable Middle: " + e.getMessage());
                    }
                    if (this.mStop) break;
                    try {
                        channel.GetVoltage(readBuff[4] * 256 + readBuff[5] & 0xFFFF);
                    }
                    catch (Exception e) {
                        this.e("UsbRunnable Voltage: " + e.getMessage());
                    }
                    try {
                        byte szPacketLen;
                        while (iLen > 0 && (szPacketLen = readBuff[iPos + 1]) < iLen) {
                            this.AnalyseCommand(iChannel, readBuff, iPos, szPacketLen + 2);
                            iLen -= szPacketLen + 2;
                            iPos += szPacketLen + 2;
                        }
                    }
                    catch (Exception e) {
                        this.e("UsbRunnable Analyze;" + e.getLocalizedMessage());
                    }
                }
                catch (Exception e) {
                    this.e("UsbRunnable Exception:" + e.getLocalizedMessage());
                }
            }
            this.dev.close();
            this.hid_mgr.release();
            System.gc();
            return;
        }
        catch (Exception e) {
            this.e("UsbRunnable out Exception:" + e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsThereAnyReceivedData() {
        Object[] objectArray = sReadLock;
        synchronized (sReadLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !this.m_ReadBuffList.isEmpty();
        }
    }

    public AD800 getChannel() {
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsThereAnySentData() {
        Object[] objectArray = sWriteLock;
        synchronized (sWriteLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !this.m_WriteBuffList.isEmpty();
        }
    }

    public void SendDeviceCheckControlCmd() {
        byte[] mSendBuffer = new byte[64];
        for (int i = 0; i < 64; ++i) {
            mSendBuffer[i] = 0;
        }
        mSendBuffer[0] = 2;
        mSendBuffer[1] = 7;
        mSendBuffer[2] = this.m_DataPackIndex;
        mSendBuffer[3] = 0;
        mSendBuffer[4] = 0;
        mSendBuffer[5] = 0;
        mSendBuffer[6] = 48;
        mSendBuffer[7] = 1;
        mSendBuffer[8] = -1;
        this.m_WriteBuffList.add(mSendBuffer);
        this.m_DataPackIndex = (byte)(this.m_DataPackIndex + 1);
        if (this.m_DataPackIndex > 255) {
            this.m_DataPackIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] GetSentDataFromQueue() {
        try {
            Object[] objectArray = sWriteLock;
            synchronized (sWriteLock) {
                byte[] res = new byte[64];
                res = this.m_WriteBuffList.get(0);
                this.m_WriteBuffList.remove(0);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return res;
            }
        }
        catch (Exception e) {
            this.e("GetWriteDataFromQueue exception " + e.getLocalizedMessage());
            this.m_WriteBuffList.remove(0);
            return null;
        }
    }

    private void Sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void l(Object msg) {
        System.out.println("USBController>==< " + msg.toString() + " >==<");
    }

    public void e(Object msg) {
        System.err.println("USBController>==< " + msg.toString() + " >==<");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] GetReceivedDataFromQueue() {
        try {
            Object[] objectArray = sReadLock;
            synchronized (sReadLock) {
                byte[] res = new byte[64];
                res = this.m_ReadBuffList.get(0);
                this.m_ReadBuffList.remove(0);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return res;
            }
        }
        catch (Exception e) {
            this.m_ReadBuffList.remove(0);
            return null;
        }
    }

    private void AnalyseCommand(int iChannel, byte[] pszData, int iPos, int iLen) {
        if (iChannel < 0 || iChannel >= 8) {
            return;
        }
        switch (pszData[iPos]) {
            case 48: {
                if (pszData[iPos + 2] != 0) break;
                this.AnalyseACKCommand(iChannel, pszData, iPos + 3, pszData[iPos + 1] - 1);
                break;
            }
            case 49: {
                channel.FskData(pszData, iPos + 2, pszData[1 + iPos]);
                break;
            }
            case 50: {
                channel.DTMFData(pszData, iPos + 2, pszData[1 + iPos]);
                break;
            }
        }
    }

    void AnalyseACKCommand(int iChannel, byte[] pszData, int iPos, int iLen) {
        switch (pszData[iPos]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                String DeviceVer = "";
                for (int i = 1; i < iLen; ++i) {
                    DeviceVer = i == iLen - 1 ? DeviceVer + pszData[iPos + i] : DeviceVer + pszData[iPos + i] + ".";
                }
                this.getChannel().Version = DeviceVer;
                this.notifyParent(new LineMessage(this.getLineId(), 0, 0));
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                int iDataLen = iLen - 1;
                if (iDataLen < 1) break;
                if (this.m_MemBuffLen + iDataLen <= 128) {
                    System.arraycopy(pszData, iPos + 1, this.m_MemBuffer, this.m_MemBuffLen, iDataLen);
                    this.m_MemBuffLen += iDataLen;
                }
                if (this.m_MemBuffLen < 128) break;
                int m_SN = 0;
                this.m_MemBuffLen = 0;
                m_SN = this.m_MemBuffer[1] & 0xFF;
                m_SN |= (this.m_MemBuffer[2] & 0xFF) << 8;
                m_SN |= (this.m_MemBuffer[3] & 0xFF) << 16;
                if ((m_SN |= (this.m_MemBuffer[4] & 0xFF) << 24) == -1) break;
                this.getChannel().Serial = DeviceSN = String.format("%08d", m_SN);
                this.notifyParent(new LineMessage(this.getLineId(), 0, 0));
                break;
            }
            case -1: {
                break;
            }
        }
    }

    public void SendHangUpCommand(int iChannel) {
        this.SendDataToDevice(iChannel, new byte[]{48, 2, 10, 0}, 4);
    }

    void SendDataToDevice(int iChannel, byte[] pBuffer, int Length) {
        int i;
        byte[] pWriteBuff = new byte[64];
        for (i = 0; i < 64; ++i) {
            pWriteBuff[i] = 0;
        }
        pWriteBuff[0] = 2;
        pWriteBuff[1] = (byte)(4 + Length);
        pWriteBuff[2] = this.m_DataPackIndex;
        pWriteBuff[3] = (byte)(iChannel % 8);
        pWriteBuff[4] = 0;
        pWriteBuff[5] = 0;
        for (i = 0; i < Length; ++i) {
            pWriteBuff[6 + i] = pBuffer[i];
        }
        this.m_WriteBuffList.add(pWriteBuff);
        this.m_DataPackIndex = (byte)(this.m_DataPackIndex + 1);
        if (this.m_DataPackIndex > 255) {
            this.m_DataPackIndex = 0;
        }
    }

    public void stop() {
        this.mStop = true;
        this.notifyParent(new LineMessage(this.getLineId(), 1, 1));
        this.Sleep(10);
        if (this.mStop) {
            this.deleteObservers();
            this.mCountThread = null;
            this.mCountLoop = null;
            this.mUsbReadThread = null;
            this.mReadLoop = null;
            this.mUsbThread = null;
            this.mLoop = null;
            channel = null;
            try {
                this.dev.close();
                this.hid_mgr.release();
                System.gc();
            }
            catch (Exception e) {
                this.notifyParent(new LineMessage(this.getLineId(), 1, 1));
            }
        }
        this.l("stop");
    }

    private void start() {
        this.l("start handler");
        try {
            if (this.mLoop != null) {
                this.mStop = false;
                this.l("Running already");
                return;
            }
            this.mLoop = null;
            this.mUsbThread = null;
            this.mReadLoop = null;
            this.mUsbReadThread = null;
            this.mCountLoop = null;
            this.mCountThread = null;
            this.mStop = false;
            if (this.mStop) {
                return;
            }
            this.mReadLoop = new UsbReadRunnable();
            this.mLoop = new UsbRunnable();
            this.mCountLoop = new CountRunnable();
            this.mUsbReadThread = new Thread(this.mReadLoop);
            this.mUsbReadThread.setPriority(10);
            this.mUsbReadThread.start();
            this.mUsbThread = new Thread(this.mLoop);
            this.mUsbThread.setPriority(10);
            this.mUsbThread.start();
            this.mCountThread = new Thread(this.mCountLoop);
            this.mCountThread.setPriority(10);
            this.mCountThread.start();
            this.notifyParent(new LineMessage(this.getLineId(), 1, AD102.channel.m_State));
            this.l("handler init end");
        }
        catch (Exception e) {
            this.e(e);
        }
    }

    private void notifyParent(LineMessage msg) {
        this.setChanged();
        this.notifyObservers(msg);
    }

    public int getLineId() {
        return this.iLineId;
    }

    private void GetSnAndVersion() {
        int cnt = 0;
        while ((DeviceSN == "" || DeviceVer == "") && cnt++ < 1) {
            this.m_DataPackIndex = 0;
            while (this.m_DataPackIndex < 22) {
                if (this.mStop) {
                    return;
                }
                try {
                    byte[] mRecvBuffer = new byte[512];
                    int p = this.dev.read(mRecvBuffer);
                    if (p > 0) {
                        if (mRecvBuffer[0] == 3 && mRecvBuffer[1] > 4) {
                            this.AnalyseCommand(0, mRecvBuffer, 6, mRecvBuffer[7] + 2);
                        }
                        byte[] sendByte = new byte[64];
                        for (int i = 0; i < 64; ++i) {
                            sendByte[i] = 0;
                        }
                        if (this.m_DataPackIndex == 0) {
                            sendByte[0] = 2;
                            sendByte[1] = 7;
                            sendByte[6] = 48;
                            sendByte[7] = 1;
                            sendByte[8] = 3;
                        } else if (this.m_DataPackIndex == 1) {
                            sendByte[0] = 2;
                            sendByte[1] = 9;
                            sendByte[2] = 1;
                            sendByte[6] = 48;
                            sendByte[7] = 3;
                            sendByte[8] = 17;
                            sendByte[9] = 0;
                            sendByte[10] = 30;
                        } else if (this.m_DataPackIndex == 2) {
                            sendByte[0] = 2;
                            sendByte[1] = 9;
                            sendByte[2] = 2;
                            sendByte[6] = 48;
                            sendByte[7] = 3;
                            sendByte[8] = 17;
                            sendByte[9] = 30;
                            sendByte[10] = 30;
                        } else if (this.m_DataPackIndex == 3) {
                            sendByte[0] = 2;
                            sendByte[1] = 9;
                            sendByte[2] = 3;
                            sendByte[6] = 48;
                            sendByte[7] = 3;
                            sendByte[8] = 17;
                            sendByte[9] = 60;
                            sendByte[10] = 30;
                        } else if (this.m_DataPackIndex == 4) {
                            sendByte[0] = 2;
                            sendByte[1] = 9;
                            sendByte[2] = 4;
                            sendByte[6] = 48;
                            sendByte[7] = 3;
                            sendByte[8] = 17;
                            sendByte[9] = 90;
                            sendByte[10] = 30;
                        } else if (this.m_DataPackIndex == 5) {
                            sendByte[0] = 2;
                            sendByte[1] = 9;
                            sendByte[2] = 84;
                            sendByte[6] = 48;
                            sendByte[7] = 3;
                            sendByte[8] = 17;
                            sendByte[9] = 120;
                            sendByte[10] = 8;
                        } else if (this.m_DataPackIndex > 5 && this.m_DataPackIndex < 22) {
                            if (this.m_DataPackIndex % 2 == 0) {
                                sendByte[0] = 2;
                                sendByte[1] = 9;
                                sendByte[2] = this.m_DataPackIndex;
                                sendByte[3] = (byte)((this.m_DataPackIndex - 4) / 2 - 1);
                                sendByte[6] = 48;
                                sendByte[7] = 3;
                                sendByte[8] = 5;
                                sendByte[9] = 11;
                                sendByte[10] = 0;
                            } else {
                                sendByte[0] = 2;
                                sendByte[1] = 9;
                                sendByte[2] = this.m_DataPackIndex;
                                sendByte[3] = (byte)((this.m_DataPackIndex - 5) / 2 - 1);
                                sendByte[6] = 48;
                                sendByte[7] = 3;
                                sendByte[8] = 4;
                                sendByte[9] = 4;
                                sendByte[10] = 32;
                            }
                        }
                        this.dev.write(sendByte);
                    }
                }
                catch (Exception e) {
                    this.e("transfer:" + e.getLocalizedMessage());
                }
                this.m_DataPackIndex = (byte)(this.m_DataPackIndex + 1);
            }
        }
    }

    public static String milliToString(long millis) {
        long hrs = TimeUnit.MILLISECONDS.toHours(millis) % 24L;
        long min = TimeUnit.MILLISECONDS.toMinutes(millis) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(millis) % 60L;
        long mls = millis % 1000L;
        String toRet = String.format("%02d:%02d:%02d.%03d", hrs, min, sec, mls);
        return toRet;
    }

    static {
        DeviceSN = "";
        DeviceVer = "";
        sWriteLock = new Object[0];
        sReadLock = new Object[0];
    }

    private class CountRunnable
    implements Runnable {
        private CountRunnable() {
        }

        @Override
        public void run() {
            while (!AD102.this.mStop) {
                AD102.this.Sleep(10);
                try {
                    AD102.channel.m_CheckVoltageTime += 10;
                    if (4 == AD102.channel.m_State || 5 == AD102.channel.m_State) {
                        AD102.channel.m_RingDuration += 10;
                    }
                    if (6 == AD102.channel.m_State || 7 == AD102.channel.m_State) {
                        AD102.channel.m_CallDuration += 10;
                    }
                    if (AD102.channel.m_CheckVoltageTime >= 100 && AD102.channel.m_VoltageIndex > 0) {
                        int Voltage1 = 0;
                        int Voltage2 = 0;
                        boolean bCheckRing = false;
                        AD102.channel.m_RingOn1 = 0;
                        AD102.channel.m_RingOn2 = 0;
                        Voltage1 = AD102.channel.m_VoltageValue / AD102.channel.m_VoltageIndex;
                        Voltage2 = 0 - Voltage1;
                        AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 2, Voltage1));
                        if (1 == AD102.channel.m_State || 2 == AD102.channel.m_State || 4 == AD102.channel.m_State || 5 == AD102.channel.m_State) {
                            bCheckRing = true;
                        }
                        if (bCheckRing) {
                            for (int j = 0; j < 256; ++j) {
                                if (AD102.channel.m_VoltageArray[j] >= 24) {
                                    ++AD102.channel.m_RingOn1;
                                }
                                if (AD102.channel.m_VoltageArray[j] <= -24) {
                                    ++AD102.channel.m_RingOn2;
                                }
                                AD102.channel.m_VoltageArray[j] = 0;
                            }
                        }
                        AD102.channel.m_CheckVoltageTime = 0;
                        AD102.channel.m_VoltageValue = 0;
                        AD102.channel.m_VoltageIndex = 0;
                        if (bCheckRing && AD102.channel.m_RingOn1 >= 2 && AD102.channel.m_RingOn2 >= 2) {
                            if (!AD102.channel.m_bCheckRingOn) {
                                AD102.channel.m_bCheckRingOn = true;
                                AD102.channel.m_CheckRingOnTime = 0;
                            }
                            if (!AD102.channel.m_bCheckRingOn) continue;
                            AD102.channel.m_CheckRingOnTime += 100;
                            if (AD102.channel.m_CheckRingOnTime < 200) continue;
                            AD102.channel.m_bCheckIdle = false;
                            AD102.channel.m_CheckIdleTime = 0;
                            AD102.channel.m_bCheckPowerOff = false;
                            AD102.channel.m_CheckPowerOffTime = 0;
                            AD102.channel.m_bCheckHookOff = false;
                            AD102.channel.m_CheckHookOffTime = 0;
                            AD102.channel.m_bCheckRingOn = false;
                            AD102.channel.m_CheckRingOnTime = 0;
                            AD102.channel.m_bInbound = true;
                            ++AD102.channel.m_RingCnt;
                            if (4 == AD102.channel.m_State) continue;
                            AD102.channel.m_State = 4;
                            AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 1, AD102.channel.m_State));
                            continue;
                        }
                        if (4 == AD102.channel.m_State && (AD102.channel.m_RingOn1 >= 2 || AD102.channel.m_RingOn2 >= 2)) {
                            if (5 == AD102.channel.m_State) continue;
                            AD102.channel.m_RingOffTime = 0;
                            AD102.channel.m_State = 5;
                            AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 5, AD102.channel.m_State));
                            continue;
                        }
                        if (5 == AD102.channel.m_State) {
                            AD102.channel.m_RingOffTime += 100;
                            if (AD102.channel.m_RingOffTime >= 3700 && !AD102.channel.m_bCheckIdle) {
                                AD102.channel.m_bCheckIdle = true;
                                AD102.channel.m_CheckIdleTime = 0;
                            }
                        }
                        if (Voltage1 <= 3) {
                            if (!AD102.channel.m_bCheckPowerOff) {
                                AD102.channel.m_bCheckPowerOff = true;
                                AD102.channel.m_CheckPowerOffTime = 0;
                            }
                        } else if (Voltage1 > 3 && Voltage1 < 24) {
                            if (!AD102.channel.m_bCheckHookOff) {
                                AD102.channel.m_bCheckHookOff = true;
                                AD102.channel.m_CheckHookOffTime = 0;
                            }
                        } else if (Voltage1 >= 24 && 5 != AD102.channel.m_State && !AD102.channel.m_bCheckIdle) {
                            AD102.channel.m_bCheckIdle = true;
                            AD102.channel.m_CheckIdleTime = 0;
                        }
                    }
                    if (AD102.channel.m_bCheckPowerOff) {
                        AD102.channel.m_CheckPowerOffTime += 10;
                        if (AD102.channel.m_CheckPowerOffTime >= 3000 && 1 != AD102.channel.m_State) {
                            try {
                                AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 1, AD102.channel.m_State));
                            }
                            catch (Exception e) {
                                System.err.println("UsbController: " + e.getLocalizedMessage());
                            }
                            AD102.channel.m_State = 1;
                            AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 1, AD102.channel.m_State));
                            AD102.channel.m_bCheckIdle = false;
                            AD102.channel.m_CheckIdleTime = 0;
                            AD102.channel.m_bCheckPowerOff = false;
                            AD102.channel.m_CheckPowerOffTime = 0;
                            AD102.channel.m_bCheckHookOff = false;
                            AD102.channel.m_CheckHookOffTime = 0;
                            AD102.channel.m_bCheckRingOn = false;
                            AD102.channel.m_CheckRingOnTime = 0;
                        }
                    }
                    if (AD102.channel.m_bCheckIdle) {
                        AD102.channel.m_CheckIdleTime += 10;
                        if (AD102.channel.m_CheckIdleTime >= 800 && 2 != AD102.channel.m_State) {
                            int j;
                            String ringDuration = AD102.milliToString(AD102.channel.m_RingDuration);
                            String callDuration = AD102.milliToString(AD102.channel.m_CallDuration);
                            if (1 == AD102.channel.m_State) {
                                AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 1, 0));
                            } else if (5 == AD102.channel.m_State) {
                                AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 5, 0));
                            } else if (6 == AD102.channel.m_State) {
                                AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 6, 0));
                            } else if (7 == AD102.channel.m_State) {
                                AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 7, 0));
                            }
                            AD102.channel.Dialed = "";
                            AD102.channel.m_State = 2;
                            AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 2, AD102.channel.m_State));
                            AD102.channel.m_bCheckIdle = false;
                            AD102.channel.m_CheckIdleTime = 0;
                            AD102.channel.m_bCheckPowerOff = false;
                            AD102.channel.m_CheckPowerOffTime = 0;
                            AD102.channel.m_bCheckHookOff = false;
                            AD102.channel.m_CheckHookOffTime = 0;
                            AD102.channel.m_DtmfDetectTime = 0;
                            AD102.channel.m_CallDuration = 0;
                            AD102.channel.m_bCheckRingOn = false;
                            AD102.channel.m_CheckRingOnTime = 0;
                            AD102.channel.m_RingCnt = 0;
                            AD102.channel.m_RingOn1 = 0;
                            AD102.channel.m_RingOn2 = 0;
                            AD102.channel.m_bInbound = false;
                            AD102.channel.m_RingOffTime = 0;
                            AD102.channel.m_RingDuration = 0;
                            AD102.channel.m_FSKCIDDataSize = 0;
                            AD102.channel.m_iCarry = 0;
                            AD102.channel.m_DtmfSize = 0;
                            for (j = 0; j < AD102.channel.m_DtmfNum.length; ++j) {
                                AD102.channel.m_DtmfNum[j] = '\u0000';
                            }
                            for (j = 0; j < AD102.channel.m_szFSKCIDData.length; ++j) {
                                AD102.channel.m_szFSKCIDData[j] = 0;
                            }
                            for (j = 0; j < AD102.channel.m_FskNum.length; ++j) {
                                AD102.channel.m_FskNum[j] = '\u0000';
                            }
                        }
                    }
                    if (!AD102.channel.m_bCheckHookOff) continue;
                    if (!AD102.channel.m_bInbound && !AD102.channel.Dtmf.isEmpty() && 7 != AD102.channel.m_State) {
                        AD102.channel.m_DtmfDetectTime += 10;
                    }
                    AD102.channel.m_CheckHookOffTime += 10;
                    if (AD102.channel.m_CheckHookOffTime < 200) continue;
                    AD102.channel.m_bCheckIdle = false;
                    AD102.channel.m_CheckIdleTime = 0;
                    AD102.channel.m_bCheckPowerOff = false;
                    AD102.channel.m_CheckPowerOffTime = 0;
                    AD102.channel.m_bCheckHookOff = false;
                    AD102.channel.m_CheckHookOffTime = 0;
                    AD102.channel.m_bCheckRingOn = false;
                    AD102.channel.m_CheckRingOnTime = 0;
                    AD102.channel.m_RingCnt = 0;
                    AD102.channel.m_RingOn1 = 0;
                    AD102.channel.m_RingOn2 = 0;
                    AD102.channel.m_RingOffTime = 0;
                    if (AD102.channel.m_bInbound) {
                        if (6 == AD102.channel.m_State) continue;
                        AD102.channel.m_CallDuration = 0;
                        AD102.channel.m_State = 6;
                        AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 1, AD102.channel.m_State));
                        continue;
                    }
                    if (AD102.channel.m_DtmfDetectTime > 4000) {
                        if (7 == AD102.channel.m_State) continue;
                        AD102.channel.m_State = 7;
                        AD102.channel.m_CallDuration = 0;
                        AD102.channel.Dialed = AD102.channel.Dtmf;
                        AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 1, AD102.channel.m_State));
                        continue;
                    }
                    if (3 == AD102.channel.m_State) continue;
                    AD102.channel.m_State = 3;
                    AD102.this.notifyParent(new LineMessage(AD102.this.getLineId(), 3, AD102.channel.m_State));
                }
                catch (Exception e) {
                    System.err.println("Count Service: " + e.getMessage());
                }
            }
        }
    }

    private class UsbRunnable
    implements Runnable {
        private UsbRunnable() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int iLen = 0;
            int iPos = 0;
            int iChannel = 0;
            try {
                while (!AD102.this.mStop) {
                    try {
                        byte[] readBuff;
                        block20: {
                            block19: {
                                try {
                                    if (!AD102.this.IsThereAnyReceivedData()) {
                                        AD102.this.Sleep(1);
                                    }
                                    break block19;
                                }
                                catch (Exception e) {
                                    AD102.this.e("UsbRunnable IsThereAnyReceivedData: " + e.getMessage());
                                    AD102.this.Sleep(1);
                                }
                                continue;
                            }
                            readBuff = null;
                            try {
                                readBuff = AD102.this.GetReceivedDataFromQueue();
                                if (readBuff == null) {
                                    AD102.this.Sleep(1);
                                }
                                break block20;
                            }
                            catch (Exception e) {
                                AD102.this.Sleep(1);
                            }
                            continue;
                        }
                        try {
                            iLen = readBuff[1] - 4;
                            iChannel = readBuff[3] & 0x7F;
                            iPos = 6;
                            if (iChannel < 0 || iChannel >= 8 || iLen < 0) {
                                continue;
                            }
                        }
                        catch (Exception e) {
                            AD102.this.e("UsbRunnable Middle: " + e.getMessage());
                        }
                        if (AD102.this.mStop) break;
                        try {
                            channel.GetVoltage(readBuff[4] * 256 + readBuff[5] & 0xFFFF);
                        }
                        catch (Exception e) {
                            AD102.this.e("UsbRunnable Voltage: " + e.getMessage());
                        }
                        try {
                            byte szPacketLen;
                            while (iLen > 0 && (szPacketLen = readBuff[iPos + 1]) < iLen) {
                                AD102.this.AnalyseCommand(iChannel, readBuff, iPos, szPacketLen + 2);
                                iLen -= szPacketLen + 2;
                                iPos += szPacketLen + 2;
                            }
                        }
                        catch (Exception e) {
                            AD102.this.e("UsbRunnable Analyze;" + e.getLocalizedMessage());
                        }
                    }
                    catch (Exception e) {
                        AD102.this.e("UsbRunnable Exception:" + e.getLocalizedMessage());
                    }
                }
                AD102.this.dev.close();
                AD102.this.hid_mgr.release();
                System.gc();
                return;
            }
            catch (Exception e) {
                AD102.this.e("UsbRunnable out Exception:" + e.getLocalizedMessage());
            }
        }
    }

    private class UsbReadRunnable
    implements Runnable {
        private UsbReadRunnable() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!AD102.this.mStop) {
                    try {
                        byte[] mRecvBuffer = new byte[64];
                        int p = AD102.this.dev.readTimeout(mRecvBuffer, 100);
                        if (AD102.this.mStop) break;
                        if (p <= 0 || mRecvBuffer[0] != 3 || mRecvBuffer[1] <= 3) continue;
                        AD102.this.m_ReadBuffList.add(mRecvBuffer);
                    }
                    catch (Exception e) {
                        AD102.this.stop();
                    }
                }
                AD102.this.dev.close();
                AD102.this.hid_mgr.release();
                System.gc();
                return;
            }
            catch (Exception e) {
                AD102.this.stop();
            }
        }
    }
}

