/*
 * Decompiled with CFR 0.152.
 */
package com.codeminders.hidapi;

import com.codeminders.hidapi.AD102;
import com.codeminders.hidapi.LineMessage;

public class AD800 {
    public String LineStatus = "";
    public int LineVoltage = 0;
    public String VoiceTrigger = "";
    public String CallerId = "";
    public String Dtmf = "";
    public String Dialed = "";
    public String Version = "";
    public String Serial = "";
    public int m_Channel;
    public int m_FSKCIDDataSize;
    public int m_iCarry;
    public byte[] m_szFSKCIDData = new byte[128];
    public char[] m_FskNum = new char[33];
    public char[] m_DtmfNum = new char[33];
    public int m_DtmfSize;
    public int m_VoltageIndex;
    public int m_VoltageValue;
    public int[] m_VoltageArray = new int[256];
    public int m_CheckVoltageTime;
    public boolean m_bCheckPowerOff;
    public int m_CheckPowerOffTime;
    public boolean m_bCheckIdle;
    public int m_CheckIdleTime;
    public boolean m_bCheckHookOff;
    public int m_CheckHookOffTime;
    public int m_DtmfDetectTime;
    public int m_CallDuration;
    public int m_RingOn1;
    public int m_RingOn2;
    public boolean m_bCheckRingOn;
    public int m_CheckRingOnTime;
    public int m_RingCnt;
    public int m_RingOffTime;
    public int m_RingDuration;
    public int m_State;
    public boolean m_bInbound;
    private AD102 parent;

    public AD800(AD102 parent) {
        this.parent = parent;
        this.init();
    }

    public void init() {
        int i;
        this.LineStatus = "";
        this.LineVoltage = 0;
        this.VoiceTrigger = "";
        this.CallerId = "";
        this.Dtmf = "";
        this.Dialed = "";
        this.m_Channel = 0;
        this.m_FSKCIDDataSize = 0;
        this.m_iCarry = 0;
        for (i = 0; i < this.m_szFSKCIDData.length; ++i) {
            this.m_szFSKCIDData[i] = 0;
        }
        for (i = 0; i < this.m_FskNum.length; ++i) {
            this.m_FskNum[i] = '\u0000';
        }
        this.m_DtmfSize = 0;
        for (i = 0; i < this.m_DtmfNum.length; ++i) {
            this.m_DtmfNum[i] = '\u0000';
        }
        this.m_VoltageIndex = 0;
        this.m_CheckVoltageTime = 0;
        this.m_VoltageValue = 0;
        for (i = 0; i < 256; ++i) {
            this.m_VoltageArray[i] = 0;
        }
        this.m_bCheckPowerOff = false;
        this.m_CheckPowerOffTime = 0;
        this.m_bCheckIdle = false;
        this.m_CheckIdleTime = 0;
        this.m_bCheckHookOff = false;
        this.m_CheckHookOffTime = 0;
        this.m_DtmfDetectTime = 0;
        this.m_CallDuration = 0;
        this.m_bCheckRingOn = false;
        this.m_CheckRingOnTime = 0;
        this.m_RingOn1 = 0;
        this.m_RingOn2 = 0;
        this.m_RingCnt = 0;
        this.m_RingOffTime = 0;
        this.m_RingDuration = 0;
        this.m_State = 1;
        this.m_bInbound = false;
    }

    public void FskData(byte[] pszData1, int iPos, int iLen) {
        try {
            int j;
            if (2 != this.m_State && 4 != this.m_State && 5 != this.m_State) {
                return;
            }
            byte[] pszData = new byte[iLen];
            System.arraycopy(pszData1, iPos, pszData, 0, iLen);
            if (this.m_FSKCIDDataSize < 1) {
                for (int i = 0; i < iLen; ++i) {
                    int j2;
                    if (85 == pszData[i]) {
                        ++this.m_iCarry;
                        continue;
                    }
                    if (this.m_iCarry < 8) {
                        this.m_iCarry = 0;
                        this.m_FSKCIDDataSize = 0;
                        for (j2 = 0; j2 < this.m_szFSKCIDData.length; ++j2) {
                            this.m_szFSKCIDData[j2] = 0;
                        }
                        for (j2 = 0; j2 < this.m_FskNum.length; ++j2) {
                            this.m_FskNum[j2] = '\u0000';
                        }
                        continue;
                    }
                    if (pszData[i] != -128 && pszData[i] != -126 && pszData[i] != 4 && pszData[i] != 6) {
                        this.m_iCarry = 0;
                        this.m_FSKCIDDataSize = 0;
                        for (j2 = 0; j2 < this.m_szFSKCIDData.length; ++j2) {
                            this.m_szFSKCIDData[j2] = 0;
                        }
                        for (j2 = 0; j2 < this.m_FskNum.length; ++j2) {
                            this.m_FskNum[j2] = '\u0000';
                        }
                        continue;
                    }
                    if (this.m_FSKCIDDataSize + (iLen - i) >= this.m_szFSKCIDData.length) continue;
                    System.arraycopy(pszData, i, this.m_szFSKCIDData, this.m_FSKCIDDataSize, iLen - i);
                    this.m_FSKCIDDataSize += iLen - i;
                    break;
                }
            } else if (this.m_FSKCIDDataSize + iLen < this.m_szFSKCIDData.length) {
                System.arraycopy(pszData, 0, this.m_szFSKCIDData, this.m_FSKCIDDataSize, iLen);
                this.m_FSKCIDDataSize += iLen;
            } else {
                this.m_iCarry = 0;
                this.m_FSKCIDDataSize = 0;
                for (j = 0; j < this.m_szFSKCIDData.length; ++j) {
                    this.m_szFSKCIDData[j] = 0;
                }
                for (j = 0; j < this.m_FskNum.length; ++j) {
                    this.m_FskNum[j] = '\u0000';
                }
            }
            if (this.m_FSKCIDDataSize > 2 && this.m_szFSKCIDData[1] + 2 <= this.m_FSKCIDDataSize) {
                this.AnalyseFSKCID(this.m_szFSKCIDData, this.m_FSKCIDDataSize);
                this.m_iCarry = 0;
                this.m_FSKCIDDataSize = 0;
                for (j = 0; j < this.m_szFSKCIDData.length; ++j) {
                    this.m_szFSKCIDData[j] = 0;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Fsk: Exception:" + e.getLocalizedMessage());
        }
    }

    void AnalyseFSKCID(byte[] pszData, int iLen) {
        try {
            String s = "";
            for (int i = 0; i < iLen; ++i) {
                s = s + String.format("%x,", pszData[i]);
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        if (pszData[0] != -128 && pszData[0] != -126 && pszData[0] != 4 && pszData[0] != 6 && pszData[0] != 64) {
            return;
        }
        int iHeader1Pos = 0;
        int iHeader2Pos = 0;
        int iHeader3Pos = 0;
        int iNumHdrPos = 0;
        for (int i = 2; i < iLen; ++i) {
            if (2 == pszData[i] && iHeader1Pos == 0) {
                iHeader1Pos = i;
            }
            if (4 == pszData[i] && iHeader2Pos == 0) {
                iHeader2Pos = i;
            }
            if (3 != pszData[i] || iHeader3Pos != 0) continue;
            iHeader3Pos = i;
        }
        if (iHeader1Pos != 0) {
            iNumHdrPos = iHeader1Pos;
        } else if (iHeader2Pos != 0) {
            iNumHdrPos = iHeader2Pos;
        } else if (iHeader3Pos != 0) {
            iNumHdrPos = iHeader3Pos;
        }
        int iNumLen = pszData[iNumHdrPos + 1];
        if (4 == pszData[iNumHdrPos]) {
            iNumLen -= 8;
            iNumHdrPos += 8;
        }
        if (iNumLen > 0) {
            int i;
            if (iNumLen > 32) {
                iNumLen = 32;
            }
            for (i = 0; i < iNumLen; ++i) {
                this.m_FskNum[i] = (char)pszData[iNumHdrPos + 2 + i];
            }
            i = 0;
            while (i < iNumLen) {
                int n = i++;
                this.m_FskNum[n] = (char)(this.m_FskNum[n] & 0x7F);
            }
            String s = "";
            for (int i2 = 0; i2 < iNumLen; ++i2) {
                s = s + String.format("%c", Character.valueOf(this.m_FskNum[i2]));
            }
            this.CallerId = s;
            if (2 != this.m_State) {
                // empty if block
            }
            this.parent.notifyObservers(new LineMessage(this.m_Channel, 4, 4));
        }
    }

    public void DTMFData(byte[] pszData, int iPos, int iLen) {
        try {
            for (int i = 0; i < iLen; ++i) {
                int j;
                this.m_DtmfNum[this.m_DtmfSize] = this.DTMFToChar(pszData[i + iPos]);
                ++this.m_DtmfSize;
                if (this.m_DtmfSize >= 32) {
                    this.m_DtmfSize = 0;
                    for (j = 0; j < this.m_DtmfNum.length; ++j) {
                        this.m_DtmfNum[j] = '\u0000';
                    }
                }
                this.Dtmf = "";
                for (j = 0; j < this.m_DtmfSize; ++j) {
                    this.Dtmf = this.Dtmf + this.m_DtmfNum[j];
                }
                if ("".equals(this.Dtmf) || this.m_State != 3) continue;
                this.m_DtmfDetectTime = 0;
            }
        }
        catch (Exception e) {
            System.err.println("Dtmf: Exception:" + e.getLocalizedMessage());
        }
    }

    char DTMFToChar(byte szDTMF) {
        char szValue = '\u0000';
        switch (szDTMF) {
            case 10: {
                szValue = '0';
                break;
            }
            case 11: {
                szValue = '*';
                break;
            }
            case 12: {
                szValue = '#';
                break;
            }
            case 13: {
                szValue = 'A';
                break;
            }
            case 14: {
                szValue = 'B';
                break;
            }
            case 15: {
                szValue = 'C';
                break;
            }
            case 0: {
                szValue = 'D';
                break;
            }
            default: {
                if (szDTMF < 0 || szDTMF > 9) break;
                szValue = (char)(szDTMF + 48);
            }
        }
        return szValue;
    }

    public void GetVoltage(int Value) {
        if (this.m_VoltageIndex < 256) {
            this.m_VoltageArray[this.m_VoltageIndex] = (int)(((double)Value * 5.035477225909819E-5 - 1.65) * 60.0);
        }
        this.m_VoltageValue = (int)((double)this.m_VoltageValue + Math.abs(((double)Value * 5.035477225909819E-5 - 1.65) * 60.0));
        ++this.m_VoltageIndex;
    }
}

