/*
 * Decompiled with CFR 0.152.
 */
package com.codeminders.hidapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class ClassPathLibraryLoader {
    public static OSType getOSType() {
        String OS = System.getProperty("os.name", "generic").toLowerCase();
        if (OS.contains("mac") || OS.contains("darwin")) {
            return OSType.MacOS;
        }
        if (OS.contains("win")) {
            return OSType.Windows;
        }
        if (OS.contains("nux")) {
            return OSType.Linux;
        }
        return OSType.Other;
    }

    public static String getLibExtensionForOS(OSType os) {
        switch (os) {
            case Windows: {
                return "dll";
            }
            case MacOS: {
                return "jnilib";
            }
            case Linux: {
                return "so";
            }
        }
        return "unknown";
    }

    public static String getWindowsCPUType() {
        String arch = System.getenv("PROCESSOR_ARCHITEW6432");
        if (arch != null && !arch.isEmpty()) {
            return arch;
        }
        return System.getenv("PROCESSOR_ARCHITECTURE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLinuxCPUType() {
        try {
            Process p = Runtime.getRuntime().exec("uname -p");
            p.waitFor();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line = in.readLine();
                if (line == null) return "";
                String string = line;
                return string;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return "";
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLinuxCPUType2() {
        try {
            Process p = Runtime.getRuntime().exec("uname -m");
            p.waitFor();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line = in.readLine();
                if (line == null) return "";
                String string = line;
                return string;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return "";
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        return "";
    }

    public static String getCPUBitArch() {
        OSType os = ClassPathLibraryLoader.getOSType();
        String arch = "32";
        String type = "";
        if (os == OSType.Windows) {
            type = ClassPathLibraryLoader.getWindowsCPUType();
        } else if (os == OSType.Linux || os == OSType.MacOS) {
            type = ClassPathLibraryLoader.getLinuxCPUType();
        }
        if ((type == null || type.equals("unknown")) && (type = ClassPathLibraryLoader.getLinuxCPUType2()) == null) {
            return arch;
        }
        if (type.contains("64")) {
            arch = "64";
        } else if (type.contains("arm")) {
            arch = "arm";
        }
        System.out.println(os.name() + "-" + type);
        return arch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadNativeHIDLibrary() throws UnsatisfiedLinkError, Exception {
        boolean isLoaded;
        block8: {
            isLoaded = false;
            OSType os = ClassPathLibraryLoader.getOSType();
            String arch = ClassPathLibraryLoader.getCPUBitArch();
            String path = "/native/" + os.toString().toLowerCase() + "/libhidapi-jni-" + arch + "." + ClassPathLibraryLoader.getLibExtensionForOS(os);
            System.out.println("Trying to load: " + path);
            try {
                InputStream in = ClassPathLibraryLoader.class.getResourceAsStream(path);
                if (in == null) break block8;
                try {
                    int len;
                    String tempName = path.substring(path.lastIndexOf(47) + 1);
                    File fileOut = File.createTempFile(tempName.substring(0, tempName.lastIndexOf(46)), tempName.substring(tempName.lastIndexOf(46), tempName.length()));
                    fileOut.deleteOnExit();
                    FileOutputStream out = new FileOutputStream(fileOut);
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((OutputStream)out).close();
                    Runtime.getRuntime().load(fileOut.toString());
                    isLoaded = true;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e2) {
                System.err.println(e2.getMessage());
            }
        }
        return isLoaded;
    }

    public static enum OSType {
        Windows,
        MacOS,
        Linux,
        Other;

    }
}

