/*
 * Decompiled with CFR 0.152.
 */
package com.posics.beans;

import com.posics.beans.SaleculatorButtonIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;

class CentredBackgroundBorder
implements Border {
    private final BufferedImage image;

    protected CentredBackgroundBorder(BufferedImage image) {
        this.image = image;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int cx = (width - this.image.getWidth()) / 2;
        int cy = (height - this.image.getHeight()) / 2;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(x, y);
        g2.drawRenderedImage(this.image, AffineTransform.getTranslateInstance(cx, cy));
        g2.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    private static AbstractButton makeButton(String title) {
        return new JButton(title){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setVerticalAlignment(0);
                this.setVerticalTextPosition(0);
                this.setHorizontalAlignment(0);
                this.setHorizontalTextPosition(0);
                this.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
                this.setMargin(new Insets(2, 8, 2, 8));
                this.setBorderPainted(false);
                this.setContentAreaFilled(false);
                this.setFocusPainted(false);
                this.setOpaque(false);
                this.setForeground(Color.WHITE);
                this.setIcon(new SaleculatorButtonIcon(this));
            }
        };
    }
}

