/*
 * Decompiled with CFR 0.152.
 */
package com.posics.beans;

import com.posics.beans.JPasswordPanel;
import com.posics.beans.JPinEvent;
import com.posics.beans.JPinEventListener;
import com.posics.beans.LocaleResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JPasswordDialog
extends JDialog {
    private static LocaleResources m_resources;
    private static String m_password;
    private JPasswordPanel myPassword = null;
    private JPanel jPanel2;
    private JPanel jPanelGrid;
    private JPanel m_jPanelTitle;
    private JLabel m_lblMessage;

    public JPasswordDialog(Frame parent, boolean modal) {
        super(parent, modal);
        if (m_resources == null) {
            m_resources = new LocaleResources();
            m_resources.addBundleName("beans_messages");
        }
    }

    public JPasswordDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        if (m_resources == null) {
            m_resources = new LocaleResources();
            m_resources.addBundleName("beans_messages");
        }
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JPasswordDialog.getWindow(parent.getParent());
    }

    public static String showEditPassword(Component parent, String title) {
        return JPasswordDialog.showEditPassword(parent, title, null, null);
    }

    public static String showEditPassword(Component parent, String title, String message) {
        return JPasswordDialog.showEditPassword(parent, title, message, null);
    }

    public static String showEditPassword(Component parent, String title, String message, Icon icon) {
        Window window = JPasswordDialog.getWindow(parent);
        final JPasswordDialog myMsg = window instanceof Frame ? new JPasswordDialog((Frame)window, true) : new JPasswordDialog((Dialog)window, true);
        myMsg.initComponents();
        int dialogwidth = 400;
        myMsg.myPassword = new JPasswordPanel();
        myMsg.myPassword.addJPinEventListener(new JPinEventListener(){

            @Override
            public void pinEntered(JPinEvent e) {
                myMsg.setPin(e.getPin());
            }
        });
        myMsg.myPassword.addPropertyChangeListener("Password", new JPanelPasswordChange(myMsg));
        myMsg.jPanelGrid.add(myMsg.myPassword);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        myMsg.setBounds((screenSize.width - dialogwidth) / 2, (screenSize.height - 359) / 2, dialogwidth, 359);
        myMsg.setTitle(title, message, icon);
        m_password = null;
        myMsg.setVisible(true);
        return m_password;
    }

    private void setTitle(String title, String message, Icon icon) {
        this.setTitle(title);
        this.m_lblMessage.setText(message);
        this.m_lblMessage.setIcon(icon);
    }

    private void setPin(String pin) {
        m_password = pin;
        this.dispose();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanelGrid = new JPanel();
        this.m_jPanelTitle = new JPanel();
        this.m_lblMessage = new JLabel();
        this.setTitle(m_resources.getString("title.password"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JPasswordDialog.this.closeWindow(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanelGrid.setLayout(new GridLayout(1, 0, 5, 0));
        this.jPanel2.add((Component)this.jPanelGrid, "Center");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.m_jPanelTitle.setLayout(new BorderLayout());
        this.m_lblMessage.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_jPanelTitle.add((Component)this.m_lblMessage, "Center");
        this.getContentPane().add((Component)this.m_jPanelTitle, "North");
    }

    private void closeWindow(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class JPanelPasswordChange
    implements PropertyChangeListener {
        private JPasswordDialog m_me;

        public JPanelPasswordChange(JPasswordDialog me) {
            this.m_me = me;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            m_password = this.m_me.myPassword.getPassword();
        }
    }
}

