/*
 * Decompiled with CFR 0.152.
 */
package com.posics.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;

class SaleculatorButtonIcon
implements Icon {
    private static final Color TL = new Color(1.0f, 1.0f, 1.0f, 0.2f);
    private static final Color BR = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    private static final Color ST = new Color(1.0f, 1.0f, 1.0f, 0.2f);
    private static final Color SB = new Color(1.0f, 1.0f, 1.0f, 0.1f);
    private static final int R = 8;
    private int width;
    private int height;

    protected SaleculatorButtonIcon(JComponent c) {
        Insets i = c.getBorder().getBorderInsets(c);
        Dimension d = c.getPreferredSize();
        this.width = d.width - i.left - i.right;
        this.height = d.height - i.top - i.bottom;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Insets i = b.getBorder().getBorderInsets(b);
            int w = c.getWidth();
            int h = c.getHeight();
            this.width = w - i.left - i.right;
            this.height = h - i.top - i.bottom;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Double area = new RoundRectangle2D.Double(x - i.left, y - i.top, w - 1, h - 1, 8.0, 8.0);
            Color ssc = TL;
            Color bgc = BR;
            ButtonModel m = b.getModel();
            if (m.isPressed()) {
                ssc = SB;
                bgc = ST;
            } else if (m.isRollover()) {
                ssc = ST;
                bgc = SB;
            }
            g2.setPaint(new GradientPaint(0.0f, 0.0f, ssc, 0.0f, h, bgc, true));
            g2.fill(area);
            g2.setPaint(BR);
            g2.draw(area);
            g2.dispose();
        }
    }

    @Override
    public int getIconWidth() {
        return Math.max(this.width, 100);
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.height, 20);
    }
}

