/*
 * Decompiled with CFR 0.152.
 */
package com.posics.data.gui;

import com.posics.basic.BasicException;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.LocalRes;
import com.posics.data.user.BrowsableEditableData;
import com.posics.data.user.BrowseListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JListNavigator
extends JPanel
implements BrowseListener,
ListSelectionListener {
    protected BrowsableEditableData m_bd;
    private JScrollPane jScrollPane1;
    private JList m_jlist;

    public JListNavigator(BrowsableEditableData bd) {
        this(bd, false);
    }

    public JListNavigator(BrowsableEditableData bd, boolean bTouchable) {
        this.m_bd = bd;
        this.initComponents();
        if (bTouchable) {
            this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(35, 35));
            this.jScrollPane1.setHorizontalScrollBarPolicy(31);
            this.jScrollPane1.setVerticalScrollBarPolicy(22);
        }
        this.m_jlist.addListSelectionListener(this);
        this.m_jlist.setModel(this.m_bd.getListModel());
        this.m_bd.addBrowseListener(this);
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.m_jlist.setCellRenderer(cellRenderer);
    }

    @Override
    public void updateIndex(int iIndex, int iCounter) {
        if (iIndex >= 0 && iIndex < iCounter) {
            this.m_jlist.setSelectedIndex(iIndex);
        } else {
            this.m_jlist.setSelectedIndex(-1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        int i;
        if (!evt.getValueIsAdjusting() && (i = this.m_jlist.getSelectedIndex()) >= 0) {
            Rectangle oRect;
            if (!this.m_bd.isAdjusting()) {
                try {
                    this.m_bd.moveTo(i);
                }
                catch (BasicException eD) {
                    MessageInf msg = new MessageInf(-67108864, LocalRes.getIntString("message.nomove"), eD);
                    msg.show(this);
                }
            }
            if ((oRect = this.m_jlist.getCellBounds(i, i)) != null) {
                this.m_jlist.scrollRectToVisible(oRect);
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.m_jlist = new JList();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(200, 2));
        this.m_jlist.setSelectionMode(0);
        this.m_jlist.setFocusable(false);
        this.m_jlist.setRequestFocusEnabled(false);
        this.jScrollPane1.setViewportView(this.m_jlist);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

